static char RCSid[] = "$Id: mk_include.c,v 1.3 1990/09/08 11:56:46 waite Exp $";
/* Copyright, 1989, The Regents of the University of Colorado */
#include <stdio.h>

char *	gets();
char *	index();
char *	rindex();
char *	strcpy();
char *	strncpy();
char *	strcat();
char *	malloc();
FILE *	fopen();


main(argc, argv)
int argc; char *argv[];
/* Merge file names with their Odin keys
 *    On entry-
 *       argv[1]=name of the file containing the file names
 *       argv[2]=name of the file containing the Odin keys
 *       argv[3]=name of the output file
 *    On exit
 *       Each line of the output file has the form
 *          name@key
 */
{
   char FileName[BUFSIZ];
   FILE *namefile, *keyfile, *mergefile;

   if (argc < 4) {
      (void)fprintf(stderr,
         "mk_include: Usage %s namefile keyfile mergefile\n",
         argv[0]);
      exit(1);
   }

   if ((namefile = fopen(argv[1], "r")) == NULL) {
      (void)fprintf(stderr,
         "mk_include: Could not open namefile %s\n",
         argv[1]);
      exit(1);
   }

   if ((keyfile = fopen(argv[2], "r")) == NULL) {
      (void)fprintf(stderr,
         "mk_include: Could not open keyfile %s\n",
         argv[2]);
      exit(1);
   }

   if ((mergefile = fopen(argv[3], "w")) == NULL) {
      (void)fprintf(stderr,
         "mk_include: Could not open mergefile %s\n",
         argv[3]);
      exit(1);
   }

   while (fgets(FileName, BUFSIZ, namefile) != NULL) {
      char *q = FileName + strlen(FileName);

      do q--; while (*q <= ' ');
      *(q+1) = '@';
      if (fgets(q+2, BUFSIZ - ((q+2) - FileName), keyfile) == NULL) {
         (void)fprintf(stderr, "mk_include: More file names than keys\n");
         exit(1);
      }
      (void)fputs(FileName, mergefile);
   }
   (void)fclose(namefile); (void)fclose(keyfile); (void)fclose(mergefile);

   exit(0);
}
