static char RCSid[] = "$Id: cat-n.c,v 1.2 1992/08/06 20:14:34 kadhim Exp $";
/* Implementation of cat -n */
/* Copyright 1992, The Regents of the University of Colorado */

#include <stdio.h>

/***/
main()
/* Attach a sequence number to each line of a file
 *    On entry-
 *       stdin is a text file with each line having the form:
 *             data\n
 *    On exit-
 *       stdout is a text file with each line having the form:
 *             seq\tdata\n
 *          seq is the integer sequence number of the line
 *          data is unchanged from stdin
 ***/
{
	int c;
	int seq = 1;

	while ((c = getchar()) != EOF) {
		(void)printf("%d\t", seq++);
		do {
		     (void)putchar(c); 
		     c = getchar(); 
		} while ((c != EOF) && (c != '\n'));
		if (c == '\n') (void)putchar('\n');
	}

	return 0;
}
