
#include <stdio.h>
#include <malloc.h>
#include "ptg_gen.h"

void _PrPTGNULL(n)
_PPTG0 n;{/* function printing nothing */}

static struct _SPTG0   _PTGNULL = { _PrPTGNULL };
PTGNode PTGNULL =  & _PTGNULL;

#define MEMERR\
	{ fprintf(stderr, "Fatal ERROR: no memory available.\n"); exit(1); }

static FILE *f;

PTGNode PTGOut (r)
PTGNode r;
{
  f = stdout;
  if (r) (* (r->_print)) (r);
  return (r);
}

PTGNode PTGOutFile (fn, r)
char * fn; PTGNode r;
{
  if ((f = fopen(fn, "w"))  == (FILE *)NULL)
  {
	fprintf(stderr, "ERROR: output file can't be open.\n");
	exit(1);
  }
  if (r) (* (r->_print)) (r);
  fclose(f);
  return (r);
}

PTGNode PTGOutFPtr(fptr, r)
FILE * fptr; PTGNode r;
{
  if ((f = fptr) == (FILE *)NULL)
  {
    fprintf(stderr, "ERROR: output file not open.\n");
    exit(1);
  }
  if (r) (* (r->_print)) (r);
  return (r);
}

typedef struct _SPTG5 *_PPTG5;
struct _SPTG5{
  _PTGProc _print;
  PTGNode _desc [5];
};

typedef struct _SPTG4 *_PPTG4;
struct _SPTG4{
  _PTGProc _print;
  PTGNode _desc [4];
};

typedef struct _SPTG3 *_PPTG3;
struct _SPTG3{
  _PTGProc _print;
  PTGNode _desc [3];
};

typedef struct _SPTG2 *_PPTG2;
struct _SPTG2{
  _PTGProc _print;
  PTGNode _desc [2];
};

typedef struct _SPTG1 *_PPTG1;
struct _SPTG1{
  _PTGProc _print;
  PTGNode _desc [1];
};

typedef struct _SPTGName *_PPTGName;
struct _SPTGName{
  _PTGProc _print;
  char *_t0;
};

typedef struct _SPTGNumb *_PPTGNumb;
struct _SPTGNumb{
  _PTGProc _print;
  int _t0;
};

void _PrPTGHeaderHead(n)
_PPTG0 n;
{
  fputs ("\n#ifndef _PTG_DEF\
\n#define _PTG_DEF\
\ntypedef void (* _PTGProc) ();\n\
\ntypedef struct _SPTG0 * _PPTG0;\n\
\ntypedef _PPTG0 PTGNode;\n\
\nstruct _SPTG0 { _PTGProc _print; };\n\
\n/* predefined value for empty PTG nodes */\
\nextern PTGNode PTGNULL;\n\
\n/* output functions */\
\nextern PTGNode PTGOut ();\
\nextern PTGNode PTGOutFile ();\
\nextern PTGNode PTGOutFPtr ();\n\
\n/* functions for making PTG nodes */", f);
}

void _PrPTGHeaderTail(n)
_PPTG0 n;
{
  fputs ("\n#endif\n", f);
}

void _PrPTGExternFct(n)
_PPTG1 n;
{
  fputs ("\nextern PTGNode ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("();", f);
}

void _PrPTGFileHead(n)
_PPTG0 n;
{
  fputs ("\n#include <stdio.h>\
\n#include <malloc.h>\
\n#include \"ptg_gen.h\"\n\
\nvoid _PrPTGNULL(n)\
\n_PPTG0 n;{/* function printing nothing */}\n\
\nstatic struct _SPTG0   _PTGNULL = { _PrPTGNULL };\
\nPTGNode PTGNULL =  & _PTGNULL;\n\
\n#define MEMERR\\\
\n\t{ fprintf(stderr, \"Fatal ERROR: no memory available.\\n\"); exit(1); }\n\
\nstatic FILE *f;\n\
\nPTGNode PTGOut (r)\
\nPTGNode r;\
\n{\
\n  f = stdout;\
\n  if (r) (* (r->_print)) (r);\
\n  return (r);\n}\n\
\nPTGNode PTGOutFile (fn, r)\
\nchar * fn; PTGNode r;\
\n{\
\n  if ((f = fopen(fn, \"w\"))  == (FILE *)NULL)\
\n  {\n\tfprintf(stderr, \"ERROR: output file can't be open.\\n\");\
\n\texit(1);\n  }\
\n  if (r) (* (r->_print)) (r);\
\n  fclose(f);\
\n  return (r);\n}\n\
\nPTGNode PTGOutFPtr(fptr, r)\
\nFILE * fptr; PTGNode r;\
\n{\
\n  if ((f = fptr) == (FILE *)NULL)\
\n  {\n    fprintf(stderr, \"ERROR: output file not open.\\n\");\
\n    exit(1);\n  }\
\n  if (r) (* (r->_print)) (r);\
\n  return (r);\n}\n", f);
}

void _PrPTGFileTail(n)
_PPTG0 n;
{
  fputs ("\n", f);
}

void _PrPTGPtrTypeDef(n)
_PPTG2 n;
{
  fputs ("\ntypedef ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" *", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (";", f);
}

void _PrPTGNodeStructName(n)
_PPTG1 n;
{
  fputs ("struct _SPTG", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGNodePtrName(n)
_PPTG1 n;
{
  fputs ("_PPTG", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGLeafStructName(n)
_PPTG1 n;
{
  fputs ("struct _SPTG", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGLeafPtrName(n)
_PPTG1 n;
{
  fputs ("_PPTG", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGStructDecl(n)
_PPTG2 n;
{
  fputs ("\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("{", f);
  fputs ("\n  _PTGProc _print;", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\n};\n", f);
}

void _PrPTGDescField(n)
_PPTG1 n;
{
  fputs ("\n  PTGNode _desc [", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("];", f);
}

void _PrPTGGenFctName(n)
_PPTG1 n;
{
  fputs ("PTG", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGParmName(n)
_PPTG1 n;
{
  fputs ("_t", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGGenFctHead(n)
_PPTG4 n;
{
  fputs ("\nPTGNode ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (")", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("\n{\n  ", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  fputs (" n;", f);
}

void _PrPTGGenFctBody(n)
_PPTG5 n;
{
  fputs ("\n\n  if ((n = (", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (") malloc (sizeof (", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (")))  ==  (", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs (")NULL)\n\tMEMERR", f);
  fputs ("\n  n->_print = ", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  fputs (";", f);
  (* (n->_desc [4]->_print))(n->_desc[4]);
  fputs ("\n  return ((PTGNode) n);\n}\n", f);
}

void _PrPTGNodeParmSpecs(n)
_PPTG1 n;
{
  fputs ("\nPTGNode ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";", f);
}

void _PrPTGIntSpec(n)
_PPTG1 n;
{
  fputs ("\n  int ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";", f);
}

void _PrPTGStringSpec(n)
_PPTG1 n;
{
  fputs ("\n  char *", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";", f);
}

void _PrPTGPointerSpec(n)
_PPTG1 n;
{
  fputs ("\n  void *", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";", f);
}

void _PrPTGNodeAssign(n)
_PPTG2 n;
{
  fputs ("\n  n->_desc[", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("]=", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (";", f);
}

void _PrPTGLeafAssign(n)
_PPTG2 n;
{
  fputs ("\n  n->", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("=", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (";", f);
}

void _PrPTGPrintFctName(n)
_PPTG1 n;
{
  fputs ("_PrPTG", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGPrintFct(n)
_PPTG3 n;
{
  fputs ("\nvoid ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(n)", f);
  fputs ("\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" n;\n{", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("\n}\n", f);
}

void _PrPTGPrintStmt(n)
_PPTG1 n;
{
  fputs ("\n  fputs (", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (", f);", f);
}

void _PrPTGVisit(n)
_PPTG2 n;
{
  fputs ("\n  (* (n->_desc [", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("]->_print))", f);
  fputs ("(n->_desc[", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("]);", f);
}

void _PrPTGUserExternFct(n)
_PPTG1 n;
{
  fputs ("\nextern void ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("();\n", f);
}

void _PrPTGCall(n)
_PPTG1 n;
{
  fputs ("\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(f);", f);
}

void _PrPTGPrintInt(n)
_PPTG1 n;
{
  fputs ("\n  fprintf (f, \"%d\",", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (");", f);
}

void _PrPTGPrintString(n)
_PPTG1 n;
{
  fputs ("\n  fprintf (f, \"%s\",", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (");", f);
}

void _PrPTGPrintPointer(n)
_PPTG1 n;
{
  fputs ("\n  printf (f, \"%p\",", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (");", f);
}

void _PrPTGArg(n)
_PPTG1 n;
{
  fputs ("n->_t", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGUserCall(n)
_PPTG2 n;
{
  fputs ("\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(f", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (");", f);
}

void _PrPTGSeq(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGSeqCom(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (",", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGComSeq(n)
_PPTG2 n;
{
  fputs (",", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGComVal(n)
_PPTG1 n;
{
  fputs (",", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGName(n)
_PPTGName n;
{
  fprintf (f, "%s",n->_t0);
}

void _PrPTGNumb(n)
_PPTGNumb n;
{
  fprintf (f, "%d",n->_t0);
}

PTGNode PTGHeaderHead()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGHeaderHead;
  return ((PTGNode) n);
}

PTGNode PTGHeaderTail()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGHeaderTail;
  return ((PTGNode) n);
}

PTGNode PTGExternFct(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGExternFct;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGFileHead()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGFileHead;
  return ((PTGNode) n);
}

PTGNode PTGFileTail()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGFileTail;
  return ((PTGNode) n);
}

PTGNode PTGPtrTypeDef(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGPtrTypeDef;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGNodeStructName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGNodeStructName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGNodePtrName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGNodePtrName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGLeafStructName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGLeafStructName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGLeafPtrName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGLeafPtrName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGStructDecl(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGStructDecl;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGDescField(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGDescField;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGGenFctName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGGenFctName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGParmName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGParmName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGGenFctHead(_t0,_t1,_t2,_t3)
PTGNode _t0,_t1,_t2,_t3;
{
  _PPTG4 n;

  if ((n = (_PPTG4) malloc (sizeof (struct _SPTG4)))  ==  (_PPTG4)NULL)
	MEMERR
  n->_print = _PrPTGGenFctHead;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  return ((PTGNode) n);
}

PTGNode PTGGenFctBody(_t0,_t1,_t2,_t3,_t4)
PTGNode _t0,_t1,_t2,_t3,_t4;
{
  _PPTG5 n;

  if ((n = (_PPTG5) malloc (sizeof (struct _SPTG5)))  ==  (_PPTG5)NULL)
	MEMERR
  n->_print = _PrPTGGenFctBody;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  n->_desc[4]=_t4;
  return ((PTGNode) n);
}

PTGNode PTGNodeParmSpecs(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGNodeParmSpecs;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGIntSpec(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGIntSpec;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGStringSpec(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGStringSpec;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGPointerSpec(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGPointerSpec;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGNodeAssign(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGNodeAssign;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGLeafAssign(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGLeafAssign;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGPrintFctName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGPrintFctName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGPrintFct(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGPrintFct;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGPrintStmt(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGPrintStmt;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGVisit(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGVisit;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGUserExternFct(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGUserExternFct;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGCall(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGCall;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGPrintInt(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGPrintInt;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGPrintString(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGPrintString;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGPrintPointer(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGPrintPointer;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGArg(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGArg;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGUserCall(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGUserCall;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGSeq(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGSeqCom(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGSeqCom;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGComSeq(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGComSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGComVal(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGComVal;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGName(_t0)
  char *_t0;
{
  _PPTGName n;

  if ((n = (_PPTGName) malloc (sizeof (struct _SPTGName)))  ==  (_PPTGName)NULL)
	MEMERR
  n->_print = _PrPTGName;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGNumb(_t0)
  int _t0;
{
  _PPTGNumb n;

  if ((n = (_PPTGNumb) malloc (sizeof (struct _SPTGNumb)))  ==  (_PPTGNumb)NULL)
	MEMERR
  n->_print = _PrPTGNumb;
  n->_t0=_t0;
  return ((PTGNode) n);
}

