# $Id: Makefile.cpp,v 1.37 1992/07/13 05:07:16 kadhim Exp $
# Copyright (c) 1989, The Regents of the University of Colorado

SHELL	= /bin/sh

# Default master cache location
DESTDIR	= ELISYS

#ifdef _AIX
ACC     = cc -qlanglvl=ansi
#else
ACC	= $(CC)
#endif

CFLAGS	=

SYS	= mak.parser frame.options p.pars.frame parse.h parse.c \
	  eingabe.err StructConn dfltparse.c
AUX	= pgs.dg
SRC	= eingabe.c analyse.c pgs_optim.c buildtab.c parameter.h \
	  obstack.c obstack.h p2c.h p2clib.c
CMD	= pgsBnf.cmd pgsInfo.cmd pgsProd.cmd 
EXE	= eingabe.exe analyse.exe pgs_optim.exe buildtab.exe

TIDY	= *.o *.a core a.out ERRS
CLEAN	= $(TIDY) *.exe

all:	$(EXE) $(CMD) $(SYS)
	@for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/Tool/pgs/$$f $(DESTDIR)/Cmd/$$f; \
		done

install:
	@for f in $(CMD); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/pgs; \
		rm -f $(DESTDIR)/Tool/pgs/$$f; \
		cp $$f $(DESTDIR)/Tool/pgs/$$f; \
		chmod 644 $(DESTDIR)/Tool/pgs/$$f; \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/Tool/pgs/$$f $(DESTDIR)/Cmd/$$f; \
		done
	@for f in $(EXE); do \
		echo install -c -m 755 $$f $(DESTDIR)/Tool/pgs; \
		rm -f $(DESTDIR)/Tool/pgs/$$f; \
		cp $$f $(DESTDIR)/Tool/pgs/$$f; \
		chmod 755 $(DESTDIR)/Tool/pgs/$$f; \
		done
	@for f in $(SYS); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/pgs; \
		rm -f $(DESTDIR)/Tool/pgs/$$f; \
		cp $$f $(DESTDIR)/Tool/pgs/$$f; \
		chmod 644 $(DESTDIR)/Tool/pgs/$$f; \
		done

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp $(SRC) $(AUX) p2c.a

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

.c.o:
	$(ACC) -c $(CFLAGS) $<

eingabe.o:	eingabe.c parameter.h obstack.h p2c.h
eingabe.exe:	eingabe.o obstack.o p2c.a
	$(ACC) $(CFLAGS) -o $@ eingabe.o obstack.o p2c.a -lm

analyse.o:	analyse.c parameter.h obstack.h p2c.h
analyse.exe:	analyse.o obstack.o p2c.a
	$(ACC) $(CFLAGS) -o $@ analyse.o obstack.o p2c.a -lm

pgs_optim.o:	pgs_optim.c parameter.h obstack.h p2c.h
pgs_optim.exe:	pgs_optim.o obstack.o p2c.a
	$(ACC) $(CFLAGS) -o $@ pgs_optim.o obstack.o p2c.a -lm

buildtab.exe:	buildtab.c p2c.a
	$(ACC) $(CFLAGS) -o $@ buildtab.c p2c.a -lm

#if defined(sgi) || defined(hpux)
p2c.a:	p2clib.o
	ar rcus $@ p2clib.o
#else
p2c.a:	p2clib.o
	ar rcu $@ p2clib.o
	ranlib $@
#endif
