/* $Id: header.c,v 1.2 1992/07/11 20:56:14 kadhim Exp $ */
/* Attribution computations for header output generation */
/* Copyright (c) 1992, The Regents of the University of Colorado */

#include <stdio.h>
#include <malloc.h>
#include "err.h"	/* error module */
#include "deftbl.h"	/* definition table */
#include "envmod.h"	/* environment module */
#include "ptg_gen.h"	/* output generation functions */
#include "func.h"	/* header for source output generation */
#include "pdl_gen.h"	/* PDL generated functions */
#include "csm.h"	/* string table module */

/* global constants */

#define FALSE      0
#define TRUE       1

/* string table indices for predefined operations */
extern int GetHandle, SetHandle;

/* Generate extern declarations for each of the generated functions */
PTGNode
GenExterns (key, type, env, list)
DefTableKey key;	/* deftbl key for the type */
int type;		/* string table index for type */
Environment env;	/* operation declaration environment */
funclist list;		/* list of operations associated with this type */
{
  PTGNode result;
  DefTableKey SetKey, GetKey;
  ExtOutput out;

  /* If the externs have already been generated, do not generate them again */
  if (!GetGenExts(key, FALSE)) {
    /* Always generate Get and Set */
    SetKey=KeyInEnv(env, SetHandle);
    GetKey=KeyInEnv(env, GetHandle);
    out=GetExtOut(GetKey,PTGNULL);
    result=PTGExternSpec(out.type,out.opname,PTGIdentifier(type),
			 out.paramlist);
    out=GetExtOut(SetKey,PTGNULL);
    result=PTGSeq(result,PTGExternSpec(out.type,out.opname,PTGIdentifier(type),
				       out.paramlist));

    /* For each of the operations in the list, append its output to the */
    /* already generated output */
    while (list) {
      out=GetExtOut(list->key,PTGNULL);
      result=PTGSeq(result,PTGExternSpec(out.type,out.opname,
					 PTGIdentifier(type),out.paramlist));
      list=list->next;
    }

    /* Indicate that the output has now been generated */
    SetGenExts(key, TRUE, TRUE);
    return PTGExterns(PTGIdentifier(type), result);
  } else
    return PTGNULL;
}

/* Generate the appropriate macros for property declarations */
PTGNode
GenMacros (key, prop, env, list)
DefTableKey key;	/* deftbl key for property */
int prop;		/* string table index for property */
Environment env;	/* operation declaration environment */
funclist list;		/* list of operations associated with this property */
{
  DefTableKey SetKey, GetKey;
  PTGNode result;
  int opidn, idn;
  static int PropCtr;  /* unique index for each property */

  /* If the macros have already been generated, do not generate them again */
  if (!GetGenMacros(key, FALSE)) {
    /* Increment the property counter */
    ++PropCtr;

    /* Always generate the macros for Get and Set */
    idn=GetSym(GetType(key, NoKey), 0);
    SetKey=KeyInEnv(env, SetHandle);
    GetKey=KeyInEnv(env, GetHandle);
    result=PTGSeq(PTGMacro(PTGIdentifier(SetHandle), PTGIdentifier(prop),
			GetArgList(SetKey, PTGNULL),
			PTGIdentifier(SetHandle), PTGIdentifier(idn),
			PTGNum(PropCtr), GetFormalList(SetKey, PTGNULL)),
		  PTGMacro(PTGIdentifier(GetHandle), PTGIdentifier(prop),
			GetArgList(GetKey, PTGNULL),
			PTGIdentifier(GetHandle), PTGIdentifier(idn),
			PTGNum(PropCtr), GetFormalList(GetKey, PTGNULL)));

    /* For each operation in the list, append the macro for that operation */
    /* to the output generated so far */
    while (list) {
      opidn=GetSym(list->key, 0);
      result=PTGSeq(PTGMacro(PTGIdentifier(opidn), PTGIdentifier(prop), 
				GetArgList(list->key, PTGNULL),
				PTGIdentifier(opidn), PTGIdentifier(idn),
				PTGNum(PropCtr), 
				GetFormalList(list->key, PTGNULL)),
		    result);
      list=list->next;
    }

    /* Indicate that the macros have now been generated */
    SetGenMacros(key, TRUE, TRUE);
    return result;
  } else
    return PTGNULL;
}

/* Build a structure to hold information for generation of an extern */
ExtOutput
BuildExternSpec (type, opname, paramlist)
PTGNode type, opname, paramlist;
{
  ExtOutput *temp;

  if (!(temp = (ExtOutput *) malloc(sizeof(ExtOutput))))
    message(DEADLY, "BuildExternSpec: malloc failed", 0, (POSITION *)0);
  else {
    temp->type = type;
    temp->opname = opname;
    temp->paramlist = paramlist;
    return *temp;
  }
}
