/*
  $Id: oiladt2.h,v 1.9 91/06/18 17:13:08 swain Exp $
Copyright, 1989, The Regents of the University of Colorado
*/

#define ForDebugging 1

/* 'ForDebugging' is used by 'oiladt2b.c' to select the output of the
        compiler which contains the 'sID' component.  Originally designed to be
	removed for a 'release' to save space but never seen as worthwhile.
	*/

#define WithIDs 1

/* 'WithIDs' indicates that an extract 'sID' component is maintained in 
	the data structures.  This, sID, field is a unique number 
	associated with each object for use in inter-object references 
	when 'dumping' the objects out to a file in form suitible for 
	compilation.
	  The field sStat is used to mark those fields which have been
	visited while dumping and need not be dumped again.  This field
	is also used to emit 'extern' stmts as necessary;
	*/
#ifdef WithIDs
#define OilDefID int sID, sStat;
#else
#define OilDefID
#endif

/*
#define oilName char *
*/
#define oilName int

#define BOOL int
#define TRUE 1
#define FALSE 0
#define nil 0

typedef struct Stype {
	OilDefID /* used in compiler and debugging but not in release version */
	oilName sName;		/* type denotation */
	struct ScoercionSeq
		*sCoercionCosts;/* coercions from this type to others */
	struct Ssig *sSigs;	/* signatures whose 'top' type is this */
	struct StypeSet
		*sResultSets;	/* RSs whose last element is this */
	struct Sop *sOps;	/* Ops which result in this type */
	} *tOilType;

typedef struct Ssig {
	OilDefID /* used in compiler and debugging but not in release version */
	struct Ssig *sNext;	/* next argument type in signature */
	tOilType sArg;		/* a specific type */
	struct Ssig *sSameType;	/* other sigs which end in this type */
	} *tOilArgSig;

typedef struct Sop {
	OilDefID /* used in compiler and debugging but not in release version */
	oilName sName;	/* operator denotation */
	int sCost;	/* its cost */
	tOilArgSig sArgs;	/* type signature of arguments */
	struct Sop *sSameType;	/* other ops with the same result type */
	struct SopIdent *sIndOps; /* the identifiable ops */
	} *tOilOp;

typedef struct ScoercionSeq {
	OilDefID /* used in compiler and debugging but not in release version */
	tOilType sResultType;	/* type of result of coercion sequence */
	struct ScoercionSeq
		*sNextCost;/* next coercion which can be applied to this type */
	tOilOp sCoercionOp;	/* the coercion operator used here */
	struct ScoercionSeq
		*sCoercionSeq;	/* rest of coercion sequence */
	int sCost;		/* total cost of coercion sequence */
	} *tOilCoercionSeq;

typedef struct StypeSet {
	OilDefID /* used in compiler and debugging but not in release version */
	tOilType sBaseType;	/* 'A' type which can be directly referrenced */
	struct StypeSet
		*sNext;	/* the other types which can be directly referenced */
	int sCost;		/* the cost to get to this type */
	struct StypeSet
		*sSameType;	/* other sets with this base type */
	} *tOilTypeSet;

typedef struct SsetSig {
	OilDefID /* used in compiler and debugging but not in release version */
	struct SsetSig *sNext;	 /* next in signature list */
	tOilTypeSet sResultTypes;/* list of possible argument types */
	} *tOilSetSig;

typedef struct SopIdent {
	OilDefID /* used in compiler and debugging but not in release version */
	struct SopIdent *sNext;/* next in list */
	tOilOp sOp;			/* which op to identify */
	} *tOilOpIdentification;

typedef enum{
	eClassRef,	/* refers to the created type */
	eElementRef,	/* refers to the element used to derive type */
	eSpecTypeRef	/* refers to a specific type */
	} tOilClassSigArgDesc;

typedef struct SclassArgSig {
	OilDefID /* used in compiler and debugging but not in release version */
	struct SclassArgSig *sAnother;	/* tail sharing ptr */
	struct SclassArgSig *sNext;	/* next in list */
	tOilClassSigArgDesc sDescPattern;
	tOilType sRefdType;		/* possibly refers to a specific type */
	int sParamIndex;		/* or a specific parameter */
	} *tOilClassArgSig;

typedef struct SclassOp {
	OilDefID /* used in compiler and debugging but not in release version */
	struct SclassOp *sNext;
	oilName sName;		/* operator denotation */
	tOilClassArgSig sArgDesc;	/*  list of argument descriptions */
	int sCost;		/* cost of operator */
	BOOL isCoercion;	/* defs a coercion */
	struct SclassOpId *sIdents;	/* indications */
	} *tOilClassOp;

typedef struct SclassOpId { 
	OilDefID /* used in compiler and debugging but not in release version */
	struct SclassOpId *sNext;/* next in list */
	tOilOp sOpInd;		/* which operator indication is enhanced */
	} *tOilClassOpId;

typedef struct Sclass {
	OilDefID /* used in compiler and debugging but not in release version */
	oilName sName;			/* class denotation */
	int sNumArg;			/* number of args to class */
	tOilClassOp sClassOps;	/* description of operator */
	} *tOilClass;

#define OilNew(ptr,str) (ptr)malloc(sizeof(struct str))

#define OilMaxCost 32000

	/* the end of oiladt2.h */
