/* $Id: envmod.h,v 1.8 91/05/06 10:31:50 tony Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */

#ifndef ENVMOD_DEF
#define ENVMOD_DEF

#define MAXIDN 2047	/* Maximum number of identifiers */


typedef struct pelt {		/* Representation of an ext/int relation */
	int 	     idn;	/* Identifier */
	char 	    *key;	/* definition table key */
	struct pelt *nxt;  	/* Next relation in this scope */
} POSSESSION;



typedef struct scelt {		/* Representation of a scope */
	POSSESSION *poss;	/* Relations defined in this scope */
} SCOPE;



typedef struct tbl {			/* access table */
	struct aelt *cur;  		/* current environment */
	struct selt *ptbl[MAXIDN];	/* Possession stacks */
} ACCESS;



typedef struct aelt {		/* Addressing environment */
	SCOPE 	    *scp;	/* Innermost scope */
	struct aelt *env;  	/* Immediately enclosing scope */
	ACCESS 	    *acc;	/* Constant-time access function */
} ENVIRONMENT;



typedef struct selt {		/* Possession stack for identifier */
	POSSESSION  *cur;	/* Current possession */
	ENVIRONMENT *env;	/* possession's environment */
	struct selt *out;  	/* Superseded possessions */
} PSTACK;




/* The following routines are exported by the
   Environment Module
*/


/* NewEnv: obtain a new environment
   On exit -
      NewEnv returns an environment consisting of an empty scope
*/
extern ENVIRONMENT *NewEnv ();



/* NewScope: create a new scope within a given environment
   on entry -
      e = environment in which to create the new scope
   on exit-
      a new empty scope is created in e on top of the previously
      current scope in e;
      the new scope is made the current scope of the environment;
      NewScope returns the updated environment
*/
#if defined(__cplusplus) || defined(__STDC__)
extern ENVIRONMENT *NewScope (ENVIRONMENT *e);
#else
extern ENVIRONMENT *NewScope (/* ENVIRONMENT *e */);
#endif




/* KeyInEnv: obtain the definition of an identifier in a given environment
   on entry-
      e = environment in which the definition is sought
      i = identifier whose definition is sought
   on exit-
      if i is defined in e
         the definition table key of i is returned,
      otherwise,
         the reserved key NoDef() is returned
*/
#if defined(__cplusplus) || defined(__STDC__)
extern char *KeyInEnv (ENVIRONMENT *e, int i);
#else
extern char *KeyInEnv (/* ENVIRONMENT *e, int i */);
#endif




/* KeyInScope: obtain a definition from the current scope of an environment
   on entry-
      e = environment in which the definition is sought
      i = identifier whose definition is sought
   on exit-
      if i is defined in the current scope of e
         the definition table key of i (in the current scope of e)
         is returned,
      otherwise,
         the reserved key NoDef() is returned
*/
#if defined(__cplusplus) || defined(__STDC__)
extern char *KeyInScope (ENVIRONMENT *e, int i);
#else
extern char *KeyInScope (/* ENVIRONMENT *e, int i */);
#endif




/* DefineIdn: define an identifier in the inner scope of an environment --
   on entry -
      e = environment in which to define the identifier
      i = identifier to be defined
   on exit -
      if i was already defined in the inner scope of e,
	 the corresponding definition table key is returned
      otherwise,
	 a new definition table key is returned and entered
	 into the inner scope of e
*/
#if defined(__cplusplus) || defined(__STDC__)
extern char *DefineIdn (ENVIRONMENT *e, int i);
#else
extern char *DefineIdn (/* ENVIRONMENT *e, int i */);
#endif




/* AddIdn: define an identifier in the inner scope of an environment
   with a given key --
   on entry -
      e = environment in which to define the identifier
      i = identifier to be defined
      k = definition table key
   on exit -
      if i was already defined in the inner scope of e,
	 the corresponding definition table key is returned
      otherwise,
	 i becomes defined in the inner scope of e with the
	 given definition table key k
*/
#if defined(__cplusplus) || defined(__STDC__)
extern char *AddIdn (ENVIRONMENT *e, int i, char *k);
#else
extern char *AddIdn (/* ENVIRONMENT *e, int i, char *k */);
#endif

#endif
