# $Id: Makefile.cpp,v 1.11 1991/09/04 13:01:00 waite Exp $
# Copyright (c) 1991, The Regents of the University of Colorado

SHELL	= /bin/sh
CFLAGS	=

COFLAGS	= -q

SRC	= obstack.specs obstack.c obstack.h

TIDY	= core a.out
CLEAN	= $(TIDY)
CLOBBER	= $(CLEAN) Makefile

all:	$(SRC)

install:
	@for f in $(SRC); do \
		echo install -m 644 $$f $(DESTDIR)/Tool/obstack; \
		rm -f $(DESTDIR)/Tool/obstack/$$f; \
		cp $$f $(DESTDIR)/Tool/obstack/$$f; \
		chmod 644 $(DESTDIR)/Tool/obstack/$$f; \
		done

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp

SourceDistr: $(SRC)

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

rcsclean:
	-rcsclean $(COFLAGS) $(SRC) Makefile.cpp
	rm -rf $(CLEAN) Makefile

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(SRC)
	-rcs -bOriginal.1 -q Makefile.cpp $(SRC)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q $(SRC)

.PRECIOUS:	$(SRC)
