/***********************************************************************\
*									*
*		Implementation of a LIGA pass				*
*		    -- Interface Analyzer --				*
*									*
*	Module:		Show    					*
*	File:		show.c						*
*	Contents:	main function of sceleton pass			*
*	Author:		U. Kastens					*
*	Creation date:	26 Nov 1991					*
*	Last change:	28 Nov 1991					*
*									*
\***********************************************************************/

static char rcs_id[]= "$Id: show.c,v 3.1 1992/03/04 15:21:30 uwe Exp $";

/* $Revision: 3.1 $ */

#include <stdio.h>

#include "LIGA.h"
#include "showproc.h"
#include "map_errors.h"

/*
** GLOBAL VARIABLES
*/

AttrEval IdlStruct;

FILE	*InputFile;
FILE    *ErrMapFile;
/*
** LOCAL VARIABLES
*/

char	*InputFName;
char	*ErrMapFName;

/*
** LOCAL FUNCTIONS
*/

#ifdef __STDC__
void usage (char *progname)
#else
void usage (progname)
char *progname;
#endif
/* tell users how to use this program					*/
{
	(void) printf ("usage: %s -i infile -e errmapfile\n",
		progname);
	exit (1);
} /* usage() */


/*
** GLOBAL FUNCTIONS
*/

#ifdef __STDC__
int main (int argc, char *argv[])
#else
int main (argc, argv)
int argc;
char *argv[];
#endif
/* main program of expand module					*/
{
	char *progname;

	InputFName= "in";
	ErrMapFName= "errmap";
	progname= *argv;
	argv++;

        /* evaluate arguments */
        for ( ; argc>1; argc--, argv++)
        {
                if ((*argv)[0] == '-')
                {
                  switch ((*argv)[1])
                  {
                        case 'i':
                                argv++;
                                argc--;
                                InputFName= *argv;
                                break;
                        case 'e':
                                argv++;
                                argc--;
                                ErrMapFName= *argv;
                                break;
                        default:
                                usage (progname);
                                break;
                  } /* switch */
                }
                else
                        usage (progname);
        } /* for */


	/* open ErrMapFile */
	ErrMapFile= fopen (ErrMapFName, "r");
	if (!ErrMapFile) {
		fprintf (stderr, "Can't read input file %s\n", ErrMapFName);
		exit (0);
	}
	ErrTabInit (ErrMapFile);

	/* open input file */
	InputFile= fopen (InputFName, "r");
	if (!InputFile) {
		fprintf (stderr, "Can't read input file %s\n", InputFName);
		exit (0);
	}
	/* read input file */
	IdlStruct= ligain (InputFile);

	/* close input file */
	(void) fclose (InputFile);

	/* perform any action */

	PAttrEval (IdlStruct);

} /* main() */

/***********************\
* end of ligascel.c	*
\***********************/

