# $Id: src.show.Makefile.cpp,v 3.1 1992/03/04 15:21:30 uwe Exp $
# 
# Makefile of the directory show
# 
# make the executables of the show pass
# 

SHELL		= /bin/sh

# IDL
IDL		= ../idl

# option handler
OPTHANDLER	= ../option

DISTRIB		= /tmp

# directory with global definitions for LIGA
SCEL		= ../ligascel

CFLAGS		= -I$(IDL) -I$(SCEL)
COFLAGS		= -q
SRCS		= show.c showproc.c show_ptg_gen.c map_errors.c
HDRS		= showproc.h show_ptg_gen.h map_errors.h
RCS		= $(SRCS) $(HDRS) show.ptg
OBJS		= show.o showproc.o show_ptg_gen.o map_errors.o
LIBS		= $(IDL)/IDL.a 
EXE		= ../ligaShow.exe

TIDY		= *.o a.out core
CLEAN		= $(TIDY) $(EXE) $(IEXE)
CLOBBER		= $(CLEAN) Makefile
RCS		= $(SRCS) $(HDRS)
 
# MAKE

all : $(EXE)

$(EXE): $(OBJS)
	$(CC) $(CFLAGS) -o $(EXE) $(OBJS) $(LIBS)

# checkout
checkout:
	co $(COFLAGS) $(RCS)
	co $(COFLAGS) src.show.README; mv src.show.README README

# installation
install:
	rm -f $(DESTDIR)/Tool/liga/ligaShow.exe
	cp $(EXE) $(DESTDIR)/Tool/liga
	chmod 755 $(DESTDIR)/Tool/liga/ligaShow.exe

SourceDistr:	$(SRCS) $(HDRS)

# distribution
distrib:	$(SRCS) $(HDRS)
	- rm -rf $(DISTRIB)/show
	mkdir $(DISTRIB)/show
	cp $(SRCS) $(HDRS) Makefile.cpp $(DISTRIB)/show
	(cd $(DISTRIB)/show; chmod 644 $(SRCS) $(HDRS) Makefile.cpp)

# cleaning targets

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

rcsclean:
	rm -rf $(CLEAN) Makefile
	-rcsclean $(COFLAGS) $(RCS) Makefile.cpp

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(RCS)
	-rcs -bOriginal.1 -q Makefile.cpp $(RCS)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q $(RCS)

show.o: $(IDL)/LIGA.h showproc.h
showproc.o: $(IDL)/LIGA.h $(IDL)/global.h $(IDL)/LIGAMacros.h \
	$(IDL)/liga_func.h $(IDL)/lookup_idl.h $(SCEL)/ligaconsts.h \
	show_ptg_gen.h showproc.h map_errors.h
show_ptg_gen.o: show_ptg_gen.h




