/* $Id: replidl.c,v 2.2 1991/08/08 09:02:47 cogito Exp $ */
/* $Log: replidl.c,v $
 * Revision 2.2  1991/08/08  09:02:47  cogito
 * adapted to changes of option handler
 *
 * Revision 2.1  1991/06/10  14:15:06  cogito
 * rewritten to achieve compatibility with new expand
 * */
static char rcs_id[]= "$Id: replidl.c,v 2.2 1991/08/08 09:02:47 cogito Exp $";

/***********************************************\
*						*
*	Version : 1.schrott			*
*						*
*	Module  : replidl.c			*
*						*
*	Contains routines to handle with	*
*	idlfunctions				*
*						*
\***********************************************/


/***********************************************\
* includes					*
\***********************************************/

#include <stdio.h>
#include <string.h>
#include "LIGA.h"
#include "LIGAMacros.h"

/* Includes for option handling */
#include "option_enums.h"
#include "option_types.h"

#include "rglobal.h"

/***********************************************\
* functions					*
\***********************************************/

void eval_exp_opt ();

/***********************************************\
* eval_exp_opt					*
\***********************************************/

void eval_exp_opt()
{
	ExpList         expp;

	fprintf(Prot,"\n\nOptions for EXPAND :\n");

	if (expand_opts->exp_opts)
	{
		expp= expand_opts->exp_opts;
		while (expp)
		{
			switch (expp->entry->flag)
			{
				case const_attr_name:
					CONST_ATTR=expp->entry->attrname;
					fprintf(Prot,"   Name-prefix for generated CONSTITUENT(S)-attrs is %s.\n",
						CONST_ATTR);
					break;
				case incl_attr_name:
					INCL_ATTR= expp->entry->attrname;
					fprintf(Prot,"   Name-prefix for generated INCLUDING-attrs is %s.\n",
						INCL_ATTR);
					break;
				case chain_pre_name:
					CHAIN_PRE_ATTR= expp->entry->attrname;
					fprintf(Prot,"   Name-prefix for generated CHAIN-PRE-attrs is %s.\n",
						CHAIN_PRE_ATTR);
					break;
				case chain_post_name:
					CHAIN_POST_ATTR= expp->entry->attrname;
					fprintf(Prot,"   Name-prefix for generated CHAIN-POST-attrs is %s.\n",
						CHAIN_POST_ATTR);
					break;
				case includings_separate:
					fprintf(Prot,"   I don't identify INCLUDINGS.\n");
					IDENT_INCL=0;
					break;
				case exp_info:
					fprintf(Prot,"   I produce a large protocol.\n");
					EXP_PROT=1;
					break;
				case including_on:
					fprintf(Prot,"   I expand INCLUDINGS.\n");
					EXP_INCL=1;
					break;
				case including_off:
					fprintf(Prot,"   I don't expand INCLUDINGS.\n");
					EXP_INCL=0;
					break;
				default:
					break;
			} /* switch */
			expp= expp->next;
		} /* while */
	} /* if */

	fprintf(Prot,"\n\n");

} /* eval_exp_opt() */

