# $Id: src.replincl.Makefile.cpp,v 1.3 1991/12/20 14:12:47 cogito Exp $

# Makefile of the LIGA replincl pass

# generate the executables of the replincl pass


SHELL		= /bin/sh

# directory of IDL sources and libraries
IDL		= ../idl

DISTRIB		= /tmp

# directory of the option handler
OPTHANDLER	= ../option

CFLAGS		= -I$(IDL) -I$(OPTHANDLER)
COFLAGS		= -q
SRCS		= replidl.c replincl.c replrem.c
HDRS		= replincl.h rglobal.h replidl.h
RCS		= $(SRCS) $(HDRS)
OPTHDRS         = $(OPTHANDLER)/option_enums.h $(OPTHANDLER)/option_types.h \
		  $(OPTHANDLER)/opt_input.h
OBJS		= replidl.o replincl.o replrem.o
LIBS		= $(OPTHANDLER)/opt_input.o $(IDL)/IDL.a
EXE		= ../ligaRepl.exe

TIDY		= core a.out test *.o *.a
CLEAN		= $(TIDY) $(EXE)
CLOBBER		= $(CLEAN) Makefile

all:	$(EXE)

$(EXE): $(OBJS)
	$(CC) $(CFLAGS) -o $(EXE) $(OBJS) $(LIBS)

replidl.o : rglobal.h $(IDL)/LIGA.h $(IDL)/LIGAMacros.h replidl.c
	$(CC) $(CFLAGS) -c replidl.c

replincl.o : $(IDL)/LIGA.h $(OPTHANDLER)/$(OPTHDRS) replincl.h
	$(CC) $(CFLAGS) -c replincl.c

replrem.o : replidl.h rglobal.h $(IDL)/LIGA.h $(IDL)/LIGAMacros.h replrem.c
	$(CC) $(CFLAGS) -c replrem.c

# checkout
checkout:
	-co $(COFLAGS) $(RCS)
	-co $(COFLAGS) src.replincl.README; mv src.replincl.README README

# installation
install:
	for f in $(EXE); do \
		install -c -m 555 -s $$f $(DESTDIR)/Tool/liga; done

SourceDistr:	$(SRCS) $(HDRS)

# distribution
distrib:	$(SRCS) $(HDRS)
	- rm -rf $(DISTRIB)/replincl
	mkdir $(DISTRIB)/replincl
	cp $(SRCS) $(HDRS) Makefile.cpp README $(DISTRIB)/replincl
	cd $(DISTRIB)/replincl; chmod 0644 $(SRCS) $(HDRS) Makefile.cpp README

# cleaning targets
tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

rcsclean:
	- rcsclean $(COFLAGS) $(RCS)
	rm -rf $(CLEAN) Makefile

save:
	- mkdir RCS
	- ci -k -t/dev/null -nOriginal -u -q Makefile $(RCS)
	- rcs -bOriginal.1 -q Makefile $(RCS)
	- ci -fOriginal.1 -m/dev/null -q -u Makefile
	- ci -fOriginal.1 -m/dev/null -q $(RCS)

