/* $Id: set.h,v 2.1 1991/06/10 13:26:16 cogito Exp $ */

/********************************************************
*       file: set.h                                     *
*       contains macros, typedefinitions, and external  *
*	functions declarations for set operations 	*
********************************************************/

	/*
	 * Angepasst zur Anbindung an GORTO (Graphical Order Tool).
	 * Alle Aenderungen sind mit #ifdef GORTO gekennzeichnet.
	 *
	 *		26.04.90	Volker Niepel
	 */

#include <stdio.h>

#define MAXBITNO ((sizeof(unsigned int)*8)-1)
#define sgl 0x00000001
#define TRUE 1
#define FALSE 0

typedef unsigned int *BITVECTOR;
typedef int bool;


extern bool isemptyset();
extern bool issubset();
extern bool ismemberset();
extern void addtoset();
extern void delfromset();
extern void copyset();
extern void unionset();
extern void diffset();
extern BITVECTOR mkemptyset();

#ifndef GORTO
extern char * Malloc();
extern void Free();
#else
extern bool dep_is_subset();
extern void copy_dep_to_set();
extern void dep_unionset();
#endif

