/* $Id: reftab.c,v 2.2 1991/07/05 11:12:06 cogito Exp $ */
/* $Log: reftab.c,v $
 * Revision 2.2  1991/07/05  11:12:06  cogito
 * Avoiding call of malloc(0) in init_ref_tab()
 *
 * Revision 2.1  91/06/10  13:26:10  cogito
 * sources for ORDER combined with GORTO
 *  */
static char rcs_id[]= "$Id: reftab.c,v 2.2 1991/07/05 11:12:06 cogito Exp $";

/************************************************************************
*									*
*       Version : 1.0    						*
*	Module  : reftab.c						*
*       Author  : Jiyang Liu						*
*       Contains the routines to initialize the reference table		*
*       ref_tab[].							*
*									*
************************************************************************/

	/*
	 * Angepasst zur Anbindung an GORTO (Graphical Order Tool).
	 * Alle Aenderungen sind mit #ifdef GORTO gekennzeichnet.
	 *
	 *		26.04.90	Volker Niepel
	 */

/* includes */

#ifndef GORTO
#include "order.h"
#else
#include "Gorto.h"
#endif

/* functions */

void init_ref_tab();
void sl_cons();
void ins_right_list();
void ins_down_list();

/* global variable definitios */

ALLENTRIES ref_tab[MAX_ENTRIES];
int max_entry, min_entry;
int DefSymbNum, DefRuleNum, DefAttrNum;

/************************************************************************
*									*
* 	void init_ref_tab(IS)						*
*	initialize the reference table: ref_tab[] which is indexed 	*
*	by the did of symbols, productions, and attributes.		*
*									*
************************************************************************/

void
init_ref_tab(IS)
AttrEval IS;
{
SEQDef x;
SEQAttrdef y;
Def def;
Attrdef attrdef;
int did, i, j;
int pos;
int sid;
int row_num, col_num;

for (did=0; did<MAX_ENTRIES; did++) ref_tab[did].etag = EMPTY;

min_entry = MAX_ENTRIES; max_entry = 0; did =0;
DefSymbNum = 0; DefRuleNum = 0; DefAttrNum = 0;

foreachinSEQDef(IS->defseq, x, def) {

	switch ( typeof(def)) {

	case KSymb : did = def.VSymb->did;
		     DefSymbNum++ ;
		     ref_tab[did].etag = SYMB;
		     ref_tab[did].entry.symb.symb_def = def.VSymb;
		     break;

	case KProd : did = def.VProd->did;
		     DefRuleNum++;
		     ref_tab[did].etag = PROD;
		     ref_tab[did].entry.prod.prod_def = def.VProd;
		     break;

	} /* switch */

	if (max_entry < did ) max_entry = did;
	if (min_entry > did ) min_entry = did;

	if (typeof(def) ==  KSymb) {

/* extract the attribute definitions of this symbol and enter them
   into ref_tab,
   allocating space for init_ds and ds,
   and initialize them.
*/

		pos = 0;
		sid = did; /* save the did of this symbol */
		foreachinSEQAttrdef(def.VSymb->attrs, y, attrdef) {
			did = attrdef->did;
			DefAttrNum++ ;
		        ref_tab[did].etag = ATTR;
			ref_tab[did].entry.attr.attr_def = attrdef;
			ref_tab[did].entry.attr.pos = pos++;
			if (max_entry < did) max_entry = did;
			if (min_entry > did) min_entry = did;
		}
		/* enter the number of attributes of this symbol */

#ifndef GORTO
		if (ref_tab[sid].entry.symb.attr_num = pos) {
		    ref_tab[sid].entry.symb.changed = TRUE;
		    ref_tab[sid].entry.symb.cyclic = FALSE;

	            /* allocating space for init_ds and ds */
		    /* the extra  row is used to compute the
		       transitive and induced graphs	   */

		    ref_tab[sid].entry.symb.init_ds =
		      (BITMATRIX) Malloc (sizeof(BITVECTOR)*(1+pos));
		    ref_tab[sid].entry.symb.ds =
		      (BITMATRIX) Malloc (sizeof(BITVECTOR)*(1+pos));

	            for (i=0; i<1+pos; i++) {
	              ref_tab[sid].entry.symb.init_ds[i] =
		        (BITVECTOR)Malloc(sizeof(unsigned int)*((pos-1)/WORD_LENGTH+1));
	              ref_tab[sid].entry.symb.ds[i] =
		        (BITVECTOR)Malloc(sizeof(unsigned int)*((pos-1)/WORD_LENGTH+1));
		    }
        	    /* initialize init_ds  and ds */

		    for (i=0; i<1+pos; i++)
	               for (j=0; j<(pos-1)/WORD_LENGTH+1; j++) {
		          ref_tab[sid].entry.symb.init_ds[i][j] = 0;
		          ref_tab[sid].entry.symb.ds[i][j] = 0;
	               }
		}
#else
		if (ref_tab[sid].entry.symb.attr_num = pos) {
		    ref_tab[sid].entry.symb.state = S_CHANGED;

	            /* allocating space for init_ds and ds */
		    /* the extra  row is used to compute the
		       transitive and induced graphs	   */

		    ref_tab[sid].entry.symb.ds =
		      (DEP_MATRIX) Malloc (sizeof(DEP_VECTOR)*(1+pos));
		    ref_tab[sid].entry.symb.ds_detail =
		      (DET_MATRIX) Malloc (sizeof(DET_VECTOR)*(1+pos));

	            for (i=0; i<1+pos; i++) {
	              ref_tab[sid].entry.symb.ds[i] =
		        (DEP_VECTOR) Malloc (sizeof(DEPENDENCY)*(1+pos));
	              ref_tab[sid].entry.symb.ds_detail[i] =
		        (DET_VECTOR) Malloc (sizeof(DETAIL)*(1+pos));
		      for (j=0; j<1+pos; j++)
			   ref_tab[sid].entry.symb.ds[i][j] = 0;
		    }
		}
#endif

	}
	else if (typeof(def) == KProd) {

/* construct the symbol list, allocating space for init_dp, and
   initialize init_dp. this implementation is based on the fact
   that in the input file "exp_idl", symbol definitions come
   before productions
*/
#ifndef GORTO
 		ref_tab[did].entry.prod.changed = TRUE;
 		ref_tab[did].entry.prod.cyclic = FALSE;
#else
		ref_tab[did].entry.prod.state = S_CHANGED;
		ref_tab[did].entry.prod.vs = (VSINFO *) NULL;
#endif
 		ref_tab[did].entry.prod.visitseq = NULL;

		/* build the symbol list */
		sl_cons(did, &row_num, &col_num);


		/* allocating space for init_dp and dp, the last row of init_dp
		   is used to check the consistency and completeness of
		   the attribute grammar and the space is freed afterwards.  */

#ifndef GORTO
	/* kalle: modifications because malloc(0) returns non-NULL on
	 * some systems. */
		ref_tab[did].entry.prod.init_dp =
		   (BITMATRIX) Malloc(sizeof(BITVECTOR)*(1+row_num));
		ref_tab[did].entry.prod.dp =
		   (BITMATRIX) Malloc(sizeof(BITVECTOR)*(1+row_num));
	        for (i=0; i<row_num+1; i++) {
		    ref_tab[did].entry.prod.init_dp[i] =
		      col_num? 
			(BITVECTOR) Malloc(sizeof(unsigned int)*col_num)
			:  (BITVECTOR)NULL;
		    ref_tab[did].entry.prod.dp[i] =
		      col_num?
		      	(BITVECTOR) Malloc(sizeof(unsigned int)*col_num)
			:  (BITVECTOR)NULL;
		}

		ref_tab[did].entry.prod.check_row = row_num;
		ref_tab[did].entry.prod.check_col = col_num-1;

		/* initialize init_dp and dp */
		for (i=0; i<=row_num; i++)
		    for (j=0; j<col_num; j++) {
		       ref_tab[did].entry.prod.init_dp[i][j] = 0;
		       ref_tab[did].entry.prod.dp[i][j] = 0;
		    }
#else
		ref_tab[did].entry.prod.dp =
		   (DEP_MATRIX) Malloc(sizeof(DEP_VECTOR)*(1+row_num));
		ref_tab[did].entry.prod.dp_detail =
		   (DET_MATRIX) Malloc(sizeof(DET_VECTOR)*(1+row_num));
	        for (i=0; i<row_num+1; i++) {
		    ref_tab[did].entry.prod.dp[i] =
		      (DEP_VECTOR) Malloc(sizeof(DEPENDENCY)*(1+row_num));
		    ref_tab[did].entry.prod.dp_detail[i] =
		      (DET_VECTOR) Malloc(sizeof(DETAIL)*(1+row_num));
		    for (j=0; j<row_num+1; j++)
		       ref_tab[did].entry.prod.dp[i][j] = 0;
		}
		/* kalle: why using row_num instead of col_num ???? */
		ref_tab[did].entry.prod.check_row = row_num;
		ref_tab[did].entry.prod.check_col = col_num-1;

		ref_tab[did].entry.prod.vs = (VSINFO *) NULL;
#endif
	}
}

return;

}/* init_ref_tab() */



/**************************************************************************
*									  *
* void sl_cons();							  *
* construct the linked symbol list for production no. pid and build the   *
* links through those symbol occurrences with 				  *
* the same symbol name (did) 					          *
*									  *
**************************************************************************/


void
sl_cons(pid, row, col)
int pid;
int *row, *col; /* the number of rows and columns of the init_dp of
	           this production, they are used in allocating space
		   for the production's init_dp.  */
{
int   n;
int cur_row, cur_col;
SLNODE * slnptr;
SEQEntity x;
Entity entity;

void ins_right_list(), ins_down_list();



        /* the lhs symbol in a prod. */

	cur_row = cur_col = 0;

	slnptr = (SLNODE *) Malloc(sizeof(SLNODE));
	slnptr->pid = pid;
	slnptr->start_row = cur_row;
	slnptr->start_col = cur_col;
	slnptr->sid = ref_tab[pid].entry.prod.prod_def->lhs;
	slnptr->right = NULL;
	slnptr->down = NULL;
	ins_right_list(slnptr); /* insert into the prod. symbol list */
	ins_down_list(slnptr);  /* insert into the same-name symbol list */

	if (n=ref_tab[slnptr->sid].entry.symb.attr_num) {
	     cur_row += n;
	     cur_col += (n - 1)/ WORD_LENGTH + 1;
	}

	/* processing the rhs symbols */

	foreachinSEQEntity(ref_tab[pid].entry.prod.prod_def->rhs, x, entity)
	   switch(typeof(entity)) {
	     case KOpt:
	     case KStar:
	     case KPlus:
	     case KDelim:
	     case KDelopt: 
	     /* case KUnit: */
	     case KLiteral: break;

	     case KSymbol: slnptr = (SLNODE *) Malloc(sizeof(SLNODE));
			   slnptr->pid = pid;
			   slnptr->sid = entity.VSymbol->did;
			   slnptr->start_row = cur_row;
			   slnptr->start_col = cur_col;
			   slnptr->down = NULL;
			   slnptr->right = NULL;
			   ins_right_list(slnptr);
			   ins_down_list(slnptr);

	          if (n=ref_tab[slnptr->sid].entry.symb.attr_num) {
	              cur_row += n;
	              cur_col += (n - 1) / WORD_LENGTH + 1;
	          }

			   break;

	     default: printf("** msg from sl_cons: wrong entity.\n");
		      break;

	   }/* end of switch */

	   *row = cur_row; *col = cur_col;

           return;

} /* sl_cons() */

/**********************************************************
* 							  *
*   void ins_right_list();				  *
*   append a symbol node at the end of prod. symbol list  *
*                                                         *
**********************************************************/

void
ins_right_list(p)
SLNODE *p;
{
static SLNODE *curptr;

if (ref_tab[p->pid].entry.prod.hdright == NULL)
	ref_tab[p->pid].entry.prod.hdright = p;
else    curptr->right = p;

curptr = p;
return;
} /* ins_right_list() */

/**************************************************************
* 							      *
*   void ins_down_list();				      *
*   append a symbol node at the end of same-name symbol list  *
*                                                             *
**************************************************************/

void
ins_down_list(p)
SLNODE *p;

{
SLNODE *last;

if (ref_tab[p->sid].entry.symb.hddown == NULL)
	ref_tab[p->sid].entry.symb.hddown = p;
else {
	last = ref_tab[p->sid].entry.symb.hddown;
	while (last->down != NULL)
		last = last->down;
	last->down = p;
}

return;
} /* ins_down_list() */



