/* $Id: part.c,v 2.2 1991/06/13 10:19:10 cogito Exp $ */
/* $Log: part.c,v $
 * Revision 2.2  1991/06/13  10:19:10  cogito
 * *** empty log message ***
 *
 * Revision 2.1  91/06/10  13:26:05  cogito
 * sources for ORDER combined with GORTO
 *  */
static char rcs_id[]= "$Id: part.c,v 2.2 1991/06/13 10:19:10 cogito Exp $";

/****************************************************************
*                                                               *
*       Module  : part.c                                        *
*                                                               *
*       Version : 1.1                                           *
*                                                               *
*       Author  : Jiyang Liu                                    *
*                                                               *
*       compute the partitions of attributes for the		*
*       symbols.                                                *
*                                                               *
****************************************************************/

	/*
	 * Angepasst zur Anbindung an GORTO (Graphical Order Tool).
	 * Alle Aenderungen sind mit #ifdef GORTO gekennzeichnet.
	 *
	 *		25.04.90	Volker Niepel
	 */

/* a framework to implement the branch-and-bound algorithm */

/* include */
#ifndef GORTO
#include "order.h"
#else
#include "Gorto.h"
#endif
#include "ligaconsts.h"

/* macros */
#define ISCAND ( ( (EVEN(currpartno)&& \
                   (ref_tab[aid].entry.attr.attr_def->class == ATCLINH))\
	         || \
	           (ODD(currpartno)&& \
                   (ref_tab[aid].entry.attr.attr_def->class == ATCLSYNT)) )\
               && \
    ((ids[maxatno+1][atno/WORD_LENGTH] & 0x1<<atno%WORD_LENGTH) == 0 ) )
               
/* global variables */
int maxpartno; 	/* maximal partition number yielded from early() */
int  atsort[MAX_ATNO]; /* used only in branch_and_bound() */
BITMATRIX ids;
SYMBENTRY *symb;

extern bool PART_EARLY;
extern bool PART_LATE;
extern bool PART_BRANCH_AND_BOUND;
extern bool TREE_BOTTOM_UP;
extern bool TREE_COMPLETE;
extern bool TREE_TOP_DOWN;
extern bool AUTOMATICALLY;   		/* these externs are defined in order.c */

/* functions */
void partit();
void early();
void late();
void add_deps();

/* the followin four are for branch_and_bound */
void branch_and_bound();
ATNODE *gen_atnode();
void insert_atnode();
void insert_rmnode();

#ifdef GORTO
/********************************************************
* 	void copy_ds(ds, attr_num)			*
*	copies the contents of the given dependency	*
*	matrix symb->ds into the global BITMATRIX ids.	*
********************************************************/

void copy_ds (symb)
	SYMBENTRY *symb;
{
	int row, col;
	DEPENDENCY *dep;

	for (row=0; row<symb->attr_num; row++)
	{
		for (col=0; col<=(symb->attr_num-1)/WORD_LENGTH; col++)
			ids[row][col] = 0;
		dep = & symb->ds[row][0];
		for (col=0; col<symb->attr_num; col++)
		{
			if (*dep)
				ids[row][col/WORD_LENGTH]|=0x1<<col%WORD_LENGTH;
			dep ++;
		}
	}
} /* copy_ds() */
#endif


/********************************************************
* 	void symbpartition()				*
*	compute the partition of symbol did.		*
********************************************************/

void 
symbpartition(sid)
int sid;
{
	int aid;
	int atno, maxatno;

      symb = & ref_tab[sid].entry.symb;

      /* initialize the part_num of each symb entry of the ref_tab[] */
      if (TREE_COMPLETE || TREE_TOP_DOWN)
	symb->part_num = 1;
      else
	symb->part_num = 0;

#ifndef GORTO
      if (symb->attr_num > 0 && !symb->cyclic) {
#else
      if (symb->attr_num > 0 && !(symb->state & S_CYCLIC)) {
	symb->state |= S_PARTITIONED;
#endif

	/* allocate space for ids of this symbol */
	ids = (BITMATRIX)Malloc(sizeof(BITVECTOR)*(symb->attr_num+1));
	for (atno = 0; atno <= symb->attr_num; atno++)
            ids[atno] = (BITVECTOR)Malloc(sizeof(unsigned int)*
                                ((symb->attr_num-1)/WORD_LENGTH + 1));

	early(sid);

	if (PART_LATE || PART_BRANCH_AND_BOUND)
            late(sid);

	/* Branch and Bound */

	/* free the space for ids */
	for (atno = 0; atno <= symb->attr_num; atno++)
	    Free( (char **) &ids[atno] );
	Free( (char **) &ids );

	/* add new dependencies */
	add_deps(sid); 

	/* enter the maxpartno */
	ref_tab[sid].entry.symb.part_num = maxpartno;

	/* enter the partno of attributes into the IDL definition */
	maxatno = symb->attr_num - 1;
	for (atno = 0; atno <= maxatno; atno++)
	{
   	    aid = lookup_attr(sid, atno);
            ref_tab[aid].entry.attr.attr_def->part = ref_tab[aid].entry.attr.part/2 + 1;
	}

      }  /* if attr_num > 0 ... */
} /* symbpartition() */


/********************************************************
* 	void partit()					*
*	compute the partition of attributes of 		*
*	symbols.					*
********************************************************/

void 
partit()
{
int did;

for (did = min_entry; did <= max_entry; did++)
   if (ref_tab[did].etag == SYMB) symbpartition (did);

return;
} /* partit() */


/********************************************************
* 	void early()	 			 	*
*    	for each attribute of this symbol,		*
*	compute the earliest attribute partition set    *
*	to which the attribute can be allocated.	* 
********************************************************/

void
early(sid)
int sid;
{
int currpartno;
int aid, atno, word, maxatno, maxwordno, notassigned;
int row;
bool depnone, foundone;

maxatno = symb->attr_num - 1;
maxwordno =  maxatno/WORD_LENGTH;

/* copy ids from symb.ds */
#ifndef GORTO
for (atno = 0; atno <= maxatno; atno++)
   for (word = 0; word <= maxwordno; word++)
 	ids[atno][word] = symb->ds[atno][word];
#else
copy_ds (symb);
atno = maxatno + 1;
#endif

for (word = 0; word <= maxwordno; word++)
   ids[atno][word] = 0;

notassigned = symb->attr_num; /* number of not yet assigned attrs */

if (TREE_BOTTOM_UP)
   currpartno = 1;
else
   currpartno = 0;

do {

   foundone = FALSE;
   for (atno = 0; atno <= maxatno; atno++) {

      aid = lookup_attr(sid, atno);
      if (ISCAND) {

         depnone = TRUE;
  	 for (word = 0; word <= maxwordno; word++)
  	    if (ids[atno][word] != 0) {
  		depnone = FALSE;
		break;
	    }

         if (depnone) {
	    foundone = TRUE;
	    ref_tab[aid].entry.attr.early = currpartno;
	    ref_tab[aid].entry.attr.part = currpartno;
	    notassigned--;
	    /* delete the attr dependencies to this attribute. */
	    for (row = 0; row <= maxatno; row++)
               ids[row][atno/WORD_LENGTH] &= ~(0x1<<atno%WORD_LENGTH);
            /* mark this attribute as partitioned. */
            ids[row][atno/WORD_LENGTH] |= (0x1<<atno%WORD_LENGTH);
         }
      }
   }

   if (notassigned>0 && !foundone)
      currpartno++;

} while (notassigned>0);

maxpartno = (EVEN(currpartno) ? (currpartno + 1) : (currpartno));

return;
} /* early() */



/********************************************************
* 	void late()	 			 	*
*    	for each attribute of this symbol,		*
*	compute the latest attribute partition set      *
*	to which the attribuet can be allocated.	* 
********************************************************/

void
late(sid)
int sid;
{

int currpartno;
int aid, atno, word, maxatno, maxwordno, notassigned;
int row, ord;
bool nonedep, foundone;

maxatno = symb->attr_num - 1;
maxwordno =  maxatno/WORD_LENGTH;

/* copy ids from symb.ds */
#ifndef GORTO
for (atno = 0; atno <= maxatno; atno++)
   for (word = 0; word <= maxwordno; word++)
 	ids[atno][word] = symb->ds[atno][word];
#else
copy_ds (symb);
atno = maxatno + 1;
#endif

/* initialize the check_row */
for (word = 0; word <= maxwordno; word++)
   ids[atno][word] = 0;

notassigned = symb->attr_num; /* number of not yet assigned attrs */
currpartno = maxpartno;
ord = 0;

do {

   foundone = FALSE;
   for (atno = 0; atno <= maxatno; atno++) {

      aid = lookup_attr(sid, atno);
      if (ISCAND) {

         nonedep = TRUE;
  	 for (row = 0; row <= maxatno; row++)
  	    if (ids[row][atno/WORD_LENGTH] & 0x1<<atno%WORD_LENGTH) {
  		nonedep = FALSE;
		break;
	    }

         if (nonedep) {
	    foundone = TRUE;
	    ref_tab[aid].entry.attr.part = currpartno;
	    atsort[ord++] = aid;
	    notassigned--;

	    /* delete the attr dependencies to this attribute. */
	    for (word = 0; word <= maxwordno; word++)
               ids[atno][word] = 0;

            /* mark this attribute as partitioned. */
            ids[maxatno+1][atno/WORD_LENGTH] |= (0x1<<atno%WORD_LENGTH);
         }
      }
   }

   if (notassigned>0 && !foundone)
      currpartno--;

} while (notassigned>0);

return;
} /* late() */


/********************************************************
* 	void branch_and_bound()	 			*
*    	using branch-and-bound method to compute the    *
*	attribute partition of a symbol in order to     *
*	reduce the lifetime of attributes               * 
********************************************************/

void
branch_and_bound(sid)
int sid;
{
ATNODE *newnode, *atfirst, *rmfirst, *oldfirst, *cursol, *p;
ATTRENTRY attr, depattr, fattr;
int bound, curat, curaid, attrid;
int partno;
bool done, consistant;
int atno, atid, depatno, depatid, maxatno, attrpos, depattrpos;

/* special cases yet to handle */
/* 1. for each attribute of this symbol late[a] == early[a];
   2. for both ends of the edges in DS of this symbol,
      late[a]==early[a];
   3. this symbol has only one attribute, a specal case of 1.
*/

printf("order: branch_and_bound for symbol '%s'\n", symb->symb_def->dname);

maxatno = symb->attr_num - 1;
done = TRUE;

for (atno = 0; atno <= maxatno && done; atno++) {
   atid = atsort[atno];
   attr = ref_tab[atid].entry.attr;
   if (attr.early != attr.part) 
      done = FALSE;
}

for (atno = 0; atno <= maxatno && done; atno++) {
   atid = atsort[atno];
   attr = ref_tab[atid].entry.attr;
   attrpos = attr.pos;
      
   for (depatno = atno; depatno <= maxatno && done; depatno++) {
      depatid = atsort[depatno];
      depattr = ref_tab[depatid].entry.attr;
      depattrpos = depattr.pos;
#ifndef GORTO
      if (   (symb->init_ds[attrpos][depattrpos/WORD_LENGTH]
              & 0x1 << depattrpos%WORD_LENGTH)
          || (symb->init_ds[depattrpos][attrpos/WORD_LENGTH]
              & 0x1 << attrpos%WORD_LENGTH)
         )
#else
      if (   (symb->ds[attrpos][depattrpos] & T_DIR)
          || (symb->ds[depattrpos][attrpos] & T_DIR)
         )
#endif
         if ( attr.early != attr.part || depattr.early != depattr.part )
            done = FALSE;
   };
}

if (!done) {
bound = MAX_INT;
cursol = NULL;
atfirst = NULL;
rmfirst = NULL;
curat = 0;

curaid = atsort[curat];
attr = ref_tab[curaid].entry.attr;

/* generate atnodes for  curat and 
insert them into the atnode list with atfirst pointing
to the head of the list	*/

for (partno = attr.part; partno >= attr.early; partno -= 2) {
   newnode = gen_atnode(curat, partno);
   insert_atnode(&atfirst, newnode);
}

do {
   /*remove (not delete) the head */
   oldfirst = atfirst;
   insert_rmnode(rmfirst, oldfirst); /* insert the removed node into the
					removed-node list, of which rmfirst
					is the head pointer */
   atfirst = atfirst->next;

   curat = oldfirst->atord + 1;
   curaid =atsort[curat];
   attr = ref_tab[curaid].entry.attr;

   for (partno=attr.part; partno>=attr.early; partno -= 2) {
      newnode = gen_atnode(curat, partno); 
      newnode->father = oldfirst;

      /* check the consistency of this partition of the 
         current attribute against its father nodes using
  	 ids of this symbol */
      p = newnode->father;
      consistant = TRUE;
      while (p != NULL) {
         fattr = ref_tab[atsort[p->atord]].entry.attr;
#ifndef GORTO
	 if ( 
  	      (( /* transitive edge from fathers */
               symb->ds[fattr.pos][attr.pos/WORD_LENGTH] 
               & 0x1 << attr.pos%WORD_LENGTH )
              && p->partno < newnode->partno) 
            ||
 	      (( /* transitive edge to fathers */
               symb->ds[attr.pos][fattr.pos/WORD_LENGTH]
	       & 0x1 << fattr.pos%WORD_LENGTH )
	      && newnode->partno < p->partno)
  	    ) /* end cond. */ {
#else
	 if ( 
  	      (( /* transitive edge from fathers */
               symb->ds[fattr.pos][attr.pos])
              && p->partno < newnode->partno) 
            ||
 	      (( /* transitive edge to fathers */
               symb->ds[attr.pos][fattr.pos])
	      && newnode->partno < p->partno)
  	    ) /* end cond. */ {
#endif

            /* inconsistent, free newnode */
	    newnode->father = NULL;
	    newnode->next = NULL;
	    Free( (char **) &newnode );

            consistant = FALSE;
	    break;
         } 
         else p = p->father;
      } /*while*/

      if (consistant) { /* compute the cost for newnode */
 	 p = newnode->father;
  	 newnode->cost = p->cost;

	 while (p != NULL) {
            fattr = ref_tab[atsort[p->atord]].entry.attr;
#ifndef GORTO
	    if ( ((symb->init_ds[fattr.pos][attr.pos/WORD_LENGTH]
                   & 0x1 << attr.pos%WORD_LENGTH)
	        ||
	         (symb->init_ds[attr.pos][fattr.pos/WORD_LENGTH]
	            & 0x1 << fattr.pos%WORD_LENGTH)) 
                &&
		 abs(p->partno - newnode->partno) > 1
               ) /* end of cond */ {
#else
	    if ( ((symb->ds[fattr.pos][attr.pos] & T_DIR)
	        ||
	         (symb->ds[attr.pos][fattr.pos] & T_DIR)) 
                &&
		 abs(p->partno - newnode->partno) > 1
               ) /* end of cond */ {
#endif

	       newnode->cost = newnode->cost + 1;
	       p = p->father;
            }
            else p = p->father;
         } /*while*/
         
	 if (newnode->cost >= bound) {
            /* discard this node */
	    newnode->father = NULL;
	    newnode->next = NULL;
	    Free( (char **) &newnode );
         }
	 else if (newnode->atord == symb->attr_num - 1) { /*last attr*/
                 bound = newnode->cost;
		 cursol = newnode; /* a solution is found */
	      }
	      else 
		 insert_atnode(&atfirst, newnode);
      } /* if */
   } /* for */

} while (atfirst != NULL && atfirst->cost < bound);


/* add the partno into the ref-tab */
p = cursol;
while (p != NULL) {
   attrid = atsort[p->atord];
   ref_tab[attrid].entry.attr.part = p->partno;
   p = p->father;
}

/* free the allocated storage for the atnodes */
while (atfirst != NULL) {
   p = atfirst;
   atfirst = atfirst->next;
   Free( (char **) &p);
}

while (rmfirst != NULL) {
   p = rmfirst;
   rmfirst = rmfirst->next;
   Free( (char **) &p);
}

} /* if not done */
return;
} /* branch_and_bound() */


/********************************************************
*	ATNODE *gen_atnode()				*
*	generate an atnode, return the pointer to it    *
*	for use with branch_and_bound			*
********************************************************/	

ATNODE 
*gen_atnode(ord, part)
int ord, part;
{
ATNODE 	* anode;

anode = (ATNODE *) Malloc(sizeof(ATNODE));
anode->atord = ord;
anode->partno = part; 
anode->cost = 0;
anode->father = NULL;
anode->next = NULL;

return anode;
} /* gen_atnode() */


/********************************************************
*	void insert_rmnode()	  		        *
*	insert this rmmoved atnode into the  		*
*       removed-node list.	                        * 
*	for use with branch_and_bound			*
********************************************************/	

void
insert_rmnode(first, rmnode)
ATNODE **first, *rmnode;
{
static ATNODE *p;

if (*first == NULL) {
   *first = rmnode; 
   p = *first;
   p->next = NULL;
}
else {
   p->next = rmnode;
   p = rmnode;
   p->next = NULL;
}
return;
} /* insert_rmnode() */

/********************************************************
*	void insert_atnode()	  		        *
*	insert this atnode into the atlist.		*
*       for use with branch_and_bound  			*
********************************************************/	

void
insert_atnode(first, anode)
ATNODE **first, *anode;
{
ATNODE *p, *q;

if (*first == NULL)
   *first = anode;  /* insert into an empty list */
else if ((*first)->cost == anode->cost && (*first)->partno <= anode->partno) {
        anode->next = *first;
	*first = anode;       /* insert at the beginning of the list */

     }
     else {  /* anode is inserted in the middle or at the end of the list */
        p = *first;
        q = *first;
        while ( p != NULL && 
                ( (p->cost < anode->cost) ||
	          (p->cost = anode->cost) && (p->partno > anode->partno) 
                )
              ) {
           q = p;
           p = p->next;
        }
        anode->next = q->next;
        q->next = anode;
     }
return;
} /* insert_atnode() */

/********************************************************
*	void add_deps()					*
*	add the dependancies from attribute partition   *
* 	to ds and transitivly colse each ds and dp   	*
********************************************************/

void
add_deps(sid)
int sid;
{
int atno, attrno, maxatno;
int atid, attrid, atpart, atpos, attrpos ;
bool changed;

maxatno = symb->attr_num - 1;
for (atno = 0; atno <= maxatno; atno++) {

   atid = lookup_attr(sid, atno);
   atpos = ref_tab[atid].entry.attr.pos;
   atpart = ref_tab[atid].entry.attr.part;

   for (attrno = atno; attrno <= maxatno; attrno++) {

      attrid = lookup_attr(sid, attrno);
      attrpos = ref_tab[attrid].entry.attr.pos;

      /* add the dependencies: later assigned depend on earlier assigned */
#ifndef GORTO
      if (atpart > ref_tab[attrid].entry.attr.part) {
	 symb->ds[atpos][attrpos/WORD_LENGTH] |= 0x1 << attrpos%WORD_LENGTH;
	 symb->changed = TRUE;
      }
      else if (atpart < ref_tab[attrid].entry.attr.part) {
	 symb->ds[attrpos][atpos/WORD_LENGTH] |= 0x1 << atpos%WORD_LENGTH;
	 symb->changed = TRUE;
      }
#else
      if (atpart > ref_tab[attrid].entry.attr.part &&
	  ! symb->ds[atpos][attrpos]) {
	 symb->ds[atpos][attrpos] = T_PART;
	 symb->state |= S_CHANGED;
      }
      else if (atpart < ref_tab[attrid].entry.attr.part &&
	       ! symb->ds[attrpos][atpos]) {
	 symb->ds[attrpos][atpos] = T_PART;
	 symb->state |= S_CHANGED;
      }
#endif
    }
}

/* transitively close symb.ds */
if (maxpartno >= 1 && AUTOMATICALLY) { /* IDS has been changed */
   distributedeps(sid, &changed);
   if (changed)
      transitiveclosure();
}
   
return;
} /* add_deps() */

