/* $Id: ordout.c,v 3.1 1992/03/05 13:01:01 cogito Exp $ */
/* $Log: ordout.c,v $
 * Revision 3.1  1992/03/05  13:01:01  cogito
 * unchanged for LIGA-3
 *
 * Revision 1.1  1992/03/05  12:57:36  cogito
 * Initial revision
 *
 * Revision 2.2  1991/09/25  13:39:07  cogito
 * Modified Error-Messages to use err.c Module
 *
 * Revision 2.1  1991/06/10  13:26:01  cogito
 * sources for ORDER combined with GORTO
 * */
static char rcs_id[]= "$Id: ordout.c,v 3.1 1992/03/05 13:01:01 cogito Exp $";

/****************************************************************
*                                                               *
*       Module  : output.c                                      *
*                                                               *
*       Version : 1.0                                           *
*                                                               *
*       Author  : Jiyang Liu                                    *
*                                                               *
*       Contains routines to produce readable output.		*
*                                                               *
****************************************************************/

#include "order.h"
#include "ligaconsts.h"
#include "printerr.h"

/* functions */

bool member();
void print_stateText();
void print_headerForGraphs();
void print_symb_graph();
void print_SymbGraphs();
void print_syntax();
void print_rule_graph();
void print_RuleGraphs();
void print_visit_sequence();
void print_VisitSequences();

/****************************************
*       bool member()			*
****************************************/

bool 
member(pos, word)
int pos;
unsigned word;

{
int bit;
bit = pos%WORD_LENGTH;
if (word & 0x1<<bit)
   return (TRUE);
else 
   return (FALSE);
} /* member() */


/****************************************
*	void print_stateText()		*
****************************************/

void 
print_stateText(graph_state)
int graph_state;

{
  switch(graph_state) {
    case DIRECT:
      (void)fprintf(Prot,"DIRECT ");
    break;

    case TRANSITIVE:
      (void)fprintf(Prot,"TRANS. CLOSED ");
    break;

    case INDUCED:
      (void)fprintf(Prot,"INDUCED ");
    break;

    case PARTITIONED:
      (void)fprintf(Prot,"PARTITIONED ");
    break;
  }
} /* print_stateText() */


/****************************************
*       void print_headerForGraphs()    *
****************************************/

void
print_headerForGraphs(graph_state)
int graph_state;

{
  switch(graph_state) {
    case DIRECT:
      (void)fprintf(Prot,"GRAPHS FOR DIRECT DEPENDENCIES\n");
      (void)fprintf(Prot,"==============================\n\n");
    break;

    case TRANSITIVE:
      fprintf(Prot,"TRANSITIVE CLOSURE OF GRAPHS FOR DIRECT DEPENDENCIES\n ");
      fprintf(Prot,"====================================================\n\n");
    break;

    case INDUCED:
      fprintf(Prot,"TRANSITIVE CLOSURE OF GRAPHS FOR INDUCED DEPENDENCIES\n");
      fprintf(Prot,"=====================================================\n\n");
    break;

    case PARTITIONED:
      fprintf(Prot,"TRANSITIVE CLOSURE OF GRAPHS FOR PARTITION DEPENDENCIES\n");
      fprintf(Prot,"=======================================================\n\n");
    break;
  } /* switch */

} /* print_headerForGraphs() */


/********************************************************
* 	void print_symb_graph()				*
*       print the attribute dependency graph of 	*
*	the given symbol.				*
********************************************************/
void
print_symb_graph(sid)
int sid;
{
Symb symbdef;
SEQAttrdef  x;
Attrdef attr;
int atno = 0;
int depatno;

symbdef = ref_tab[sid].entry.symb.symb_def;

print_stateText(graphstate);
fprintf(Prot, "GRAPH FOR SYMBOL %s #%d AT ROW %d; COL %d\n",
               symbdef->dname,
               symbdef->did,
               symbdef->row,
               symbdef->col       );

fprintf(Prot, "  ATNO  CLASS  PART              SYMB.ATTR                DEPENDS ON\n");
if (ref_tab[sid].entry.symb.attr_num == 0)
  fprintf(Prot, " NO ATTR\n");
else 
/* print_dep_list */
   foreachinSEQAttrdef(symbdef->attrs, x, attr) {
   fprintf(Prot, "%5d", atno);
   switch (attr->class) {
   case ATCLSYNT: fprintf(Prot, "    SYNT ");
           break;
   case ATCLINH: fprintf(Prot, "    INH  ");
           break;
   default: fprintf(Prot, "    ???? ");
            break;
   }
   fprintf(Prot, " %3d    %15s.%-15s", attr->part, symbdef->dname, attr->name);
   if (member(atno, ref_tab[sid].entry.symb.ds[atno][atno/WORD_LENGTH]))
      fprintf(Prot, " CYCLIC [");
   else
      fprintf(Prot, "        [");
 
   for (depatno = 0; depatno < ref_tab[sid].entry.symb.attr_num; depatno++)
      if (member(depatno, ref_tab[sid].entry.symb.ds[atno][depatno/WORD_LENGTH]))
         fprintf(Prot, "%3d", depatno);
   fprintf(Prot, " ]\n");
   atno += 1;
   } /* foreach */

fprintf(Prot, "\n");
return;
} /* print_symb_graph() */

/****************************************
*	void print_SymbGraphs()		*
****************************************/

void
print_SymbGraphs()

{
int did, i;

i = 0;

if (PrintList[i] == PRINT_ALL)
   for (did = min_entry; did <= max_entry; did++) {
      if (ref_tab[did].etag == SYMB)
         print_symb_graph(did);
   }
else
   while ((did = PrintList[i++]) != END_OF_PRINT)
      print_symb_graph(did);

return;

} /* print_SymbGraphs() */


/********************************************************
*       void print_syntax()                             *
*       print the sytactic rule of a given rule         *
********************************************************/

void
print_syntax(pid)
int pid;
{
SLNODE *slnptr;
int sno = 0;

for (slnptr=ref_tab[pid].entry.prod.hdright; slnptr!=NULL; slnptr = slnptr->right) {
   fprintf(Prot, "  %s", ref_tab[slnptr->sid].entry.symb.symb_def->dname);
   if (sno == 0) 
      fprintf(Prot, " ::= ");
   sno++;
}
fprintf(Prot, "\n");
return;
} /* print_syntax() */

/********************************************************
*       void print_rule_graph()                         *
*       print the attribute dependency graph of 	*
*	a given rule					*
********************************************************/

void 
print_rule_graph(pid)
int pid;
{
SLNODE *r_slnptr, *c_slnptr;
SEQAttrdef x;
Attrdef attr;
int atno,  pos;

print_stateText(graphstate);
fprintf(Prot, "GRAPH FOR RULE %s #%d AT ROW %d; COL %d\n",
                ref_tab[pid].entry.prod.prod_def->dname, pid,
		ref_tab[pid].entry.prod.prod_def->row,
		ref_tab[pid].entry.prod.prod_def->col        );
print_syntax(pid);
fprintf(Prot, "  ATNO  CLASS  PART              SYMB.ATTR                DEPENDS ON\n");

/* loop on the row */
for (r_slnptr = ref_tab[pid].entry.prod.hdright; r_slnptr!=NULL; r_slnptr = r_slnptr->right) 
   if (ref_tab[r_slnptr->sid].entry.symb.attr_num == 0)
      fprintf(Prot, " NO ATTR\n");
   else {
      atno = r_slnptr->start_row;
      foreachinSEQAttrdef(ref_tab[r_slnptr->sid].entry.symb.symb_def->attrs, x, attr) {
           fprintf(Prot, "%3d", atno);
   	   switch (attr->class) {
   	   case ATCLSYNT: fprintf(Prot, "    SYNT ");
	       	   break;
   	   case ATCLINH: fprintf(Prot, "    INH  ");
		   break;
  	   default: fprintf(Prot, "    ???? ");
    		    break;
           }
	 fprintf(Prot, " %5d    %15s.%-15s", attr->part, ref_tab[r_slnptr->sid].entry.symb.symb_def->dname, attr->name);
     	 if (member(atno - r_slnptr->start_row, ref_tab[pid].entry.prod.dp[atno][r_slnptr->start_col+(atno-r_slnptr->start_row)/WORD_LENGTH]))
      	    fprintf(Prot, " CYCLIC [");
   	 else 
      	    fprintf(Prot, "        [");
   
/* loop on the column */ 
         for (c_slnptr = ref_tab[pid].entry.prod.hdright; c_slnptr!=NULL; c_slnptr = c_slnptr->right)
            if (ref_tab[c_slnptr->sid].entry.symb.attr_num > 0) 
 	      for (pos = 0; pos < ref_tab[c_slnptr->sid].entry.symb.attr_num; pos++) 
		 if (member(pos, ref_tab[pid].entry.prod.dp[atno][c_slnptr->start_col+pos/WORD_LENGTH])) 
	 		fprintf(Prot, "%3d", pos+c_slnptr->start_row);


    	 fprintf(Prot, " ]\n");
    	 atno++  ;
      } /* foreach */
   }
fprintf(Prot, "END RULE\n\n");
return;
} /* print_rule_graph()  */

/****************************************
*       void print_RuleGraphs()         *
****************************************/

void
print_RuleGraphs()

{
int did, i;

i = 0;

if (PrintList[i] == PRINT_ALL)
   for (did = min_entry; did <= max_entry; did++) {
      if (ref_tab[did].etag == PROD)
         print_rule_graph(did);
   }

else
   while ((did = PrintList[i++]) != END_OF_PRINT)
      print_rule_graph(did);

return;

} /* print_RuleGraphs() */




/********************************************************
*       void print_visit_sequence()                     *
*       print the visit sequences for one rule          *
*       in readable form.				*
********************************************************/

void
print_visit_sequence(pid)

int pid;

{

PRODENTRY *prod;
VSPTR vselmptr;
int vselmno;

prod = & ref_tab[pid].entry.prod;

fprintf(Prot,"VISIT-SEQUENCE FOR RULE %s #%d AT ROW %d; COL %d\n",
            prod->prod_def->dname, pid, prod->prod_def->row, prod->prod_def->col);

print_syntax(pid);
fprintf(Prot, " NO KIND  SYMBNO VISITNO  SYMBOL         ATTRIBUTE\n");

vselmno = 1;
for (vselmptr = prod->visitseq; vselmptr != NULL; vselmptr = vselmptr->next) {

   fprintf(Prot,"%3d ",vselmno++);
   
   switch (vselmptr->vscls) {

   case VSASSIG:   fprintf(Prot, "EVAL  %6d          %-15.14s%-15.14s",
		  	   vselmptr->vsinfo.assig.sno,
			   ref_tab[vselmptr->vsinfo.assig.sid].entry.symb.symb_def->dname,
			   ref_tab[vselmptr->vsinfo.assig.aid].entry.attr.attr_def->name);
		   break;

   case VSCOND:    fprintf(Prot, "CHECK                 CONDITION %s",
			   vselmptr->vsinfo.cond.idldef->name);

		   break;

   case VSVISIT:   if (vselmptr->vsinfo.visit.vssno == 0) 
	              fprintf(Prot, "LEAVE      0 %7d  TO ANCESTOR", 
			      vselmptr->vsinfo.visit.vsord);
                   else
                      fprintf(Prot, "VISIT %6d %7d  %-15.14s%-15.14s",
			      vselmptr->vsinfo.visit.vssno,
			      vselmptr->vsinfo.visit.vsord,
			      ref_tab[vselmptr->vsinfo.visit.vssid].entry.symb.symb_def->dname,
			      " ");
                   break;

   case VSPOP:
   case VSPUSH: break;

   default:	   fprintf(Prot, "*** ERROR *** in VISIT-SEQUENCE of RULE %s #%d AT ROW %d; COL %d\n",
		          prod->prod_def->dname, pid, prod->prod_def->row, prod->prod_def->col);
                   err_setpos(prod->prod_def->row, prod->prod_def->col);
                   err_print_error("in Visit Sequence of Rule.");
		   break;
                           
   } /* end of switch */

   fprintf(Prot,"\n");

} /* for */

fprintf(Prot,"\n");

return;
} /* print_visit_sequence() */

/********************************************************
*       void print_VisitSequences()                     *
*       print the visit sequences for all rules         *
*       in readable form.                               *
********************************************************/

void
print_VisitSequences()

{

int did, i;

i = 0;

fprintf(Prot,"VISIT-SEQUENCES\n");
fprintf(Prot,"===============\n");

if (PrintList[i] == PRINT_ALL)
   for (did = min_entry; did <= max_entry; did++) {
      if (ref_tab[did].etag == PROD)
         print_visit_sequence(did);
   }

else 
   while ((did = PrintList[i++]) != END_OF_PRINT)
      print_visit_sequence(did);

return;

} /* print_VisitSequences() */
