/******************************************************************************/
/* filename: tdframe.h                        first edit   :   3 . 12 . 90    */
/* author  : Christian Zeitel                 last change  :  13 . 12 . 90    */
/******************************************************************************/

/***************************  A UNIVERSAL PARSERFRAME  ************************/

/******************************** INCLUDE-FILES *******************************/

#define INTEGRATED    /* indicate the new parser-version for  */
                      /* interface-file parser.h              */

#include "parser.h"   /* interfaces to other compiler-modules */

#undef ERROR          /* avoid a redeclaration of ERROR in file err.h */

/* In EliV3.0 symbol connections are done with structure connections. Therefore
 * COLA cannot find semantic terminals.
 *
 * #include "seminf.h"	/* contains for each terminal the information,	*
 *			/* whether it's semantic or not			*
 */

/********************************** MACRO-CONSTANTS ***************************/

/* states of switches */

#define YES         1

#define NO          0
	      
#define ST_NORMAL   0

#define ST_ERROR    1

#define ST_KEEP     2

#define ST_GENSYM   3

/* size of the queue for deleted semantic terminal-symbols */

#define QUEUESIZE   200

/* offset to divide systemconnections and userconnections */

#define OFFSET      9

/************************* ERROR-REPORT-TEXTS *********************************/

#define SXERROR    text[2]

#define SFERROR    text[1]

#define PTERROR    text[0]

#define INSERT     text[3]

#define DELETE     text[4]

#define CONTIN     text[5]

#define FULLQUEUE  text[6]

/******************************* ERROR-CLASSES ********************************/

#define INFO           0

#define SXERR          1

#define REPAIR         2

#define LIMIT          3

#define EXIT           4

#define WARN           5

/******** FUNCTION-MACROS FOR COLLECTING SKIPPED TERMINALS *******************/

#define Insert_queue( term, val ) \
        { \
           if ( pe >= QUEUESIZE ) {\
                  errormsg( LIMIT, FULLQUEUE, &token ); \
                  pe = QUEUESIZE - 1; \
           } \
           queue[pe].Val    = val; \
           queue[pe++].Term = term; \
        }
/* inserts terminals which are skipped */
/* during error-recovery into queue    */


#define Search_in_queue( term, val ) \
           val    = DEFAULT_VALUE; \
           for( i = 0; i < pe; i++ ) \
                if( queue[i].Term == term ) { \
                        val   = queue[i].Val; \
                        for(j = i; j < pe-1; j++) { \
                                queue[j].Term = queue[j+1].Term; \
                                queue[j].Val  = queue[j+1].Val ; \
                        } \
                        pe--; \
                        break; \
                } \

/* this function-macro searches in queue for the first occurence of an   */
/* attribute-value  for a given terminal coded in term. If no fitting    */
/* attribute-value is found, a default-value is assigned to val.         */

#define Is_semantic( term ) (0)
/* this function-marco determines, whether a terminalsymbol, given       */
/* by its syntaxcode in term is semantic.                                */

/* This would be correct, if there could be semantic terminals. See also comment
 * at #include "seminf.h" above.
 * #define Is_semantic( term ) \
 *      ( ( semalst[(term - BASE) >> 3] >> ( (term - BASE) & 0x0007 ) ) & 0x01 )
 */

/***************************** TYPE-DEFINITION ********************************/

typedef struct  {

    attrvaltype    Val;
    short          Term;
       
} queue_entry;

/**************************  ERROR-REPORT-TEXTS *******************************/

/* datastructure for generating a default attribute-value  */
/* for a generated error-token during error-recovery       */

static char *text[7] = {
        "Wrong parse tables",                                  /* 0 */
        "Parse stack overflow",                                /* 1 */
        "Syntax error",                                        /* 2 */
        "Symbol inserted",                                     /* 3 */
        "Symbol deleted",                                      /* 4 */
        "Parsing resumed here",                                /* 5 */
        "queue for skipped semantic terminals has overflown"}; /* 6 */

     
/* key        : wrong parse tables = 0  symbol inserted = 3           */
/*              stack overflow     = 1  symbol deleted  = 4           */
/*              syntax error       = 2  restart point   = 5           */
/*              semantic queue overflow = 6                           */
/*                                                                    */
/* token      : the current token                                     */
/*                                                                    */
/*                                                                    */
/* when a syntax error occurs, the inserted or deleted tokens are     */
/* reported. The succession of tokens is directed by the calling      */
/* sequence of procedure message. Additionally, the position of       */
/* the next correct input token is reported.                          */

/**************************** VARIABLES ***************************************/
               
static tokentype token, oldtoken, rst_token;   
                                /* contains the current token and the restart-*/
                                /* token                                      */
static attrvaltype val;         /* saves the attribute-value of a             */
                                /* semantic terminal-symbol                   */
static queue_entry 
           queue[QUEUESIZE];    /* queue which saves                          */
         		        /* semantic terminals and their attribute-    */
         		        /* values skipped during error-recovery       */
static unsigned char   pe = 0;      /* tailpointer for queue of skipped semantic  */
                	        /* symbols				      */
                	        
/******************************* FUNCTIONS ************************************/

static void user( action ) /* procedure for user-defined connections */
    short action;
{
#include "semprods.h"
}

/********************* MACRO-CALLS FOR CONNECTION-POINTS **********************/

#define E_READ( term )\
/* get a new terminaltoken from the scanner     */ \
/* during error-recovery. Insert the old termi- */ \
/* nal into a queue                             */ \
{\
  Insert_queue( term, selectattr(token) );\
  errormsg( REPAIR, DELETE, &token );\
  gettok( &token );\
  term = selectsxcode( token ); \
}

#define N_READ( term )\
/* get a new terminaltoken from the scanner    */ \
/* during normal-parse accept the old terminal */ \
{\
  if( Is_semantic( term ) )\
         symbconn( &token );\
  gettok( &token );\
  term = selectsxcode( token ); \
}

#define ACCEPTAC( )\
/* the input has been accepted */\
return;

#define SX_ERROR( )\
/* the core detected a syntax-error */\
errormsg( SXERR, SXERROR, &token );

#define SF_ERROR( )\
/* overflow of the parser-stack    */\
errormsg( LIMIT, SFERROR, &token );

#define PT_ERROR( )\
/* Wrong parse-tables are detected */\
errormsg( EXIT, PTERROR, &token );

#define KEEP( )\
/* a restart-point has been found  */\
rst_token = token;

#define GENERATE( term )\
/* generate an error-token and insert it into  */\
/* the source-text. If corresponding terminal  */\
/* for this error-token is semantic, make a    */\
/* symbolconnection                            */\
Search_in_queue( term, val );\
gentok( term, val, &token );\
if( Is_semantic( term ) )\
     symbconn( &token );\
errormsg( REPAIR, INSERT, &token );

#define CONTINUE( )\
/* continue normal parsing */\
token = rst_token;\
errormsg( INFO, CONTIN, &token );

#define USER( action )\
/* make connection for a semantic production */\
user( action );
