
/* $Id: optout.c,v 1.7 1991/11/22 09:07:03 cogito Exp $ */
/* $Log: optout.c,v $
 * Revision 1.7  1991/11/22  09:07:03  cogito
 * modifications for error processing
 *
 * Revision 1.6  1991/10/04  13:05:56  cogito
 * Warning and Info-messages passed to the
 * message function.
 *
 * Revision 1.5  1991/01/15  17:49:49  cogito
 * new IDL interface
 *
 * Revision 1.4  90/12/04  16:26:18  cogito
 * new version of option handler
 *  */
static char rcs_id[]= "$Id: optout.c,v 1.7 1991/11/22 09:07:03 cogito Exp $";

/************************************************/
/*                                              */
/*       Version : 1.0                          */
/*                                              */
/*       Module  : optout.c                     */
/*                                              */
/*       Contains the routines to write out     */
/*       results of the module liga.optim       */
/*                                              */
/************************************************/



/************************************************/
/*                   includes                   */
/************************************************/


#include <stdio.h>
#include <string.h>

#include "option_enums.h"
#include "option_types.h"

#include "lookup_idl.h"
#include "OPTIM.h"
#include "OPTIMMacros.h"
#include "optglobal.h"
#include "optidl.h"

#include "opterr.h"


/************************************************/
/*              global variables                */
/************************************************/

int terminalattrcounter=0;


/************************************************/
/*                   functions                  */
/************************************************/

int	NameOfCall	( /* String */ );

char	*GlobName	( /* Attributes, Attrdef */);
char	*GroupName	( /* Group, Attrdef */ );

Boolean IdentAssign	( /* Call, int */ );

void    ElimIdentAssignments		( /* AttrEval */ );
void 	PutResultsToInterface		( /* Visit_Sequences */ );
void	StatisticToListing		( /* Visit_Sequences */ );
void	WriteAttrStatusToListing	( /* Visit_Sequences */ );
void	WriteGroupingResultsToListing	( /* Visit_Sequences */ );
void	WriteVisitSequencesToListing	( /* Visit_Sequences, Boolean */ );
void	OptResultsOut			( /* Visit_Sequences */ );





/************************************************/
/*                NameOfCall                    */
/************************************************/

int NameOfCall(name)
String   name;
{
  int   key;
  
  if (strcmp(name, "assign") == 0) { key = ASSIGN; }
  else if (strcmp(name, "PUSH") == 0) { key = PUSH; }
       else if (strcmp(name, "POP") == 0) { key = POP; }
            else if (strcmp(name, "CLOBBER") == 0) { key = CLOBBER; }
                 else if (strcmp(name, "SWAP") == 0) { key = SWAP; }
                      else { key = CONDITION; }

  return(key);

} /* end of NameOfCall */





/************************************************/
/*                    GlobName                  */
/************************************************/

char *GlobName(attr, attrdef)
Attributes   attr;
Attrdef      attrdef;
{
  char   *name;

  attrdef->globname = malloc(strlen(attr->sname) + strlen(attr->aname) + 1);
  name = malloc(strlen(attr->sname) + strlen(attr->aname) + 1);
  if (attrdef->globname == (char*) 0 || name == (char*) 0) {
      err_setpos(0,0);
      err_print_deadly("no more memory");
      
      fprintf(listing,"*** ERROR: no more memory \n");
      exit(5);
  }
  strcpy(name, attr->sname);
  strcat(name, attr->aname);

  return(name);

} /* end of GlobName */





/************************************************/
/*                   GroupName                  */
/************************************************/

char *GroupName(group, attrdef)
Group     group;
Attrdef   attrdef;
{

  attrdef->globname = malloc(strlen(group->name) + 1);
  if (attrdef->globname == (char*) 0) {
      err_setpos(0,0);
      err_print_deadly("no more memory");
      fprintf(listing,"*** ERROR: no more memory \n");
      exit(5);
  }

  return(group->name);

} /* end of GroupName */





/************************************************/
/*                   IdentAssign                */
/************************************************/

Boolean IdentAssign(call, key)
Call   call;
int    key;
{
  Expr            expr1, expr3, clobbername, clobberindex, topname, topindex;
  Call            top;
  SEQGroup        X;
  Group           thisgroup;
  SEQAttributes   Y;
  Attributes      groupattr;
  Attrdef         attrdef1, attrdef3;
  int             length = lengthSEQExpr(call->params);
  Boolean         attr1ingroup, attr3ingroup;

  switch (key)
  {
     case ASSIGN  :
	if (length != 2)
	  return (FALSE);
	retrievefirstSEQExpr(call->params, expr1);
	retrievelastSEQExpr(call->params, expr3);
	if (typeof(expr3) != KAttracc)
	  return (FALSE);
	attrdef1 = lookup_attrdef(expr1.VAttracc->attrid);
	attrdef3 = lookup_attrdef(expr3.VAttracc->attrid);
	foreachinSEQGroup(optimroot->groups, X, thisgroup)
	{
	  attr1ingroup = attr3ingroup = FALSE;
	  foreachinSEQAttributes(thisgroup->members, Y, groupattr)
	  {
	    if (groupattr->attrid == attrdef1->did)
	      attr1ingroup= TRUE;
	    if (groupattr->attrid == attrdef3->did)
	      attr3ingroup= TRUE;
	    if (attr1ingroup && attr3ingroup)
	      return (TRUE);
	  }
	}
	return (FALSE);
        break;
     case CLOBBER :
	retrievefirstSEQExpr(call->params, clobbername);
	retrievelastSEQExpr(call->params, expr3);
	if (typeof(expr3) == KCall && strcmp(expr3.VCall->name, "TOP") == 0)
	{
	  ithinSEQExpr(call->params, 2, clobberindex);
	  top = expr3.VCall;
	  retrievefirstSEQExpr(top->params, topname);
	  retrievelastSEQExpr(top->params, topindex);
	  if (clobberindex.VVal->v != topindex.VVal->v ||
	      strcmp(clobbername.VName->n, topname.VName->n) != 0)
	    return (FALSE);
	}
	else
	  return (FALSE);
	break;
     default : break;
  } /* end of switch */

  return (TRUE);

} /* end of IdentAssign */





/************************************************/
/*              ElimIdentAssignments            */
/************************************************/

void ElimIdentAssignments(root)
AttrEval   root;
{
  SEQAttribution   X;
  Attribution      attribution;
  SEQAttrrule      Y;
  Attrrule         attrrule;
  Call             call;

  foreachinSEQAttribution(root->attrrules, X, attribution) {
     foreachinSEQAttrrule(attribution->attrrules, Y, attrrule) {
        if (typeof(attrrule) == KCall) {
          call = attrrule.VCall;
          if (strcmp(call->name, "assign") == 0) {
            if (IdentAssign(call, ASSIGN)) {
              identassigns++;
              if (!protocol_option)
                { removeSEQAttrrule(attribution->attrrules, attrrule); }
              /* HINT: if protocol_option, then attrrule is removed */
              /*       by FUNCTION WriteVisitSequencesToListing     */
            }
            totalassigns++;
          }
          else {
            if (strcmp(call->name, "CLOBBER") == 0) {
              if (IdentAssign(call, CLOBBER)) {
                identassigns++;
                if (!protocol_option)
                  { removeSEQAttrrule(attribution->attrrules, attrrule); }
              }
              totalassigns++;
            }
            else if (strcmp(call->name,"PUSH") == 0) { totalassigns++; }
          }
        }
     }
  }

} /* end of ElimIdentAssignments */





/************************************************/
/*            PutResultsToInterface             */
/************************************************/

void PutResultsToInterface(root)
Visit_Sequences   root;
{
  SEQGroup        X;
  Group           thisgroup;
  SEQAttributes   Y;
  Attributes      thisattr;
  SEQAttrdef      A;
  Attrdef         attrdef;
  SEQDef          Z;
  Def             def;

  foreachinSEQGroup(root->groups, X, thisgroup) {
     foreachinSEQAttributes(thisgroup->members, Y, thisattr) {
        attrdef = lookup_attrdef(thisattr->attrid);
        if (thisgroup->class == GLOBAL_VARIABLE)
          { attrdef->store = GLOBAL_VARIABLE; }
        else
          { attrdef->store = GLOBAL_STACK; }
        attrdef->globname = GroupName(thisgroup, attrdef);
     }
  }
  foreachinSEQAttributes(root->glob_var, Y, thisattr) {
     attrdef           = lookup_attrdef(thisattr->attrid);
     attrdef->store    = GLOBAL_VARIABLE;
     attrdef->globname = GlobName(thisattr, attrdef);
  }
  foreachinSEQAttributes(root->single_visit, Y, thisattr) {
     attrdef           = lookup_attrdef(thisattr->attrid);
     attrdef->store    = GLOBAL_STACK;
     attrdef->globname = GlobName(thisattr, attrdef);
  }
  foreachinSEQAttributes(root->tree_attrs, Y, thisattr) {
     attrdef        = lookup_attrdef(thisattr->attrid);
     attrdef->store = TREE_ATTR;
     if (thisattr->termattr) { terminalattrcounter++; }
  }

  fprintf(listing,"\n\n");
  foreachinSEQDef(ligaroot->defseq, Z, def) {
     if (typeof(def) == KSymb) {
       foreachinSEQAttrdef(def.VSymb->attrs, A, attrdef) {
          if (attrdef->store == UNKNOWN) {
	    char errmsgbuff[ERR_BUFF_LEN];
	    err_setpos(def.VSymb->row, def.VSymb->col);
	    sprintf (errmsgbuff, "ATTRIBUTE %s.%s is defined, but never used.",
		     def.VSymb->dname, attrdef->name);
	    err_print_warning (errmsgbuff);

            attrdef->store = TREE_ATTR;
            fprintf(listing,"*** WARNING: Attribute %s.%s is defined by LIDO-Definition, but never used !!\n",
                             def.VSymb->dname, attrdef->name);
          }
       }
     }
  }
  fprintf(listing,"\n\n");

} /* end of PutResultsToInterface */





/************************************************/
/*             StatisticToListing               */
/************************************************/

void StatisticToListing(root)
Visit_Sequences   root;
{
  int   diff1 = treeattrcounter - terminalattrcounter - inclattrcounter;
  int   diff2 = totalassigns - identassigns;
  
  fprintf(listing,"*****          LIGA OPTIMIZER RESULTS          *****");
  fprintf(listing,"\n\n\n");
  fprintf(listing,"NUMBER OF GLOBAL VARIABLES      : %5d",globvarcounter);
  fprintf(listing,"\n\n");
  fprintf(listing,"      -> %d OF THESE ATTRIBUTES ARE NEVER USED",neverusedcounter);
  fprintf(listing,"\n\n\n");
  fprintf(listing,"NUMBER OF GLOBAL STACKS         : %5d",globstackcounter);
  fprintf(listing,"\n\n\n");
  fprintf(listing,"NUMBER OF TREE NODES KOMPONENTS : %5d",treeattrcounter);
  fprintf(listing,"\n\n");
  fprintf(listing,"   because: -> %3d ATTRIBUTES HAVE TOO LONG LIFETIMES",diff1);
  fprintf(listing,"\n");
  fprintf(listing,"            -> %3d ATTRIBUTES ARE TERMINAL-ATTRIBUTES",terminalattrcounter);
  fprintf(listing,"\n");
  fprintf(listing,"            -> %3d ATTRIBUTES ARE ACCESSED BY NOT EXPANDED INCLUDING",inclattrcounter);
  fprintf(listing,"\n\n\n");

  fprintf(listing,"*****          RESULTS OF GROUPING          *****");
  fprintf(listing,"\n\n");
  fprintf(listing,"NUMBER OF GENERATED VARIABLE-GROUPS : %5d",vargroupcounter);
  fprintf(listing,"\n");
  fprintf(listing,"NUMBER OF GENERATED STACK-GROUPS    : %5d",stackgroupcounter);
  fprintf(listing,"\n\n");
  fprintf(listing,"NUMBER OF DELETED IDENTICAL ASSIGNS : %5d",identassigns);
  fprintf(listing,"\n");
  fprintf(listing,"    -> NEW NUMBER OF SEMANTIC RULES : %5d",diff2);
  fprintf(listing,"\n\n\n");
  
  fprintf(listing,"*****     RESULTS OF CHANGES IN VISIT-SEQUENCES     *****");
  fprintf(listing,"\n\n");
  fprintf(listing,"INSERTED PUSH's    : %5d\n",pushcounter);
  fprintf(listing,"INSERTED POP's     : %5d\n",popcounter);
  fprintf(listing,"INSERTED TOP's     : %5d\n",topcounter);
  fprintf(listing,"INSERTED SWAP's    : %5d\n",swapcounter);
  fprintf(listing,"INSERTED CLOBBER's : %5d\n",clobbercounter);
  fprintf(listing,"\n\n\n");

} /* end of StatisticToListing */





/************************************************/
/*          WriteAttrStatusToListing            */
/************************************************/

void WriteAttrStatusToListing(root)
Visit_Sequences   root;
{
  SEQGroup        X;
  Group           thisgroup;
  SEQAttributes   Y;
  Attributes      attr;

  fprintf(listing,"*****     LIST OF ATTRIBUTE-CLASSIFICATIONS     *****");
  fprintf(listing,"\n\n");

  foreachinSEQAttributes(root->glob_var, Y, attr) {
     fprintf(listing,"RESULT FOR ATTR. %s.%s :\n", attr->sname, attr->aname);
     if (attr->not_used)
       { fprintf(listing,"   -> VARIABLE: ATTRIBUTE NOT USED IN TREE\n"); }
     if (attr->termattr)
       { fprintf(listing,"   -> ATTRIBUTE OF A TERMINAL SYMBOL\n"); }
     fprintf(listing,"   -> GLOBAL VARIABLE\n");
  }
  fprintf(listing,"\n");
  if (group_all_option || var_group_option || var_group_list_option) {
    foreachinSEQGroup(root->groups, X, thisgroup) {
       if (thisgroup->class == GLOBAL_VARIABLE) {
         foreachinSEQAttributes(thisgroup->members, Y, attr) {
            fprintf(listing,"RESULT FOR ATTR. %s.%s :\n", attr->sname, attr->aname);
            if (attr->not_used)
              { fprintf(listing,"   -> VARIABLE: ATTRIBUTE NOT USED IN TREE\n"); }
            if (attr->termattr)
              { fprintf(listing,"   -> ATTRIBUTE OF A TERMINAL SYMBOL\n"); }
            fprintf(listing,"   -> GLOBAL VARIABLE\n");
         }
       }
    }
  }

  fprintf(listing,"\n\n");
  foreachinSEQAttributes(root->single_visit, Y, attr) {
     fprintf(listing,"RESULT FOR ATTR. %s.%s :\n", attr->sname, attr->aname);
     if (attr->termattr)
       { fprintf(listing,"   -> ATTRIBUTE OF A TERMINAL SYMBOL\n"); }
     fprintf(listing,"   -> GLOBAL STACK\n");
  }

  if (group_all_option || stack_group_option || stack_group_list_option) {
    foreachinSEQGroup(root->groups, X, thisgroup) {
       if (thisgroup->class != GLOBAL_VARIABLE) {
         foreachinSEQAttributes(thisgroup->members, Y, attr) {
            fprintf(listing,"RESULT FOR ATTR. %s.%s :\n", attr->sname, attr->aname);
            if (attr->termattr)
              { fprintf(listing,"   -> ATTRIBUTE OF A TERMINAL SYMBOL\n"); }
            fprintf(listing,"   -> GLOBAL STACK\n");
         }
       }
    }
  }

  fprintf(listing,"\n\n");
  foreachinSEQAttributes(root->tree_attrs, Y, attr) {
     fprintf(listing,"RESULT FOR ATTR. %s.%s :\n", attr->sname, attr->aname);
     if (attr->termattr)
       { fprintf(listing,"   -> ATTRIBUTE OF A TERMINAL SYMBOL\n"); }
     if (attr->gen == NOT_EXPANDED_INCLUDING)
       { fprintf(listing,"   -> IGNORED EXPANSION ATTRIBUTE\n"); }
     fprintf(listing,"   -> TREE NODE ATTRIBUTE\n");
  }
  fprintf(listing,"\n\n\n");

} /* end of WriteAttrStatusToListing */





/************************************************/
/*         WriteGroupingResultsToListing        */
/************************************************/

void WriteGroupingResultsToListing(root)
Visit_Sequences   root;
{
  SEQGroup        X;
  Group           thisgroup;
  SEQAttributes   Y;
  Attributes      thisattr;
  int             counter=0;

  fprintf(listing,"*****     LIST OF GENERATED GROUPS     *****");
  fprintf(listing,"\n\n");

  foreachinSEQGroup(root->groups, X, thisgroup) {
     fprintf(listing,"\n");
     fprintf(listing,"MEMBERS OF ");
     switch (thisgroup->class) {
        case GLOBAL_VARIABLE :
           fprintf(listing,"VARIABLE-GROUP "); break;
        case PFBPFA :
           fprintf(listing,"STACK-GROUP "); break;
        case PFAPFB :
           fprintf(listing,"STACK-GROUP "); break;
        case PPFA   :
           fprintf(listing,"STACK-GROUP "); break;
        default : break;
     } /* end of switch */
     fprintf(listing,"%s :",thisgroup->name);
     fprintf(listing,"\n");
     counter = 0;
     foreachinSEQAttributes(thisgroup->members, Y, thisattr) {
     	counter++;
        fprintf(listing,"   %3d.: %s.%s",counter,thisattr->sname,thisattr->aname);
        fprintf(listing,"\n");
     }
  }
  fprintf(listing,"\n\n\n");

} /* end of WriteGroupingResultsToListing */





/************************************************/
/*          WriteVisitSequencesToListing        */
/************************************************/

void WriteVisitSequencesToListing(root, grouping)
Visit_Sequences   root;
Boolean           grouping;
{
  SEQAttribution   X;
  Attribution      vs;
  Def              def;
  Prod             prod;
  SEQAttrrule      Y;
  Attrrule         action;
  Call             call;
  Visit            visit;
  Attributes       attr;
  Expr             eval, value;
  int              key;

  fprintf(listing,"*****     NEW VISIT-SEQUENCES     *****");
  fprintf(listing,"\n\n");

  foreachinSEQAttribution(ligaroot->attrrules, X, vs) {
     def  = lookup_def(vs->prodid);
     prod = def.VProd;
     fprintf(listing,"\n*****     VS for rule %s     *****\n",prod->dname);
     foreachinSEQAttrrule(vs->attrrules, Y, action)
        switch (typeof(action)) {
           case KVisit:
              visit = action.VVisit;
              if (visit->symbno == LEAVE) {
                fprintf(listing,"   LEAVE     to the ancestor for %d. time",visit->ord);
                fprintf(listing,"\n");
              }
              else {
            	fprintf(listing,"   VISIT     no. %d to symbol no. %d",visit->ord, visit->symbno);
              	fprintf(listing,"\n");
              }
              break;
           case KCall :
              call = action.VCall;
              key = NameOfCall(call->name);
              switch (key) {
                 case ASSIGN :
                    retrievefirstSEQExpr(call->params, eval);
                    attr = LookupAttribute(eval.VAttracc->attrid);
                    fprintf(listing,"   EVAL      %s[%d].%s",
                              attr->sname, eval.VAttracc->symbno, attr->aname);
                    if (grouping) {
                      if (IdentAssign(call, ASSIGN)) {
                        fprintf(listing,"     ***  IS DELETED   ***\n");
                        removeSEQAttrrule(vs->attrrules, action);
                      }
                      else fprintf(listing,"\n");
                    }
                    else fprintf(listing,"\n");
                    break;
                 case PUSH :
                    retrievefirstSEQExpr(call->params, eval);
               	    fprintf(listing,"   PUSH      %s\n",eval.VName->n);
                    break;
                 case POP :
                    retrievefirstSEQExpr(call->params, eval);
                    retrievelastSEQExpr(call->params, value);
                    fprintf(listing,"   POP       %s at stack pos. %d\n",
                      eval.VName->n, value.VVal->v);
                    break;
                 case SWAP :
                    retrievefirstSEQExpr(call->params, eval);
                    retrievelastSEQExpr(call->params, value);
                    fprintf(listing,"   SWAP      %s with stack pos. %d\n",
                              eval.VName->n, value.VVal->v);
                    break;
                 case CLOBBER :
                    retrievefirstSEQExpr(call->params, eval);
                    retrievefirstSEQExpr(tailSEQExpr(call->params), value);
                    fprintf(listing,"   CLOBBER   %s at stack pos. %d",
                            eval.VName->n, value.VVal->v);
                    if (grouping) {
                      if (IdentAssign(call, CLOBBER)) {
                        fprintf(listing,"     ***  IS DELETED   ***\n");
                        removeSEQAttrrule(vs->attrrules, action);
                      }
                    }
                    else { fprintf(listing,"\n"); }
                    break;
                 case CONDITION :
                    fprintf(listing,"   CHECK     CONDITION %s \n", call->name);
                    break;
                 default : break;
              } /* end of switch */
              break;
           default : break;
        } /* end of switch */
  }
  fprintf(listing,"\n\n\n");

} /* end of WriteVisitSequencesToListing */





/************************************************/
/*                OptResultsOut                 */
/************************************************/

void OptResultsOut(root)
Visit_Sequences   root;
{
  Boolean   grouping;
  
  grouping = group_all_option || var_group_option || var_group_list_option
	|| stack_group_option || stack_group_list_option;

  PutResultsToInterface(root);

  if (grouping)
    ElimIdentAssignments(ligaroot);

  StatisticToListing(root);

  if (protocol_option) {

    WriteAttrStatusToListing(root);

    if (grouping) { WriteGroupingResultsToListing(root); }

    WriteVisitSequencesToListing(root, grouping);

  }

} /* end of OptResultsOut */

