# $Id: Makefile.cpp,v 1.11.1.2 1992/08/17 20:22:09 kadhim Exp $

# Programs

SHELL	= /bin/sh
CC	= cc
MAKE    = make

# directories

DISTRIB = /tmp
DESTDIR = /tmp

IDL	= ../idl
OPTHANDLER	= ../option

# files

GORTO		= ../ligaGorto
GORTO_OBJS	= \
   Actions.o Arrange.o Bitmaps.o Debug.o DepLayout.o Drawing.o Graph.o \
   Hide.o Lido.o Main.o MainList.o MainWindow.o Message.o Order.o OrderStrategy.o \
   PathFind.o PopupUtil.o ProdCreate.o ProdDep.o ProdDraw.o ProdMenu.o \
   ProdSelect.o ProdSymbol.o ProdUtil.o Reftab.o Resources.o SymbAttrs.o \
   SymbCreate.o SymbDep.o SymbDraw.o SymbMenu.o SymbProd.o SymbSelect.o \
   SymbUtil.o Util.o VisitCreate.o VisitDraw.o VisitLife.o VisitMenu.o \
   VisitSelect.o VisitUtil.o

IDL_LIB		= $(IDL)/IDL.a

XI	= XINC
XL	= XLIB

# options
# LIBS should refer to the libraries of X Version 11, Release 4

CFLAGS		= -O -DGORTO -I$(IDL) -I$(XI)
COFLAGS		= -q
LFLAGS		= -O

#ifdef hpux
LIBS		= $(IDL_LIB) -lm \
		-L$(XL) -lXaw -lXmu -lXt -lXext -lX11 \
		$(OPTHANDLER)/opt_input.o order.a \
		  ../ligascel/err.o ../ligascel/source.o
#else
LIBS		= $(IDL_LIB) -lm $(XL)/libXaw.a $(XL)/libXmu.a \
		$(XL)/libXt.a $(XL)/libXext.a \
		$(XL)/libX11.a $(OPTHANDLER)/opt_input.o order.a \
		  ../ligascel/err.o ../ligascel/source.o
#endif

# cleaning

TIDY    = core a.out  *% lintmsg *.p *.o order.a ERRS
CLEAN   = $(TIDY) *.exe ../ligaGorto
CLOBBER = $(CLEAN)

SRC	= Actions.c Main.c  ProdDep.c SymbCreate.c VisitDraw.c \
	  Arrange.c MainList.c ProdDraw.c SymbDep.c VisitLife.c \
	  Bitmaps.c MainWindow.c ProdMenu.c SymbDraw.c VisitMenu.c \
	  Debug.c  Message.c ProdSelect.c SymbMenu.c VisitSelect.c \
	  DepLayout.c Order.c  ProdSymbol.c SymbProd.c VisitUtil.c \
	  Drawing.c OrderStrategy.c ProdUtil.c SymbSelect.c \
	  Graph.c  PathFind.c Reftab.c SymbUtil.c \
	  Hide.c  PopupUtil.c Resources.c Util.c \
	  Lido.c  ProdCreate.c SymbAttrs.c VisitCreate.c

HEADER	= Create.h Main.h Popup.h Symb.h \
	  Graph.h Misc.h Prod.h Visit.h

CONF	= Basic Cascade.bm CheckMark.bm Colors Gorto.ad Icon.bm \
	  Sizes.default Sizes.large Sizes.small Strings.english \
	  Strings.german STRUCTURE Sizes.tiny

AUX	= $(CONF) Makefile.cpp README

RCS	= $(SRC) $(HEADER) $(CONF)

all:	$(GORTO)

$(GORTO): $(GORTO_OBJS) order.a
	$(CC) $(LFLAGS) $(GORTO_OBJS) $(LIBS) -o $(GORTO)

# installation

install:	$(GORTO)
	rm -f $(DESTDIR)/Tool/liga/ligaGorto
	cp $(GORTO) $(DESTDIR)/Tool/liga/ligaGorto
	chmod 755 $(DESTDIR)/Tool/liga/ligaGorto

# distribution

distrib:
	-rm -rf $(DISTRIB)/gorto
	mkdir $(DISTRIB)/gorto
	cp $(SRC) $(HEADER) $(AUX) $(DISTRIB)/gorto
	cd $(DISTRIB)/gorto; chmod 0644 $(SRC) $(HEADER) $(AUX)

# SourceDistribution

SourceDistr: $(SRC) $(HEADER) $(AUX)

# checkout

checkout:
	-co $(COFLAGS) $(RCS)
	-co $(COFLAGS) src.gorto.README; cp src.gorto.README README; \
		chmod ug+w README

rcsclean:
	rm -rf $(CLEAN) Makefile Makefile.cpp
	-rcsclean $(COFLAGS) $(RCS) src.gorto.README

# cleaning targets

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(RCS)
	-rcs -bOriginal.1 -q Makefile.cpp $(RCS)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q $(RCS)

tidy:
	rm -rf $(TIDY)

clean:
	rm -f $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

# libraries and object files

order.a:
	(cd ../order; $(MAKE) 'CC=$(CC)' 'EXTCFLAGS=-DGORTO' ../gorto/order.a)

# Dependencies on Include-Files

.PRECIOUS: $(SRC) $(HEADER) $(AUX)

Actions.o: Misc.h Prod.h Symb.h Visit.h Graph.h
Arrange.o: Misc.h Main.h 
Bitmaps.o: Misc.h Main.h CheckMark.bm Cascade.bm Icon.bm
Debug.o: Misc.h Visit.h
DepLayout.o: Misc.h
Drawing.o: Misc.h
Graph.o: Graph.h
Hide.o: Misc.h Create.h Prod.h Main.h Popup.h
Lido.o: Misc.h Main.h Popup.h
Main.o: Misc.h Main.h
MainList.o: Misc.h Create.h Prod.h Symb.h Popup.h Main.h
MainWindow.o: Misc.h Create.h Prod.h Symb.h Visit.h Popup.h Main.h 
Message.o: Misc.h Create.h Main.h Popup.h
Order.o: Misc.h Prod.h Symb.h Visit.h Main.h
OrderStrategy.o: Misc.h Create.h Main.h 
PathFind.o: Misc.h Prod.h Symb.h
PopupUtil.o: Misc.h Main.h Popup.h
ProdCreate.o: Misc.h Create.h Graph.h Main.h Prod.h
ProdDep.o: Misc.h Symb.h Main.h Prod.h
ProdDraw.o: Misc.h Prod.h
ProdMenu.o: Misc.h Create.h Visit.h Graph.h Prod.h
ProdSelect.o: Misc.h Symb.h Graph.h Main.h Popup.h Prod.h
ProdSymbol.o: Misc.h Graph.h Symb.h Prod.h
ProdUtil.o: Misc.h Prod.h
Reftab.o: Misc.h Prod.h Symb.h Visit.h Main.h
Resources.o: Misc.h Main.h
SymbAttrs.o: Misc.h Prod.h Symb.h
SymbCreate.o: Misc.h Create.h Main.h Graph.h Symb.h
SymbDep.o: Misc.h Prod.h Symb.h
SymbDraw.o: Misc.h Graph.h Symb.h
SymbMenu.o: Misc.h Create.h Visit.h Graph.h Popup.h Symb.h
SymbProd.o: Misc.h Create.h Prod.h Main.h Graph.h Popup.h Symb.h
SymbSelect.o: Misc.h Prod.h Main.h Graph.h Popup.h Symb.h
SymbUtil.o: Misc.h Symb.h
Util.o: Misc.h Main.h
VisitCreate.o: Misc.h Create.h Graph.h Main.h Visit.h
VisitDraw.o: Misc.h Graph.h Visit.h
VisitLife.o: Misc.h Visit.h
VisitMenu.o: Misc.h Create.h Prod.h Main.h Graph.h Visit.h
VisitSelect.o: Misc.h Graph.h Prod.h Main.h Popup.h Visit.h
VisitUtil.o: Misc.h Prod.h Visit.h




