/* $Id: Debug.c,v 1.3 1991/12/18 16:02:28 cogito Exp $ */
static char rcs_id[]= "$Id: Debug.c,v 1.3 1991/12/18 16:02:28 cogito Exp $";

/*======================================================================*
 *									*
 *	FILE:		Misc/Debug.c					*
 *									*
 *	CONTENTS:	Functions useful for debugging.			*
 *									*
 *	AUTHOR:		Volker Niepel					*
 *									*
 *======================================================================*/

/* The functions contained in this file are not called from any other file,
 * they are only intended for interactive source-level debugging.
 */

#include "Misc.h"
#include "Visit.h"
#include <string.h>
#include <stdio.h>


/************************************************************************
 *				DepString				*
 ************************************************************************/

/* Yields a human readable representation of a dependency.
 */

PUBLIC String DepString (dep)
	DEPENDENCY *dep;
{
	static char ret[80];

	if (dep == (DEPENDENCY *) NULL) return ("<NULL>");

	strcpy (ret, "<");
	if (*dep & T_DIR)	strcat (ret, "D");
	if (*dep & T_TRAN)	strcat (ret, "T");
	if (*dep & T_IND)	strcat (ret, "I");
	if (*dep & T_ARR)	strcat (ret, "A");
	if (*dep & T_PART)	strcat (ret, "P");
	if (*dep & T_MARK)	strcat (ret, "M");
	if (*dep & T_FOLLOWED)	strcat (ret, "F");
	strcat (ret, ">");

	return (ret);
}


/************************************************************************
 *			      PrintBITVECTOR				*
 ************************************************************************/

/* Prints the contents of the given set <deps>.
 */

PUBLIC void PrintBITVECTOR (prod, deps)
	PRODENTRY	*prod;
	BITVECTOR	deps;
{
	SLNODE	*nd;
	SYMBENTRY	*symb;
	ATTRENTRY	*ae;

	for (nd = prod->hdright; nd != NULL; nd = nd->right)
	{
		symb = & SE (nd->sid);

		for (ae = symb->first_attr; ae != NULL; ae = ae->next)
		{
			if (deps[nd->start_col + ae->pos/WORD_LENGTH]
			       & 1 << ae->pos%WORD_LENGTH)
			{
				if (nd->ord)
					printf ("%s[%d].%s\n",
					  symb->symb_def->dname, nd->ord,
					  ae->attr_def->name);
				else
					printf ("%s.$s\n",
					  symb->symb_def->dname,
					  ae->attr_def->name);
			}
		}
	}
}


/************************************************************************
 *			    WriteProdLifetimes				*
 ************************************************************************/

/* Writes the computed lifetimes of all attribute instances of the given
 * production <prod> to the file LifeProt.
 */

#define VERBOSE(elem)	((elem) ? VisitElemString(elem) : "_")

PRIVATE FILE *LifeProt;

PUBLIC void WriteProdLifetimes (prod)
	PRODENTRY *prod;
{
	SLNODE		*nd;
	SEQAttrdef	sad;
	Attrdef		ad;
	int		index;

	fprintf (LifeProt, "*****************************************\n");
	fprintf (LifeProt, "Lifetimes for rule %s (%d)\n",
			   prod->prod_def->dname, prod->prod_def->did);

	for (nd = prod->hdright; nd != NULL; nd = nd->right)
	{
		fprintf (LifeProt, "\n\n======== Symbol %s\n\n",
			SE(nd->sid).symb_def->dname);
		index = nd->start_row;
		foreachinSEQAttrdef (SE(nd->sid).symb_def->attrs, sad, ad)
		{
			fprintf (LifeProt, "%-11s: -> %-24s/ ", ad->name,
			  VERBOSE (prod->vs->lifetimes[index].last_local));
			fprintf (LifeProt, "%s (%d)\n", 
			  VERBOSE (prod->vs->lifetimes[index].last_global),
			  AE(ad->did).life_vsno);
			index ++;
		}
	}

	fprintf (LifeProt, "\n\n\n");
}


/************************************************************************
 *			      WriteLifetimes				*
 ************************************************************************/

/* Writes all computed lifetimes to a file.
 */

PUBLIC WriteLifetimes()
{
	int i;

	LifeProt = fopen ("lifetimes", "w");
	for (i = min_entry; i <= max_entry; i++)
		if (ref_tab[i].etag == PROD) WriteProdLifetimes (& PE(i));
	fclose (LifeProt);
}
