#ifndef DEFTBL_H
#define DEFTBL_H 

/* $Id: deftbl.h,v 1.2 1992/04/12 02:10:04 waite Exp $ */
/* Property list module interface */
/* Copyright 1989, The Regents of the University of Colorado
 * Permission is granted to use any portion of this file for any purpose,
 * commercial or otherwise, provided that this notice remains unchanged.
 */

typedef struct PropElt {	/* Properties of a defined entity */
   struct PropElt *next;	   /* The next property */
   int selector;		   /* Which property */
} *Entry;

typedef struct {		/* Representation of a definition table key */
   Entry PropList;		   /* Property list pointer */
} *DefTableKey;

#define NoKey (DefTableKey)0	/* Distinguished defninition table key */

extern DefTableKey NewKey();
/* Establish a new definition
 *    On exit-
 *       NewKey=Unique definition table key
 ***/

extern int find(/* DefTableKey key; int p; Entry *r; unsigned add; */);
/* Obtain a relation for a specific property of a definition
 * On entry-
 *    key=definition whose property relation is to be obtained
 *    p=selector for the desired property
 * If the definition does not have the desired property then on exit-
 *    find=false
 *    if add != 0 then r points to a new entry of size add for the property
 *    else r points to the entry following the entry for the property
 * Else on exit-
 *    find=true
 *    r points to the current entry for the property
 ***/

#endif
