/* $Id: IntfAttrib.c,v 3.1 1992/03/04 16:19:43 uwe Exp $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn */

#include "Lido.head"

int CompAttrdef (ad1, ad2)
	Attrdef		ad1, ad2;
{
return (strcmp (nameOfAttrdef (ad1), nameOfAttrdef (ad2)) >= 0);
}/*CompAttrdef*/

SEQAttrdef MakeAttrDefs (env, isterm)
	Environment	env;
	int		isterm;

{	Scope		scdefs;
	SEQAttrdef	res;
	Attrdef		d;
	DefTableKey	k;
	POSITION	*coordref, NoPosition;
	int		prodid, id;

NoPosition.line = 0;
NoPosition.col = 0;

res = nullSEQAttrdef ();

scdefs = DefinitionsOf (env);
while (scdefs != NoScope) {
	k = KeyOf (scdefs);	
	coordref = GetCoord (k, &NoPosition);

if (((int)coordref)<10) {
	message (WARNING, "internal error in MakeAttrDefs", 1, &NoPosition);
	coordref = &NoPosition;
}
	id = IdnOf (scdefs);
	prodid = GetAttrProdDid (k, DIDNON);
	d = MkAttrdef (
		GetDid (k, DIDNON),
		GetStringRef (id),
		coordref->line, coordref->col,
		GetAttrType (k, DIDVOID),
		GetAttrClass (k, ATCLUNKN),
		prodid, 
		STORUNKN, GENORIG, 0, NoString);
	if (isterm)
		orderedinsertSEQAttrdef (res, d, CompAttrdef);
	else	res = AppFrontSEQAttrdef (d, res);
	scdefs = NextDefinition (scdefs);
}
return (res);
}/*MakeAttrDefs*/

SEQEntity MakeProdRhs (symblist)
	TList	symblist;
{	ProdElem	symb;
	Entity		ent;
	POSITION	NoPosition;

NoPosition.line = 0;
NoPosition.col = 0;

if (symblist == NullList) return (nullSEQEntity ());

symb = (ProdElem)HeadList (symblist);
if (((int)(symb->Coord))<10) {
        message (WARNING, "internal error in MakeProdRhs", 2, &NoPosition);
        symb->Coord = &NoPosition;
}
if (symb->IsSymbol)
	ent = UnitToEntity (MkUnit (
		symb->Coord->line, symb->Coord->col,
		SymbolToUnit (MkSymbol (symb->Id))));
else	ent = UnitToEntity (MkUnit (
		symb->Coord->line, symb->Coord->col,		
		LiteralToUnit(MkLiteral (
			((symb->Id == SyntGenMark) ? NoString 
					: GetStringRef (symb->Id))))));

return (AppFrontSEQEntity (ent, MakeProdRhs (TailList (symblist))));
}/*MakeProdRhs*/


Prod MakeProd (symblist)
	TList	symblist;
{	ProdElem	symb;
	int		lhsdid;
	SEQEntity	rhs;

symb = (ProdElem)HeadList (symblist);
lhsdid = symb->Id;
rhs = MakeProdRhs (TailList (symblist));
return (MkProd (lhsdid, rhs));
}/*MakeProd*/


SEQDef MakeAllDefs (env, chainenv)
	Environment	env, chainenv;
{	Scope		scdefs;
	SEQDef		res;
	Def		d;
	DefTableKey	k;
	POSITION	*coordref, NoPosition;
	int		did, id;

NoPosition.line = 0;
NoPosition.col = 0;
res = nullSEQDef ();
scdefs = DefinitionsOf (chainenv);
while (scdefs != NoScope) {
	k = KeyOf (scdefs);
	if (ChainAttr == GetAttrKind (k, AttrName)) {
		did = GetDid (k, DIDNON);
		coordref = GetCoord (k, &NoPosition);
		d = MkDef (did, GetStringRef (IdnOf (scdefs)),
				coordref->line, coordref->col,
				ChainToDef (MkChain (
					GetAttrType (k, DIDVOID))));
		res = AppFrontSEQDef (d, res);
	}
	scdefs = NextDefinition (scdefs);
}

scdefs = DefinitionsOf (env);
while (scdefs != NoScope) {
	k = KeyOf (scdefs);
	if (RuleDef == GetDefKind (k, TypeDef)) {
		did = GetDid (k, DIDNON);
		coordref = GetCoord (k, &NoPosition);
		id = MarkName (NoKey != GetChainSymb (k, NoKey),
				IdnOf (scdefs));

		d = MkDef (did, GetStringRef (id),
				coordref->line, coordref->col,
				ProdToDef (MakeProd (
					GetRuleProd (k, NullList))));
		res = AppFrontSEQDef (d, res);
	}
	scdefs = NextDefinition (scdefs);
}

scdefs = DefinitionsOf (env);
while (scdefs != NoScope) {
	k = KeyOf (scdefs);
	if (SymDef == GetDefKind (k, TypeDef)) 
	if (GetRealSym (k, false)) {	int	symclass;
		symclass = GetSymClass (k, SYMBTERM);
		id = IdnOf (scdefs);
		did = GetDid (k, DIDNON);
		coordref = GetCoord (k, &NoPosition);
		d = MkDef (did, GetStringRef (id),
				coordref->line, coordref->col,
				SymbToDef (MkSymb (
					symclass,
					MakeAttrDefs (
						GetAttrScope (k, NoEnv),
						symclass == SYMBTERM))));
		res = AppFrontSEQDef (d, res);
	}
	scdefs = NextDefinition (scdefs);
}

scdefs = DefinitionsOf (env);
while (scdefs != NoScope) {
	k = KeyOf (scdefs);
	if (TypeDef == GetDefKind (k, SymDef)) {
		did = GetDid (k, DIDNON);
		if (did > DIDNODE) {
			coordref = GetCoord (k, &NoPosition);
			d = MkDef (did, GetStringRef (IdnOf (scdefs)),
				coordref->line, coordref->col,
				TypedefToDef (MkTypedef (
					NoString, DIDNON)));
			res = AppFrontSEQDef (d, res);
		}
	}
	scdefs = NextDefinition (scdefs);
}

d = MkDef(DIDNODE, TNNODE, 1, 1,
        TypedefToDef (MkTypedef ("", 0)));
res = AppFrontSEQDef (d, res);
d = MkDef(DIDBIG, TNBIG, 1, 1,
	TypedefToDef (MkTypedef ("", 0)));
res = AppFrontSEQDef (d, res);
d = MkDef(DIDSYMB, TNSYMB, 1, 1,
	TypedefToDef (MkTypedef ("", 0)));
res = AppFrontSEQDef (d, res);
d = MkDef(DIDBOOL, TNBOOL, 1, 1,
	TypedefToDef (MkTypedef ("", 0)));
res = AppFrontSEQDef (d, res);
d = MkDef(DIDINT, TNINT, 1, 1,
	TypedefToDef (MkTypedef ("", 0)));
res = AppFrontSEQDef (d, res);
d = MkDef(DIDVOLI, TNVOLI, 1, 1,
	TypedefToDef (MkTypedef ("", 0)));
res = AppFrontSEQDef (d, res);
d = MkDef(DIDVOID, TNVOID, 1, 1,
	TypedefToDef (MkTypedef ("", DIDVOLI)));
res = AppFrontSEQDef (d, res);
return (res);
}/*MakeAllDefs*/


void UpdateAttrib (rskey, cmp, islow)
	DefTableKey		rskey;
	Attrrule	cmp;
	int		islow;
{	SEQAttrrule	seq;

if (RuleDef == GetDefKind (rskey, RuleDef)) {
	seq = GetAttrib (rskey, nullSEQAttrrule());
	seq = AppFrontSEQAttrrule (cmp, seq);
	SetAttrib (rskey, seq, seq);
} else if (islow) {
	seq = GetLowAttrib (rskey, nullSEQAttrrule());
	seq = AppFrontSEQAttrrule (cmp, seq);
	SetLowAttrib (rskey, seq, seq);
} else {
	seq = GetUpAttrib (rskey, nullSEQAttrrule());
	seq = AppFrontSEQAttrrule (cmp, seq);
	SetUpAttrib (rskey, seq, seq);
}
}/*UpdateAttrib*/


SEQAttribution MakeAttributions (env)
	Environment	env;
{	Scope		scdefs;
	DefTableKey	rkey;
	SEQAttribution	seq;
	Attribution	at;
	int	did;
seq = nullSEQAttribution ();
scdefs = DefinitionsOf (env);
while (scdefs != NoScope) {
	rkey = KeyOf (scdefs);
	if (RuleDef == GetDefKind (rkey, TypeDef)) {
		did = GetDid (rkey, DIDNON);
		at = MkAttribution (did,
			GetAttrib (rkey, nullSEQAttrrule ()));
		seq = AppFrontSEQAttribution (at, seq);
	}
	scdefs = NextDefinition (scdefs);
}
return (seq);
}/*MakeAttributions*/


void MakeProdAttrAssigns (symkey, prodkey, line, col)
	DefTableKey	symkey, prodkey;
	int	line, col;
/* Precondition:
   The rule attributes are defined and
   associated to the lefthand side symbol key.
   Postcondition:
   A dummy Attrrule is added to the attribution of rule (prodkey)
   for each rule attribute of lhs (symkey)
   which does not belong to this rule,
   i.e. marked by prodid of this rule
*/
{	Environment	env;
	Scope		attrs;
	DefTableKey	atkey;
	int		prodid, attrprod, did;
	Attrrule	ar;
	Expr		ex1, ex2, ex3;
	SEQAttrrule	sar;

if (GetDummyRules (prodkey, false)) return; /* is done before */
SetDummyRules (prodkey, true, true);

prodid = GetDid (prodkey, DIDNON);

env = GetAttrScope (symkey, NoEnv);
attrs = DefinitionsOf (env);

while (attrs != NoScope) {
	atkey = KeyOf (attrs);
	attrprod = GetAttrProdDid (atkey, DIDNON);
	if ((attrprod != DIDNON) &&
		(attrprod != prodid)) {
		did = GetDid (atkey, DIDNON);
		ex1 = AttraccToExpr (
			MkAttracc (0, did, line, col));
		ex2 = ValToExpr (MkVal (0,line, col));
		ex3 = NameToExpr (MkName (TNVOID, line, col));
		ar = CallToAttrrule (MkCall (
			ASSIGNFCT,
			AppFrontSEQExpr (ex1,
				AppFrontSEQExpr (ex2,
					creatSEQExpr (ex3))),
			line, col));
		sar = AppFrontSEQAttrrule (ar,
				GetAttrib (
				prodkey, nullSEQAttrrule ()));
		SetAttrib (prodkey, sar, sar);
	}
	attrs = NextDefinition (attrs);
}
}/* MakeProdAttrAssigns */

void MakeGenTreeDummy (symkey, prodkey, syntpos, line, col)
	DefTableKey	symkey, prodkey;
	int		syntpos, line, col;
{	int		did;
	Expr		ex1, ex2, ex3;

did = GetDid (KeyInScope (GetAttrScope (symkey, NoEnv), GenAttrId),
		DIDNON);
ex1 = AttraccToExpr (MkAttracc (syntpos, did, line, col));
ex2 = ValToExpr (MkVal (0, line, col));
ex3 = NameToExpr (MkName (TNVOID, line, col));

UpdateAttrib (prodkey,
	CallToAttrrule (MkCall (
		ASSIGNFCT,
		AppFrontSEQExpr (ex1,
			AppFrontSEQExpr (ex2,
				creatSEQExpr (ex3))),
		line, col)),
	false);
}/*MakeGenTreeDummy*/


int WriteResults (ds, attr)
   SEQDef ds;
   SEQAttribution attr;
{
        FILE *f;
        AttrEval l;

#       ifdef DEBUG
           fprintf (stderr, "WriteResults\n");
#       endif
        l = NAttrEval;
        l->defseq = ds;
        l->attrrules = attr;
        f = fopen("liga.out", "w");
        ligaout(f, l);
        fclose(f);

        return (true);
} /* WriteResults */
