/* $Id: AttrDefs.c,v 3.1 1992/03/04 16:19:43 uwe Exp $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn */

#include "Lido.head"

POSITION nullpos;

int GenAttrId;

static void InitAttr (k, kd, tp, cl, prod, pos)
	DefTableKey	k;
	int		kd, tp, cl, prod;
	POSITION	*pos;
{	int	did;

did = GenDid ();
SetDid (k, did, did);
SetCoord (k, pos, pos);
SetAttrKind (k, kd, kd);
SetAttrProdDid (k, prod, prod);
if (tp != DIDNON) SetAttrType (k, tp, tp);
SetAttrClass (k, cl, cl);
}/* InitAttr */

static void UpdateClass (k, cl, pos)
	DefTableKey		k;
	int		cl;
	POSITION *	pos;
{	int		oldcl;
if (cl != ATCLUNKN) {
	oldcl = GetAttrClass (k, ATCLUNKN);
	if (oldcl == ATCLUNKN)
		SetAttrClass (k, cl, cl);
	else if (oldcl != cl)
		message (FATAL, "attribute class in conflict", 0, pos);
}}/* UpdateClass */

static void UpdateType (k, tp, pos)
	DefTableKey		k;
	int		tp;
	POSITION *	pos;
{	int		oldtp;
if (tp != DIDNON) {
	oldtp = GetAttrType (k, DIDNON);
	if (oldtp == DIDNON)
		SetAttrType (k, tp, tp);
	else if (oldtp != tp)
		message (ERROR,
			"different attribute types specified", 0, pos);
}}/* UpdateType */

DefTableKey DeclareAttrName (scope, id, kd, tp, cl, pos)
	Environment	scope;
	int		id, kd, tp, cl;
	POSITION *	pos;
/*
On Exit:
	scope has an entry for the attribute name or chain name id.
	The kind (Attr, Chain), type, and class are set if they do
	not conflict with an already existing entry.
*/
{	DefTableKey		k;
	

if (scope == NoEnv)
	message (DEADLY, "internal error: AttrDefs ", 8, pos);
k = DefineIdn (scope, id);

if (DIDNON == GetDid (k, DIDNON))
	InitAttr (k, kd, tp, cl, DIDNON, pos);
else
if (kd == GetAttrKind (k, kd)) {
	UpdateClass (k, cl, pos);
	UpdateType (k, tp, pos);
}
else
	SetAttrKind (k, MultiAttr, MultiAttr);

return (k);
}/* DeclareAttrName */

Environment AttrPreDefs ()
{	Environment	e;
	int		idtoken = 4; /* token class is not relevant here */

e = NewEnv ();

nullpos.line = 0;
nullpos.col = 0;

mkidn(GENTREEATTR, strlen (GENTREEATTR), &idtoken, &GenAttrId);
(void) DeclareAttrName (e, GenAttrId, AttrName, DIDNODE, ATCLINH, &nullpos);
return (e);
}/*AttrPreDefs*/


DefTableKey DeclareExplAttr (scope, id, tp, cl, pos)
	Environment	scope;
	int		id, tp, cl;
	POSITION *	pos;
/*
On Exit:
	scope has an entry for the attribute id, the key is returned,
	class and type are set if they do not
	not conflict with an already existing entry.
	no chain check here!
*/
{	DefTableKey		k;

k = DefineIdn (scope, id);

if (DIDNON == GetDid (k, DIDNON))
	InitAttr (k, SymbAttr, tp, cl, DIDNON, pos);	
else {
	UpdateClass (k, cl, pos);
	UpdateType (k, tp, pos);
} 
return (k);
}/* DeclareExplAttr */


void MultDeclareExplAttr (symkeys, attrid, typeid, class, pos)
	TList	symkeys;
	int	attrid, typeid, class;
	POSITION *	pos;
/*
	DeclareExplAttr applied to each of the symkeys.
*/
{	DefTableKey		ak;
	Environment	scope;
	int		kind;

if (symkeys == NullList) 
	message (DEADLY, "internal error: AttrDefs ", 1, pos);
scope = GetAttrScope ((DefTableKey)HeadList (symkeys), NoEnv);
if (scope == NoEnv)
	message (DEADLY, "internal error: AttrDefs ", 2, pos);

ak = KeyInEnv (scope, attrid);
kind = GetAttrKind (ak, SymbAttr);

if (kind == ChainAttr) {
	message (ERROR, "attribute name clashes with CHAIN name", 0, pos);
	return;
}

while (symkeys != NullList) {
	scope = GetAttrScope ((DefTableKey)HeadList (symkeys), NoEnv);
	if (scope == NoEnv)
		message (DEADLY, "internal error: AttrDefs ", 3, pos);
	DeclareExplAttr (scope, attrid, typeid, class, pos);
	symkeys = TailList (symkeys);
}
}/* MultDeclareExplAttr */


DefTableKey DeclareImplAttr (symkey, id, cl, pos)
	DefTableKey	symkey;
        int             id, cl;
        POSITION *      pos;
/*
On Exit:
	the key of an attr id for symkey is returned,
	the class is set if it does
	not conflict with an already existing entry.
	no chain check here!
*/
{	DefTableKey	k;
	int		kind;
	int		globtp, globcl;
        Environment	scope;


if ((symkey == HEADKey) || (symkey == TAILKey)) {
	message (ERROR, "must be a chain attribute", 0, pos);
	return (NoKey);
}
if ((symkey == SYNTKey) || (symkey == INHKey) || (symkey == THISKey)) {
/*	message (ERROR, "not allowed in rule attribution", 0, pos); */
	return (NoKey);
}

scope = GetAttrScope (symkey, NoEnv);
k = KeyInEnv (scope, id);	

if (k == NoKey) {
	k = DefineIdn (scope, id);
	InitAttr (k, SymbAttr, DIDVOID, cl, DIDNON, pos);
} else {
	kind = GetAttrKind (k, SymbAttr);
	switch (kind) {
	case AttrName:
		globcl = GetAttrClass (k, ATCLUNKN);
		globtp = GetAttrType (k, DIDVOID);
		k = DefineIdn (scope, id);
		InitAttr (k, SymbAttr, globtp, globcl, DIDNON, pos);
		UpdateClass (k, cl, pos);
		break;
	case SymbAttr:
		UpdateClass (k, cl, pos);
		break;
	default:;
	}
}
return (k);
}/* DeclareImplAttr */

void MultDeclareImplAttr (symkeys, attrid, pos)
	TList		symkeys;
	int		attrid;
	POSITION *	pos;
{	DefTableKey	symkey;

if (symkeys == NullList) 
	message (DEADLY, "internal error: AttrDefs ", 5, pos);

while (symkeys != NullList) {
	symkey = (DefTableKey)HeadList (symkeys);

	if ((symkey == SYNTKey) || (symkey == INHKey) ||
		(symkey == THISKey) || (symkey == HEADKey) || 
		(symkey == TAILKey))
		message (ERROR, "THIS, SYNT, INH, HEAD, TAIL not allowed here",
			0, pos);
	else	(void) DeclareImplAttr (
			symkey, attrid, ATCLUNKN, pos);

	symkeys = TailList (symkeys);
}
}/* MultDeclareImplAttr */

 
DefTableKey DeclareLocAttr (symkey, id, prodid, namescope, pos)
	DefTableKey		symkey;
	int		id, prodid;
	Environment	namescope;
	POSITION	*pos;
{	DefTableKey		k, namekey;
	int		newid, globtp;
	Environment	scope;

namekey = KeyInEnv (namescope, id);
if (namekey == NoKey)
	globtp = DIDVOID;
else	globtp = GetAttrType (namekey, DIDNON);

scope = GetAttrScope (symkey, NoEnv);
if (scope == NoEnv)
	message (DEADLY, "internal error: AttrDefs ", 6, pos);

newid = NumToIdn (id, prodid);

k = KeyInScope (scope, newid);

if (k == NoKey) {
	k = DefineIdn (scope, newid);
	InitAttr (k, LocAttr, globtp, ATCLSYNT, prodid, pos);
} else if (LocAttr != GetAttrKind (k, LocAttr))
		message (ERROR, "different attribute kinds", 0, pos);
return (k);
}/*DeclareLocAttr*/

