/* $Id: expref.h,v 2.3 1992/07/14 15:20:29 uwe Exp $ */

/***********************************************************************\
*									*
*		Implementation of LIGA expand pass			*
*									*
*	Module:		expref.c					*
*	File:		expref.h					*
*	Contents:	function to handle the reference table		*
*	Author:		Hans Detlef Siewert				*
*	Creation date:	13 Dec 1990					*
*	Last change:	16 Apr 1991					*
*									*
\***********************************************************************/

#ifndef	_EXPREF_H_INCL
#define	_EXPREF_H_INCL

/*
** MACROS
*/

/* shorthands for reference table access */
#define symbref(did)		(ref_tab[did].entry.symb.symb_def)
#define	symbldown(did)		(ref_tab[did].entry.symb.ldown)
#define	symbrdown(did)		(ref_tab[did].entry.symb.rdown)
#define	symbflag(did)		(ref_tab[did].entry.symb.flag)
#define	symbvisited(did)	(ref_tab[did].entry.symb.visited)
#define prodref(did)		(ref_tab[did].entry.prod.prod_def)
#define prodattrib(did)		(ref_tab[did].entry.prod.attrib)
#define	prodright(did)		(ref_tab[did].entry.prod.right)
#define	prodtrns(did)		(ref_tab[did].entry.prod.trns)
#define	prodflag(did)		(ref_tab[did].entry.prod.flag)
#define	prodvisited(did)	(ref_tab[did].entry.prod.visited)

/* generate new did for new definitions */
#define	newdid()	(++max_did)

/*
** GLOBAL VARIABLES
*/

extern	struct RefEntry ref_tab[MAX_REF_ENTRIES];
extern	int	max_entry;
extern	int	min_entry;
extern	int	max_did;
extern	int	root_sid;

extern	int	DefSymbNum, DefRuleNum;

/*
** GLOBAL FUNCTIONS
*/

#ifdef __STDC__
extern	void	init_reftab (void);
extern	void	find_root (void);
extern	void	clear_psflags (void);
#else
extern	void	init_reftab();
extern	void	find_root();
extern	void	clear_psflags();
#endif

#endif

/***********************\
* end of expref.h	*
\***********************/

								/* HaDeS */

