/* $Id: expconst.h,v 2.4 1992/07/14 15:20:29 uwe Exp $ */

/***********************************************************************\
*									*
*		Implementation of LIGA expand pass			*
*									*
*	Module:		expconst.h					*
*	File:		expconst.h					*
*	Contents:	global constants for all modules of expand	*
*	Author:		Hans Detlef Siewert				*
*	Creation date:	08 Jan 1991					*
*	Last change:	03 Jul 1991					*
*									*
\***********************************************************************/

#ifndef _EXPCONST_H_INCL
#define _EXPCONST_H_INCL

/*
** CONSTANTS
*/

/* maximal number of entries in the reference table */
#define	MAX_REF_ENTRIES	(10000)

/* error ids - these are given in error messages to identify error class */
#define	NO_ERRID	(0)
	/* no specific error, internal or otherwise */
#define	ROOT_ERRID	(1)
	/* error while searching for the root symbol of the grammar */
#define	ATCL_ERRID	(2)
	/* error in attribute classification */
#define	ASGN_ERRID	(3)
	/* error in assignment */
#define	TFCL_ERRID	(4)
	/* error in TRANSFER classes */
#define	TFEX_ERRID	(5)
	/* conflict between explicit assignment and TRANSFER rule */
#define	TFMS_ERRID	(6)
	/* multiple attributes for TRANSFER of synthesized attributes */
#define TF_ERRID	(7)
	/* error in transfer rule */
#define	INRT_ERRID	(8)
	/* INCLUDING construct found in root production */
#define	NAII_ERRID	(9)
	/* no attributes in INCLUDING construct */
#define	TSIN_ERRID	(10)
	/* terminal attribute in INCLUDING construct */
#define	IMSO_ERRID	(11)
	/* symbol occured more than once in list of INCLUDING attributes */
#define	ITYP_ERRID	(12)
	/* type conflict in list of INCLUDING attributes */
#define	OPIN_ERRID	(13)
	/* open INCLUDING construct, root marked as transfer symbol */
#define	NISC_ERRID	(14)
	/* no source context for attribute to be included */
#define	CHST_ERRID	(15)
	/* error in CHAINSTART */
#define	CHACC_ERRID	(16)
	/* no accesses to CHAIN */
#define	CHDEF_ERRID	(17)
	/* no definitions of CHAIN */
#define	CHTS_ERRID	(18)
	/* chain leads through or starts at a terminal symbol */
#define	OPCH_ERRID	(19)
	/* open CHAIN, root marked as chain symbol */
#define	CONR_ERRID	(20)
	/* no CONSTITUENT symbol found in subtree */
#define	COML_ERRID	(21)
	/* multiple CONSTITUENT symbols found in subtree */
#define	NAIC_ERRID	(22)
	/* no attributes in CONSTITUENT(S) construct */
#define	CMSO_ERRID	(23)
	/* symbol occured more than once in list of CONSTITUENT attributes */
#define	CTYP_ERRID	(24)
	/* type conflict in list of CONSTITUENT(S) attributes */

/* warning ids - these are given in warning to identify warning class */
#define	CHUSE_WARNID	(101)
	/* no use is made of a defined chain */
#define	CHNU_WARNID	(102)
	/* no use access was found for a chain */
#define	CONS_WARNID	(103)
	/* no CONSTITUENTS symbols found in subtree, list is always empty */

/* flags for productions */
#define	no_pflag	(0)
#define	start_prod	(1)
#define	trans_prod	(2)
#define	target_prod	(4)

/* flags for symbols */
#define	no_sflag	(0)
#define	chainstart_symb	(1)
#define	chain_symb	(2)
#define	trnsp_symb	(4)
#define src_symb	(1)
#define shield_symb	(2)

#endif

/***********************\
* end of expconst.h	*
\***********************/

								/* HaDeS */

