/* $Id: expr.c,v 3.1 1992/03/05 17:34:31 uwe Exp $ */

/* LIGA backend module		*/
/* expression translation	*/
/* U. Kastens, 5. 11. 91	*/

#include "err.h"
#include "global.h"
/*
#include "LIGA.h"
#include "LIGAMacros.h"
*/
#include "ligaconsts.h"
#include "lookup_idl.h"
#include "backptg_gen.h"

#include "expr.h"
#include "attr.h"
#include "attrdecl.h"
#include "incl.h"
#include "bool.h"

POSITION coord;

#define MANY 100

bool CheckArgNr (c, l, u)
	Call	c;
	int	l, u;
{	int	i = 0;
	SEQExpr params, es;
	Expr	e;

foreachinSEQExpr (paramsOfCall (c), es, e) i++;

if (i < l) {
	coord.line = rowOfCall (c);
	coord.col = colOfCall (c);
	message (DEADLY, "argument(s) missing", 0, &coord);
	return (true);
} else if (i > u) {
	coord.line = rowOfCall (c);
	coord.col = colOfCall (c);
	message (FATAL, "too many arguments", 0, &coord);
	return (true);
}
return (false);
}/*CheckArgNr*/


PTGNode TrCall (c, context)
	Call	c;
	int	context;
{	SEQExpr params;
	Expr	e1, e2, e3;

params = paramsOfCall (c);
if (strcmp (ASSIGNFCT, nameOfCall (c)) == 0) {
	if (CheckArgNr (c, 2, MANY)) return (PTGEmpty ());
	retrievefirstSEQExpr(params, e1);
	retrievefirstSEQExpr(tailSEQExpr (params), e2);
	if (!emptySEQExpr(tailSEQExpr (tailSEQExpr (params)))) {
		retrievefirstSEQExpr(tailSEQExpr (tailSEQExpr (params)), e3);
		if ((typeof (e3) == KName) &&
			(strcmp (nOfName (ExprToName (e3)), "VOID") == 0))
			return (PTGEmpty ());
	}
	if ((typeof (e1) == KAttracc) &&
	    (IsVoidAttr (lookup_attrdef (
			attridOfAttracc (ExprToAttracc (e1))))))
		return (TrExpr (e2, isstmt));
	else	return (PTGAssign (TrExpr (e1, isval), TrExpr (e2, isval)));
} else
if (strcmp (PUSHFCT, nameOfCall (c)) == 0) {
	if (CheckArgNr (c, 3, MANY)) return (PTGEmpty ()); /* last added attr acc */
	retrievelastSEQExpr(params, e1);

	if ((typeof (e1) == KName) &&
			(strcmp (nOfName (ExprToName (e1)), "VOID") == 0))
		return (PTGEmpty ());

	retrievefirstSEQExpr(tailSEQExpr (params), e2);
	if ((typeof (e1) == KAttracc) &&
		(IsVoidAttr (lookup_attrdef (
			attridOfAttracc (ExprToAttracc (e1))))))
		return (TrExpr (e2, isstmt));
	else	return (PTGAssign (TrExpr (e1, isval), TrExpr (e2, isval)));
} else
if (strcmp (CLOBFCT, nameOfCall (c)) == 0) {
	if (CheckArgNr (c, 4, MANY)) return (PTGEmpty ()); /* last added attr acc */
	retrievelastSEQExpr(params, e1);

	if ((typeof (e1) == KName) &&
			(strcmp (nOfName (ExprToName (e1)), "VOID") == 0))
		return (PTGEmpty ());

	retrievefirstSEQExpr(tailSEQExpr (tailSEQExpr (params)), e2);
	if ((typeof (e1) == KAttracc) &&
		(IsVoidAttr (lookup_attrdef (
			attridOfAttracc (ExprToAttracc (e1))))))
		return (TrExpr (e2, isstmt));
	else	return (PTGAssign (TrExpr (e1, isval), TrExpr (e2, isval)));
} else
if (strcmp (POPFCT, nameOfCall (c)) == 0) {
	return (PTGEmpty ());
} else
if (strcmp (SWAPFCT, nameOfCall (c)) == 0) {
	return (PTGEmpty ());
} else
if (strcmp (TOPFCT, nameOfCall (c)) == 0) {
	if (CheckArgNr (c, 3, 3)) return (PTGEmpty ()); /* last added attr acc */
	retrievelastSEQExpr(params, e1);
	if (context == isstmt)
		return (PTGEmpty ());
	else	return (TrExpr (e1, isval));
} else
if (strcmp (DEPFCT, nameOfCall (c)) == 0) {
	if (CheckArgNr (c, 1, MANY)) return (PTGEmpty ());
	retrievefirstSEQExpr(params, e1);
	return (TrExpr (e1, context));
} else
if (strcmp (ORDERFCT, nameOfCall (c)) == 0) {
	if (context == isstmt) {
		if (CheckArgNr (c, 0, MANY)) return (PTGEmpty ());
		return (TrSeqStmt (params));
	} else {
		if (CheckArgNr (c, 1, MANY)) return (PTGEmpty ());
		return (PTGParen (TrSeqExpr (params)));
	}
} else
if (strcmp (VOIDFCT, nameOfCall (c)) == 0) {
/* VOIDFCT indicates dummy dependency argument */
	CheckArgNr (c, 1, 1);
	if (context == isval) {
		coord.line = rowOfCall (c);
		coord.col = colOfCall (c);
		message (FATAL,
		"internal error: VOID in value context", 0, &coord);
	}
	return (PTGEmpty ());
} else
if (strcmp (IDFCT, nameOfCall (c)) == 0) {
/* IDFCT inserted by frontend for expressions on outmost level */
	CheckArgNr (c, 1, 1);
	retrievefirstSEQExpr(params, e1);
	return (TrExpr (e1, context));
} else
if (strcmp (IFFCT, nameOfCall (c)) == 0) {
	if (context == isstmt) {
		if (CheckArgNr (c, 2, 3)) return (PTGEmpty ());
		retrievefirstSEQExpr(params, e1);
		retrievefirstSEQExpr(tailSEQExpr (params), e2);
		if (emptySEQExpr (tailSEQExpr (tailSEQExpr (params))))
			return (PTGIfStmt (
					TrExpr (e1, isval),
					PTGStmt (TrExpr (e2, isstmt)),
					PTGEmpty ()));
		else {
			retrievefirstSEQExpr(
				tailSEQExpr (tailSEQExpr (params)), e3);
			return (PTGIfStmt (
					TrExpr (e1, isval),
					PTGStmt (TrExpr (e2, isstmt)),
					PTGStmt (TrExpr (e3, isstmt))));
		}
	} else	{
		if (CheckArgNr (c, 3, 3)) return (PTGEmpty ());
		retrievefirstSEQExpr(params, e1);
		retrievefirstSEQExpr(tailSEQExpr (params), e2);
		retrievefirstSEQExpr (tailSEQExpr (tailSEQExpr (params)), e3);
		return (PTGIfExpr (
				TrExpr (e1, isval),
				TrExpr (e2, isval),
				TrExpr (e3, isval)));
	}
} else {
	return (PTGCall (
		PTGAsIs (nameOfCall (c)), TrSeqExpr (params)));
}
}/*TrCall*/

PTGNode TrExpr (e, context)
	Expr	e;
	int	context;
{

switch (typeof (e)) {

case KLiteral:
if (context == isstmt) return (PTGEmpty ());
return (PTGC_Str (strOfLiteral (ExprToLiteral (e))));

case KVal:
if (context == isstmt) return (PTGEmpty ());
return (PTGNumb (vOfVal (ExprToVal (e))));

case KName:
return (PTGAsIs (nOfName(ExprToName (e))));

case KAttracc:
if (context == isstmt) return (PTGEmpty ());
return (TrAttracc (ExprToAttracc (e)));

case KCall:
return (TrCall (ExprToCall (e), context));

case KIncluding:
if (context == isstmt) return (PTGEmpty ());
return (TrIncluding (ExprToIncluding (e)));

default: /* Chainacc or Constit should be removed by expand */
return (PTGEmpty());
}
}/*TrExpr*/

PTGNode TrSeqExpr (s)
	SEQExpr s;
{	SEQExpr es;
	Expr	e;
	PTGNode res;

if (emptySEQExpr (s)) return (PTGEmpty ());

retrievefirstSEQExpr(s, e);
res = TrExpr (e, isval);

foreachinSEQExpr (tailSEQExpr (s), es, e)
	res = PTGSeqCom (res, TrExpr (e, isval));

return (res);
}/*TrSeqExpr*/

PTGNode TrSeqStmt (s)
	SEQExpr s;
{	SEQExpr es;
	Expr	e;
	PTGNode res;

res = PTGEmpty ();

foreachinSEQExpr (s, es, e)
	res = PTGSeq (res, PTGStmt (TrExpr (e, isstmt)));

return (res);
}/*TrSeqExpr*/
