
#include <stdio.h>
#ifndef MACH
#include <malloc.h>
#else
extern void *malloc(unsigned);
extern void free(void *);
#endif
#include "backptg_gen.h"

void _PrPTGNULL(n)
_PPTG0 n;{/* function printing nothing */}

static struct _SPTG0   _PTGNULL = { _PrPTGNULL };
PTGNode PTGNULL =  & _PTGNULL;

#define MEMERR\
	{ fprintf(stderr, "Fatal ERROR: no memory available.\n"); exit(1); }

static FILE *f;

PTGNode PTGOut (r)
PTGNode r;
{
  f = stdout;
  if (r) (* (r->_print)) (r);
  return (r);
}

PTGNode PTGOutFile (fn, r)
char * fn; PTGNode r;
{
  if ((f = fopen(fn, "w"))  == (FILE *)NULL)
  {
	fprintf(stderr, "ERROR: output file can't be open.\n");
	exit(1);
  }
  if (r) (* (r->_print)) (r);
  fclose(f);
  return (r);
}

PTGNode PTGOutFPtr(fptr, r)
FILE * fptr; PTGNode r;
{
  if ((f = fptr) == (FILE *)NULL)
  {
    fprintf(stderr, "ERROR: output file not open.\n");
    exit(1);
  }
  if (r) (* (r->_print)) (r);
  return (r);
}

typedef struct _SPTG4 *_PPTG4;
struct _SPTG4{
  _PTGProc _print;
  PTGNode _desc [4];
};

typedef struct _SPTG3 *_PPTG3;
struct _SPTG3{
  _PTGProc _print;
  PTGNode _desc [3];
};

typedef struct _SPTG2 *_PPTG2;
struct _SPTG2{
  _PTGProc _print;
  PTGNode _desc [2];
};

typedef struct _SPTG1 *_PPTG1;
struct _SPTG1{
  _PTGProc _print;
  PTGNode _desc [1];
};

typedef struct _SPTGNumb *_PPTGNumb;
struct _SPTGNumb{
  _PTGProc _print;
  int _t0;
};

typedef struct _SPTGAsIs *_PPTGAsIs;
struct _SPTGAsIs{
  _PTGProc _print;
  char *_t0;
};

typedef struct _SPTGC_Str *_PPTGC_Str;
struct _SPTGC_Str{
  _PTGProc _print;
  char *_t0;
};

typedef struct _SPTGP_Str *_PPTGP_Str;
struct _SPTGP_Str{
  _PTGProc _print;
  char *_t0;
};

void _PrPTGDescName(n)
_PPTG1 n;
{
  fputs ("_desc", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGVisitProcName(n)
_PPTG2 n;
{
  fputs ("_VS", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGInclGlobName(n)
_PPTG1 n;
{
  fputs ("_IG", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGInclLocName(n)
_PPTG1 n;
{
  fputs ("_IL", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGSymbStructName(n)
_PPTG1 n;
{
  fputs ("struct _TS", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGSymbPtrTypeName(n)
_PPTG1 n;
{
  fputs ("_TSP", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGProdStructName(n)
_PPTG1 n;
{
  fputs ("struct _TP", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGProdPtrTypeName(n)
_PPTG1 n;
{
  fputs ("_TPP", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGMkProcName(n)
_PPTG1 n;
{
  fputs ("Mk", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGNullNodePtr(n)
_PPTG0 n;
{
  fputs ("NULLNODEPTR ", f);
}

void _PrPTGMkParmName(n)
_PPTG1 n;
{
  fputs ("_tr", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGTermGetName(n)
_PPTG2 n;
{
  fputs ("GET", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGLhsStackAttrName(n)
_PPTG1 n;
{
  fputs ("_AS0", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGRhsStackAttrName(n)
_PPTG2 n;
{
  fputs ("_AS", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGVarAttrName(n)
_PPTG1 n;
{
  fputs ("_AV", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGTreeAttrName(n)
_PPTG1 n;
{
  fputs ("_AT", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGRuleAttrName(n)
_PPTG2 n;
{
  fputs ("_AR", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGStmt(n)
_PPTG1 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";\n", f);
}

void _PrPTGCall(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (")", f);
}

void _PrPTGAssign(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("=", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGIfStmt(n)
_PPTG3 n;
{
  fputs ("\nif (", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (") {\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\n} else {\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("\n}", f);
}

void _PrPTGIfExpr(n)
_PPTG3 n;
{
  fputs ("\n((", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n) ? (", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\n) : (", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("))\n", f);
}

void _PrPTGParen(n)
_PPTG1 n;
{
  fputs ("\n(", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (")\n", f);
}

void _PrPTGPtrTo(n)
_PPTG1 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("*", f);
}

void _PrPTGSelectPtr(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("->", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGContent(n)
_PPTG1 n;
{
  fputs ("(* ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (")", f);
}

void _PrPTGAddr(n)
_PPTG1 n;
{
  fputs ("(& ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (")", f);
}

void _PrPTGDecl(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (";\n", f);
}

void _PrPTGSeq(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGComElem(n)
_PPTG1 n;
{
  fputs (",", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGComSeq(n)
_PPTG2 n;
{
  fputs (",", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGSeqCom(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (",", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGEmpty(n)
_PPTG0 n;
{
}

void _PrPTGSep(n)
_PPTG1 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
}

void _PrPTGFile(n)
_PPTG1 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n", f);
}

void _PrPTGNumb(n)
_PPTGNumb n;
{
  fprintf (f, "%d",n->_t0);
}

void _PrPTGAsIs(n)
_PPTGAsIs n;
{
  fprintf (f, "%s",n->_t0);
}

extern void C_outstr();

void _PrPTGC_Str(n)
_PPTGC_Str n;
{
C_outstr(f,n->_t0);
}

extern void P_outstr();

void _PrPTGP_Str(n)
_PPTGP_Str n;
{
P_outstr(f,n->_t0);
}

void _PrPTGVisitProcFileHead(n)
_PPTG0 n;
{
  fputs ("\n#include \"HEAD.h\"\
\n#include \"err.h\"\
\n#include \"node.h\"\
\n#include \"visitprocs.h\"\
\n#include \"glattr.h\"\
\n#include \"attrpredef.h\"\n\
\n#ifndef _VisitVarDecl\
\n#define _VisitVarDecl()\
\n#endif\n\
\n#ifndef _VisitEntry\
\n#define _VisitEntry()\
\n#endif\n\
\n#ifndef _VisitExit\
\n#define _VisitExit()\
\n#endif\n\
\nvoid LIGA_ATTREVAL (n) NODEPTR n;\n\
\n{(*(n->_proc)) (n);}\n", f);
}

void _PrPTGVisitHeaderHead(n)
_PPTG0 n;
{
  fputs ("\nextern void LIGA_ATTREVAL ();\n", f);
}

void _PrPTGVisitProcHeader(n)
_PPTG1 n;
{
  fputs ("\nextern void ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("( );\n", f);
}

void _PrPTGVisitProcHead(n)
_PPTG4 n;
{
  fputs ("\nvoid ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(_currn ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (")\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs (" _currn;\n", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  fputs ("{  _VisitVarDecl()\n", f);
}

void _PrPTGVisitEntry(n)
_PPTG0 n;
{
  fputs ("\n\n_VisitEntry();\n", f);
}

void _PrPTGVisitProcTail(n)
_PPTG1 n;
{
  fputs ("_currn->_proc =", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";\n}\n", f);
}

void _PrPTGVisitProcEnd(n)
_PPTG0 n;
{
  fputs ("\n_VisitExit();\n}\n", f);
}

void _PrPTGDescVisit(n)
_PPTG3 n;
{
  fputs ("(*(_currn->", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("->_proc)) (_currn->", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs (");\n", f);
}

void _PrPTGInclPre(n)
_PPTG4 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("=", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (";", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("= &(_currn->", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  fputs (");\n", f);
}

void _PrPTGInclPost(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("=", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (";\n", f);
}

void _PrPTGTypeFileHead(n)
_PPTG0 n;
{
  fputs ("\n#include \"err.h\"\n\
\ntypedef int INT;\n\
\n#ifndef BOOL\
\ntypedef int BOOL;\
\n#endif\
\ntypedef int SYMB;\n\
\ntypedef void (* __VPROCPTR) ();\n", f);
}

void _PrPTGPtrTypedef(n)
_PPTG2 n;
{
  fputs ("\ntypedef ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("* ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (";\n", f);
}

void _PrPTGStructDecl(n)
_PPTG2 n;
{
  fputs ("\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("{\n", f);
  fputs ("POSITION _pos; __VPROCPTR _proc;\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\n};\n", f);
}

void _PrPTGTermStructDecl(n)
_PPTG2 n;
{
  fputs ("\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("{", f);
  fputs ("\nPOSITION _pos;\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\n};\n", f);
}

PTGNode PTGDescName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGDescName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGVisitProcName(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGVisitProcName;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGInclGlobName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGInclGlobName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGInclLocName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGInclLocName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGSymbStructName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGSymbStructName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGSymbPtrTypeName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGSymbPtrTypeName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGProdStructName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGProdStructName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGProdPtrTypeName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGProdPtrTypeName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGMkProcName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGMkProcName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGNullNodePtr()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGNullNodePtr;
  return ((PTGNode) n);
}

PTGNode PTGMkParmName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGMkParmName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGTermGetName(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGTermGetName;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGLhsStackAttrName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGLhsStackAttrName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGRhsStackAttrName(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGRhsStackAttrName;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGVarAttrName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGVarAttrName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGTreeAttrName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGTreeAttrName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGRuleAttrName(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGRuleAttrName;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGStmt(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGStmt;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGCall(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGCall;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGAssign(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGAssign;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGIfStmt(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGIfStmt;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGIfExpr(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGIfExpr;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGParen(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGParen;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGPtrTo(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGPtrTo;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGSelectPtr(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGSelectPtr;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGContent(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGContent;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGAddr(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGAddr;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGDecl(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGDecl;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGSeq(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGComElem(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGComElem;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGComSeq(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGComSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGSeqCom(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGSeqCom;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGEmpty()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGEmpty;
  return ((PTGNode) n);
}

PTGNode PTGSep(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGSep;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGFile(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGFile;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGNumb(_t0)
  int _t0;
{
  _PPTGNumb n;

  if ((n = (_PPTGNumb) malloc (sizeof (struct _SPTGNumb)))  ==  (_PPTGNumb)NULL)
	MEMERR
  n->_print = _PrPTGNumb;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGAsIs(_t0)
  char *_t0;
{
  _PPTGAsIs n;

  if ((n = (_PPTGAsIs) malloc (sizeof (struct _SPTGAsIs)))  ==  (_PPTGAsIs)NULL)
	MEMERR
  n->_print = _PrPTGAsIs;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGC_Str(_t0)
  char *_t0;
{
  _PPTGC_Str n;

  if ((n = (_PPTGC_Str) malloc (sizeof (struct _SPTGC_Str)))  ==  (_PPTGC_Str)NULL)
	MEMERR
  n->_print = _PrPTGC_Str;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGP_Str(_t0)
  char *_t0;
{
  _PPTGP_Str n;

  if ((n = (_PPTGP_Str) malloc (sizeof (struct _SPTGP_Str)))  ==  (_PPTGP_Str)NULL)
	MEMERR
  n->_print = _PrPTGP_Str;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGVisitProcFileHead()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGVisitProcFileHead;
  return ((PTGNode) n);
}

PTGNode PTGVisitHeaderHead()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGVisitHeaderHead;
  return ((PTGNode) n);
}

PTGNode PTGVisitProcHeader(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGVisitProcHeader;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGVisitProcHead(_t0,_t1,_t2,_t3)
PTGNode _t0,_t1,_t2,_t3;
{
  _PPTG4 n;

  if ((n = (_PPTG4) malloc (sizeof (struct _SPTG4)))  ==  (_PPTG4)NULL)
	MEMERR
  n->_print = _PrPTGVisitProcHead;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  return ((PTGNode) n);
}

PTGNode PTGVisitEntry()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGVisitEntry;
  return ((PTGNode) n);
}

PTGNode PTGVisitProcTail(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGVisitProcTail;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGVisitProcEnd()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGVisitProcEnd;
  return ((PTGNode) n);
}

PTGNode PTGDescVisit(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGDescVisit;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGInclPre(_t0,_t1,_t2,_t3)
PTGNode _t0,_t1,_t2,_t3;
{
  _PPTG4 n;

  if ((n = (_PPTG4) malloc (sizeof (struct _SPTG4)))  ==  (_PPTG4)NULL)
	MEMERR
  n->_print = _PrPTGInclPre;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  return ((PTGNode) n);
}

PTGNode PTGInclPost(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGInclPost;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGTypeFileHead()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGTypeFileHead;
  return ((PTGNode) n);
}

PTGNode PTGPtrTypedef(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGPtrTypedef;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGStructDecl(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGStructDecl;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGTermStructDecl(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGTermStructDecl;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

