# $Id: Makefile.cpp,v 1.50 1992/06/26 00:26:01 waite Exp $
# Copyright (c) 1989, The Regents of the University of Colorado
#
# Makefile for Eli Info system
#
# Variables which can be set on entry:
#    DESTDIR	Place to put files for install and SourceDistr targets
#    NOTEX	Set to true if TeX is not to be run.  This can be used to
#	save time when testing things.

SHELL	= /bin/sh
CFLAGS	=

DESTDIR = ELISYS
NOTEX   = true

COFLAGS	= -q

# The documents themselves
DOCS	= help-specs.tnf overview.tnf novice.tnf \
	info.tnf lib.tnf \
	pp.tnf ui.tnf sysadmin.tnf nodoc.tnf

# Specifications of various document classes
SPECS	= hyprtxt.specs humans.specs $(DOCS)

# Additional files that must be installed
SYS	= dir help_header help_trailer compound_head compound_tail

# variables for cleaning targets
TIDY 	= core LOG ELI *~ *.aux *.cp *.fn *.ky *.log *.pg *.ps *.toc *.tp *.vr
CLEAN 	= $(TIDY) infonames *.alw *.dvi gindex
CLOBBER = $(CLEAN) Makefile
RCS	= $(SPECS) $(SYS) online printed

# top-level targets

all:	$(SYS) $(SPECS) ELI online printed
	DUMPCORE=yes $(DESTDIR)/bin/eli -c ELI <online
	-chmod 644 `cat infonames`
	-if test '$(NOTEX)' = 'false'; \
	then $(DESTDIR)/bin/eli -c ELI <printed; chmod 644 *.dvi; \
	else :; \
	fi

install:
	-@if test '$(NOTEX)' = 'false'; \
	then for f in *.dvi; do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/info; \
		rm -f $(DESTDIR)/Tool/info/$$f; \
		cp $$f $(DESTDIR)/Tool/info; \
		chmod 644 $(DESTDIR)/Tool/info/$$f; \
		done; \
	else :; \
	fi
	@for f in $(SYS) `cat infonames` gindex; do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/info; \
		rm -f $(DESTDIR)/Tool/info/$$f; \
		cp $$f $(DESTDIR)/Tool/info; \
		chmod 644 $(DESTDIR)/Tool/info/$$f; \
		done

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp *.tnf infonames online \
		printed $(SPECS)

SourceDistr:	$(RCS)

# cleaning up rules

tidy:
	rm -rf $(TIDY)

clean:
	-rm -f `cat infonames`
	rm -rf $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

rcsclean:	clean
	-rcsclean $(COFLAGS) $(RCS) Makefile.cpp
	rm -f Makefile

save:
	-$(MKDIR) RCS
	-$(CI) -k -t/dev/null -nOriginal -u -q Makefile.cpp $(RCS)
	-$(RCS) -bOriginal.1 -q Makefile.cpp $(RCS)
	-$(CI) -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-$(CI) -fOriginal.1 -m/dev/null -q $(RCS)

ELI:
	$(DESTDIR)/bin/eli -c $(DESTDIR) -n ELI -q

.PRECIOUS:	$(SPECS) $(SYS)
