/* $Id: dj.h,v 1.16 1992/07/31 14:57:34 waite Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
#include "err.h"

#ifdef sequent
#define isgraph(c) ((unsigned)(c)>=041 && (unsigned)(c)<=0176)
#endif

extern FILE *Ft;	/* CaseTbl and ScanTbl tables */
extern FILE *Fc;	/* C code of FSM */

extern int Nstates;	/* Number of states ( 0..Nstates-1) */

/* see Ch 2 of D.S. and Network algorithms R.E. Tarjan */
struct el {
	int parent;
	int rank;
	int size;
	};

extern char * SetMemArr;

struct p_head {
	struct p_head *next;	/* only used for out partitions */
	short	desttarget;
	short 	setsize;
	char	flag;
	char	ch;
	long	first;		/* index into SetMemArr[] */
	};

struct state_head {
	struct p_head p_jam;
	struct p_head p_loop;
	struct p_head p_out;
	short	numout;		/* number of out sets */
	short   Yindex;		/* index into Yextcode, Yauxscanner ... */
	};

#define MAXLITS 500     /* maximum literal patterns */
#define MAXNONLITS 100   /* maximum non-literal patterns */
extern int NonLitCount; /* number of non-literal patterns */
extern int LitCount;    /* number of literal patterns */
extern int NTokens;     /* sum of LitCount and NonLitCount */

extern short YXsymtab[];	/* reverse index, from symbol, to Y entries */
extern char *YauxScanner[];
extern char *Yprocessor[];
extern char *Ypattern[];
extern short YextCode[];
extern short YinLine[];
extern int EofCode;		/* value returned on EOF */

#define NORETURN 15001  /* hopefully no one will ever want this extcode */
#define UNDEF -1
#define TRUE 1
#define FALSE 0
#define SET_ONE 1
#define SET_CONSECUTIVE 2
#define SET_LIST 3
extern int NDistinctSets;		/* # of sets in SetHead array */
#define SETSIZE 128	/* ascii */
extern struct el DjSets[SETSIZE];
extern short Next[SETSIZE];
extern short SetHead[SETSIZE];
extern short SetTarget[SETSIZE];	/* state to which transition goes */
extern short SetHeadJam;
extern short SetHeadLoop;
extern char *Targets;

extern struct state_head *StateHead;


extern FILE *Ft, *Fc;
extern int FlexStateFd;
extern int * AcceptStates;

#define ANYOUTTRANS(s)	(StateHead[s].numout)
#define SELFLOOP(s)	(StateHead[s].p_loop.setsize)
#define ISNEXTFINAL(sh)	(StateHead[sh->desttarget].Yindex )


#define ClearSet(SS) {register cc; for(cc=0; cc<SETSIZE; cc++) SS[cc] = 0; }
#define AddElmToSet(elm, SS) 	SS[elm] = 1

#define FROMINITIAL 1
#define NOTINITIAL  0
#define NORETURN 15001  /* also in glamain.c? */


extern short CaseTbl[SETSIZE];	/* initial switch for tokens */
extern short ExtCodeTbl[SETSIZE]; /* map single char token to extcode */

/* print ascii character in a visible manner. Be prepared for non-ascii */
#define GPNT(fp,ch,front,back) if(isgraph((ch)& 0x7F)) \
				fprintf(fp,"%s%c%s",front,(ch) & 0x7F,back); \
			      else \
                                fprintf(fp,"%s%2d.%s",front,(ch) & 0x7F,back)

/* DYNAMIC MEMORY STUFF */

#define allocate_integer_array(size) \
	(int *) allocate_array( size, sizeof( int ) )

#define reallocate_integer_array(array,size) \
	(int *) reallocate_array( (char *) array, size, sizeof( int ) )

#define allocate_integer_pointer_array(size) \
	(int **) allocate_array( size, sizeof( int * ) )

#define reallocate_integer_pointer_array(array,size) \
	(int **) reallocate_array( (char *) array, size, sizeof( int * ) )

#define allocate_character_array(size) allocate_array( size, sizeof( char ) )

#define reallocate_character_array(array,size) \
	reallocate_array( array, size, sizeof( char ) )

/************************* FUNCTION  DECLARATIONS **************************/
				/* gcc -ansi will use the prototypes */
#if defined(__cplusplus) || defined(__STDC__)

extern char *allocate_array( int size, int element_size );
extern char *reallocate_array( char *array, int size, int element_size );

extern void lerrif( char *, int );
extern void lerrsf(char*, char* );
extern void flexerror( char*);
extern void flexfatal( char* );
extern void outScanTbl(void);

extern void genCases(void);
extern void genPartition(int state, int par, struct p_head *sh, int init);
extern void genBody(int init, int state);
extern void doElseFinal(FILE *fp, int state, char *pvalue);
extern int createSet(char *SetArray, int *bitOff, int *tblOff);
extern void outScanTbl(void);
extern void printElsOfSet(FILE *fp, char set[SETSIZE]);
extern void pBoolean(char array[], char *name, int elsize, int max, FILE *fp);
extern void prtTrans(void);
extern void outShortArray(FILE *fd, char *str, short A[], int len);
extern void loadSetFromPart(struct p_head *sh, char set[SETSIZE]);

extern void bubble( short v[], int n);

extern void mkDJSetFromTransition(int state, int flexstate[SETSIZE]);
extern void makeAllPartitions(void);
extern void prtAllPartitions(void);
extern void prtPartitions(void);

/* from djsets.c */
extern void makeDJsets(void);
extern int findWhichSet(int x);
extern int linkSets(int x,int y);
extern void pntDJset(FILE *);

/* from glamain.c */
extern void diags(void);
extern void writeConstants(FILE *fp);
extern void writeFiles(FILE *fd);
extern void yyerror(char *s);
extern int yyparse(void);

extern void initBuf(const char* infile, int f);
extern void refillBuf(const char*);
extern int glalex(void *);

extern void message(int severity, char *text, int grammar, POSITION *);
extern void lisedit( char *name, FILE *stream, int cutoff, int  erronly);

#else

extern char *allocate_array();
extern char *reallocate_array();

extern void lerrif();
extern void lerrsf();
extern void flexerror();
extern void flexfatal();
extern void outScanTbl();

extern void genCases();
extern void genPartition();
extern void genBody();
extern void doElseFinal();
extern int createSet();
extern void outScanTbl();
extern void printElsOfSet();
extern void pBoolean();
extern void prtTrans();
extern void outShortArray();
extern void loadSetFromPart();

extern void bubble();

extern void mkDJSetFromTransition();
extern void makeAllPartitions();
extern void prtAllPartitions();
extern void prtPartitions();

/* from djsets.c */
extern void makeDJsets();
extern int findWhichSet();
extern int linkSets();
extern void pntDJset();

/* from glamain.c */
extern void diags();
extern void writeConstants();
extern void writeFiles();
extern void yyerror();
extern int yyparse();

extern void initBuf();
extern void refillBuf();
extern int glalex();

extern void message();
extern void lisedit();
#endif
