static char RCSid[] = "$Id: gla_be.c,v 1.3 1992/07/07 23:19:25 waite Exp $";
/* Copyright (c) 1989, The Regents of the University of Colorado */

#include "dj.h"

#define ERR(msg)	fprintf (stderr, "%s", msg)

/* Should take these out of dj.h and put into part.c */
/* This would mean that frontend/gla_fe.c wouldn't need them. */
int FlexStateFd;
int Nstates;
int *AcceptStates;
char *Targets;

int EofCode, LitCount, NonLitCount, NTokens;

char *YauxScanner[MAXLITS+MAXNONLITS];
char *Yprocessor[MAXLITS+MAXNONLITS];
char *Ypattern[MAXLITS+MAXNONLITS];
short YextCode[MAXLITS+MAXNONLITS];

FILE *Ft, *Fc;

/* command line options */

int PrintTokens=0;	/* To gen a scanner that prints tokens.  Takes an optional
			   int argument that causes the assoc array to be larger than
			   just Ntokens -- incase token codes are not dense.  */
int TransFlg = 0;	/* Print Transition table */
int PartitFlg = 0;	/* Print Partition table */
int AcceptFlg = 0;	/* Print Accepting states */
int OverlapFlg = 0;	/* Warn of token code overlaps */

/*
 * diags
 */

void diags()
{
	int i;

	if (TransFlg)
		prtTrans();
	if (PartitFlg)
		prtAllPartitions();
	if (AcceptFlg) {
		printf("Accepting states:\n");
		for (i = 0; i < Nstates; i++)
			printf("%3d",i);
		printf("\n");
		for(i = 0; i < Nstates; i++)
			printf("%3d",AcceptStates[i]);
		printf("\n");
	}
}

/*
 * main
 */

void
main(argc,argv)
int argc; char **argv;
{
	int verbose = 0;
	char *progname;
	int count, fd;

	progname = argv[0];
	while (argc > 1) {
		if (argv[1][0] == '+' || argv[1][0] == '-')
			switch (argv[1][1]) {
			case 'd': sscanf (&argv[1][2], "%d", &PrintTokens);
				  if (PrintTokens <= 0) PrintTokens = 1;
				  if (PrintTokens > MAXLITS)
					  PrintTokens = MAXLITS;
				  break;
			case 'v': verbose++; break;
			case 'w': OverlapFlg++; break;
			case 'A': AcceptFlg++; break;
			case 'P': PartitFlg++; break;
			case 'T': TransFlg++; break;
			default: 
				fprintf(stderr, "%s: unknown option '%c'\n", 
					progname, argv[1][1]);
			}
		else
			break;
		argc--;
		argv++;
	}

	if (argc != 5) {
		fprintf(stderr, "Usage %s [options] backend_data", progname);
		ERR(" lastdfa.binary accept.binary flex.binary\n" );
		ERR("  -d scanner will output the token stream.\n");
		ERR("  -dsiz as above, but up to SIZ non-compact tokens.\n");
		ERR("  -v give verbose statistics.\n");
		ERR("  -A print out array of Accepting states.\n");
		ERR("  -T print out Transition table.\n");
		ERR("  -P print out Partition table.\n");
		exit(1);
	}

	readBackendData (argv[1]);

	fd = open(argv[2],0);
	if (fd < 0)
		perror("cannot open lastdfa.binary");

	/* machine dependent stuff -- we are about to read binary data */
	assert(sizeof(int) == sizeof(Nstates));
	count = read(fd, (char*)&Nstates, sizeof(int));
	if (count != sizeof(int))
		perror("bad read of NStates");
	close(fd);
	if (verbose)
		printf("Number of states based on lastdfa.binary = %d\n", Nstates);
	
	AcceptStates = (int *) malloc((unsigned)Nstates * sizeof(int));
	if (AcceptStates == NULL) {
		printf("no memory for AcceptStates\n");
		exit(5);
	}

	fd = open(argv[3],0);
	if (fd < 0)
		perror("cannot open accept.binary");
	count = read(fd,(char*)AcceptStates, Nstates*sizeof(int));
	if (count != Nstates*sizeof(int))
		perror("bad read of AcceptStates");
	close(fd);

	FlexStateFd = open(argv[4],0);
	if (FlexStateFd < 0)
	   perror("cannot open flex.binary");

	Fc = fopen("xcode.h", "w");
	Ft = fopen("xtables.h", "w");
	if (Ft==NULL || Fc==NULL) {
		printf("cannot open output files\n");
		exit(2);
	}
	writeConstants(Ft);
	makeAllPartitions();
	close(FlexStateFd);
	diags();	/* optional diagnostic printing */
	genCases();

	exit (0);

}

/*
** In the routine  writeConstants, if PrintTokens is TRUE, we want to
** build an array of strings that reflects the user's gla specification.
** Then, when the user's scanner is run, token codes and the corresponding
** string from the specification will be reported.
**
** It is not sufficient to wrap doublequotes around his characters.
** For example, the lexical spec might be:
**                     $(((([0-9]+\.[0-9]*)|(\.[0-9]+))((e|E)(\+|\-)? ...
** but the C string needs to be:
**                    "(((([0-9]+\\.[0-9]*)|(\\.[0-9]+))((e|E)(\\+|\\-)? ..."
** and
**               $"->+"
** needs to be
**              "\"->+\""
**
** SO, when we see a backslash, we output a pair of backslashes and
** when we see a doublequote, we output  backslash doublequote.
*/

#define MAXEXPANDBUF 512

char *
expBKSLASH(in)
register char * in;	/* incomming string */
{
	static char outBuf[MAXEXPANDBUF+1];
	register char c;
	register char *out = outBuf;
	int count = 0;		/*  additional characters added to output */

	while (c = *in++) {
		if (c == '\\' ) {
			*out++ = '\\';
			*out++ = '\\';
			count++;
			}
		else if(c ==  '"' ) {
			*out++ = '\\';
			*out++ = '"';
			count++;
			}
		else {
			*out++ = c;
			}

		if (count+out-outBuf >= MAXEXPANDBUF)	/* firewall */
			return("expBKSLASH: very long regular expression");
		}

	*out++ = 0;
	return outBuf;
}
				
/*
 * writeConstants
 */

void
writeConstants(fp)
FILE *fp;
{
	int i;

	fprintf(fp, "#define NONLITCOUNT %d\n", NonLitCount);
	fprintf(fp, "#define LITCOUNT %d\n", LitCount);
	fprintf(fp, "#define NTOKENS %d\n", NTokens);
	fprintf(fp, "#define EOFTOKEN %d\n", EofCode);

	/* declare external processors */
	fputs("#if defined(__cplusplus) || defined(__STDC__)\n", fp);
	fputs("extern void", fp);
	for (i = 1; i <= NonLitCount; i++)
		if (Yprocessor[i+LitCount])
			fprintf(fp," %s(char *, int, int *, char *),\n",
				Yprocessor[i+LitCount]);
	fputs(" dummy1(char *, int, int *, char *);\n", fp);
	fputs("#else\n", fp);
	fputs("extern void", fp);
	for (i = 1; i <= NonLitCount; i++)
		if (Yprocessor[i+LitCount])
			fprintf(fp," %s(),", Yprocessor[i+LitCount]);
	fputs(" dummy1();\n", fp);
	fputs("#endif\n", fp);

	/* declare external auxScanners */
	fputs("#if defined(__cplusplus) || defined(__STDC__)\n", fp);
	fputs("extern char", fp);
	for (i = 1; i <= NonLitCount; i++)
		if (YauxScanner[i+LitCount])
			fprintf(fp," *%s(char *, int),\n",
				YauxScanner[i+LitCount]);
	fputs(" *dummy2(char *, int);\n", fp);
	fputs("#else\n", fp);
	fputs("extern char", fp);
	for (i = 1; i <= NonLitCount; i++)
		if (YauxScanner[i+LitCount])
			fprintf(fp," *%s(),", YauxScanner[i+LitCount]);
	fputs(" *dummy2();\n", fp);
	fputs("#endif\n", fp);
	
	/*
	** Print out an associative array for tokens strings.
	** If PrintTokens==1 then assume a dense encoding starting at 0.
	** (Eli starts codes at 1 with EOF, and NTokens does not include
	** EOF. This explains the need for NTokens+2 instead of just NTokens.)
	** We could have sorted extCode[], but it is easier 
	** to just load a new array of pointers.
	**
	** If PrintTokens>1, then use this value as array size.  This is for
	** the guy that wants tokens printed but his codes are not dense.
	**
	** While we are here, it is easy to check for token code overlaps.
	*/
	if (PrintTokens || OverlapFlg) {
		int size = PrintTokens==1? NTokens+2 : PrintTokens;
		char **sortTok =
			(char **) malloc((unsigned)(size) * sizeof(char *));
		if (sortTok == NULL) {
			printf("no memory for sortTok\n");
			exit(5);
		}
		for (i = 0; i < size; i++)
			sortTok[i] = NULL;
		for (i = 0; i < size; i++)
			if (YextCode[i] >= 0 && YextCode[i]<size) {
				/* in range */
				if (OverlapFlg &&
				    (sortTok[YextCode[i]] !=NULL))
					fprintf(stderr, "Warning: code %d reused with %s\n",
						YextCode[i] , Ypattern[i]);
				sortTok[YextCode[i]] = Ypattern[i];
			} else { /* out of range */
				if(OverlapFlg && (Ypattern[i] != NULL))
					fprintf(stderr, "Warning: code %d for %s is >= %d\n",
						YextCode[i] , Ypattern[i], size);
			}
		if (PrintTokens) {
			fputs("/* turns on printing, and give array size */\n", fp);
			fprintf(fp,"#define GLAPRINTTOKENS %d\n", size);
			fputs("int GlaPrintTokens = 1;\n", fp);
			fprintf(fp, "char *TokenStrings[%d] = {\n", size);
			for (i = 0; i < size; i++)
				fprintf(fp, "	\"%s\",	/* %d */\n",
					sortTok[i]==NULL?"":expBKSLASH(sortTok[i]), i);
			fputs("};\n", fp);
		}
	}
}

/*
 * readBackendData
 */

#define GETSTR(x) { \
	    char *t = s; \
            while ((*t++ = fgetc (fp)) != '\n') \
                    ; \
	    *(t-1) = '\0'; \
	    if (strcmp (s, "(null)") == 0) \
		    (x) = NULL; \
	    else \
		    (x) = strcpy (malloc (strlen (s)+1), s); \
        }

readBackendData (filename)
char *filename;
{
	FILE *fp;
	int i;
	char s[256];

	fp = fopen (filename, "r");
	if (fp == NULL) {
		fprintf (stderr, "can't open '%s' for reading\n", filename);
		exit (1);
	}

	fscanf (fp, "%d %d %d ", &EofCode, &LitCount, &NonLitCount);
	NTokens = LitCount + NonLitCount;
	Ypattern[0] = YauxScanner[0] = Yprocessor[0] = (char *)0;
	YextCode[0] = 1;
	for (i = 1; i <= NTokens; i++) {
		GETSTR(Ypattern[i]);
		GETSTR(YauxScanner[i]);
		GETSTR(Yprocessor[i]);
		fscanf (fp, "%hd\n", &(YextCode[i]));
	}

	fclose (fp);
}
