/* $Id: err.h,v 1.17 1992/07/26 23:01:50 waite Exp $ */
/* Copyright 1989, The Regents of the University of Colorado
 * Permission is granted to use any portion of this file for any purpose,
 * commercial or otherwise, provided that this notice remains unchanged.
 */

#ifndef ERR_DEF
#define ERR_DEF

	/* Error report classification */

#define NOTE	0	/* Nonstandard construct */
#define COMMENT	1	/* Criticism of programming style */
#define WARNING	2	/* Possible error */
#define ERROR	3	/* Repairable error */
#define FATAL	4	/* Unrepairable error */
#define DEADLY	5	/* Compiler error */


	/* Types exported by the Error Module */

typedef struct {	/* Source listing coordinates */
	int line;	   /* Line number */
	int col;	   /* Character position */
} POSITION;


	/* Variables exported by the Error Module */

extern int ErrorCount[];
extern POSITION curpos;	/* Current source text position */


	/* Routines exported by the Error Module */

#if defined(__cplusplus) || defined(__STDC__) 
extern void ErrorInit(int ImmOut, int AGout, int ErrLimit);
#else
extern ErrorInit();
#endif 
/* Initialize the error module 
 *    On entry- 
 *       ImmOut=1 if immediate error output required 
 *       AGout=1 to print AG line number on error reports 
 *       ErrLimit=1 to limit the number of errors reported
 ***/



#if defined(__cplusplus) || defined(__STDC__)
extern void message(int severity, char *Msgtext, int grammar, POSITION *source);
#else
extern void message();
#endif
/* Report an error
 *    On entry-
 *      severity=error severity
 *      Msgtext=message text
 *      grammar=identification of the test that failed
 *      source=source coordinates at which the error was detected
 ***/



#if defined(__cplusplus) || defined(__STDC__) 
extern void lisedit(char *name, FILE *stream, int cutoff, int erronly);
#else
extern void lisedit();
#endif
/* Output the listing with embedded error messages
 *    On entry-
 *       name is the source file name
 *       stream specifies the listing file
 *       cutoff=lowest severity level that will be listed
 *    If erronly != 0 then on exit-
 *       Source file lines containing errors have been added to file stream
 *          with error messages attached
 *    Else on exit-
 *       All source file lines have been added to file stream
 *          with error messages attached to those containing errors
 ***/

#endif
