
#include <stdio.h>
#include <malloc.h>
#include "ptg_gen.h"

void _PrPTGNULL(n)
_PPTG0 n;{/* function printing nothing */}

static struct _SPTG0   _PTGNULL = { _PrPTGNULL };
PTGNode PTGNULL =  & _PTGNULL;

#define MEMERR\
	{ fprintf(stderr, "Fatal ERROR: no memory available.\n"); exit(1); }

static FILE *f;

PTGNode PTGOut (r)
PTGNode r;
{
  f = stdout;
  if (r) (* (r->_print)) (r);
  return (r);
}

PTGNode PTGOutFile (fn, r)
char * fn; PTGNode r;
{
  if ((f = fopen(fn, "w"))  == (FILE *)NULL)
  {
	fprintf(stderr, "ERROR: output file can't be open.\n");
	exit(1);
  }
  if (r) (* (r->_print)) (r);
  fclose(f);
  return (r);
}

PTGNode PTGOutFPtr(fptr, r)
FILE * fptr; PTGNode r;
{
  if ((f = fptr) == (FILE *)NULL)
  {
    fprintf(stderr, "ERROR: output file not open.\n");
    exit(1);
  }
  if (r) (* (r->_print)) (r);
  return (r);
}

typedef struct _SPTG3 *_PPTG3;
struct _SPTG3{
  _PTGProc _print;
  PTGNode _desc [3];
};

typedef struct _SPTG2 *_PPTG2;
struct _SPTG2{
  _PTGProc _print;
  PTGNode _desc [2];
};

typedef struct _SPTG1 *_PPTG1;
struct _SPTG1{
  _PTGProc _print;
  PTGNode _desc [1];
};

typedef struct _SPTGSymbol *_PPTGSymbol;
struct _SPTGSymbol{
  _PTGProc _print;
  char *_t0;
};

typedef struct _SPTGString *_PPTGString;
struct _SPTGString{
  _PTGProc _print;
  char *_t0;
};

extern void FSymbol();

void _PrPTGSymbol(n)
_PPTGSymbol n;
{
FSymbol(f,n->_t0);
}

extern void FString();

void _PrPTGString(n)
_PPTGString n;
{
FString(f,n->_t0);
}

void _PrPTGNewline(n)
_PPTG1 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n", f);
}

void _PrPTGSpcSeq(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGSeq(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGComSeq(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (",", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGHead(n)
_PPTG1 n;
{
  fputs ("%\n%   LIDO generated for grammar ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" \n%\n\n", f);
}

void _PrPTGRule(n)
_PPTG3 n;
{
  fputs ("RULE ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" : \n  ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" ::= ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("\nCOMPUTE\nEND;\n\n", f);
}

void _PrPTGNonterm(n)
_PPTG1 n;
{
  fputs ("NONTERM ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" : ;\n", f);
}

void _PrPTGTerm(n)
_PPTG1 n;
{
  fputs ("TERM ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" : ;\n", f);
}

PTGNode PTGSymbol(_t0)
  char *_t0;
{
  _PPTGSymbol n;

  if ((n = (_PPTGSymbol) malloc (sizeof (struct _SPTGSymbol)))  ==  (_PPTGSymbol)NULL)
	MEMERR
  n->_print = _PrPTGSymbol;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGString(_t0)
  char *_t0;
{
  _PPTGString n;

  if ((n = (_PPTGString) malloc (sizeof (struct _SPTGString)))  ==  (_PPTGString)NULL)
	MEMERR
  n->_print = _PrPTGString;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGNewline(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGNewline;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGSpcSeq(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGSpcSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGSeq(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGComSeq(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGComSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGHead(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGHead;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGRule(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGRule;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGNonterm(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGNonterm;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGTerm(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGTerm;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

