# $Id: Makefile.cpp,v 1.3 1992/06/28 14:43:08 kadhim Exp $
# Digit calculator example

SHELL	= /bin/sh
CFLAGS	=

# Location of the master cache
DESTDIR = ../../..

SPECS	= Nest.doc Nest.lido Nest.specs \
	  minilax.con minilax.cull minilax.gla minilax.lido minilax.sym \
	  minilax.specs
EXTRAS	= derive input result gen_ag.lido

TIDY	= ERRS a.out core *.o *.a ELI pcode
CLEAN	= $(TIDY) *.exe

all:	ELI $(SPECS) $(EXTRAS)
	if test '$(DESTDIR)' = ''; \
	then (DUMPCORE=yes ../../../bin/eli -c ELI <derive); \
	else (DUMPCORE=yes $(DESTDIR)/bin/eli -c ELI <derive); \
	fi

install:
	@for f in $(SPECS) $(EXTRAS) Makefile; do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/examples/genlido ; \
		rm -f $(DESTDIR)/Tool/examples/genlido/$$f; \
		cp $$f $(DESTDIR)/Tool/examples/genlido ; \
		chmod 644 $(DESTDIR)/Tool/examples/genlido/$$f; \
		done

executable:
	rm -rf $(CLEAN) Makefile.cpp

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

ELI:
	if test '$(DESTDIR)' = ''; \
	then ../../../bin/eli -c ../../.. -n ELI -q; \
	else $(DESTDIR)/bin/eli -c $(DESTDIR) -n ELI -q; \
	fi

