# $Id: Makefile.cpp,v 1.14 1992/06/24 23:28:19 waite Exp $
# Command line processor example

SHELL	= /bin/sh
CFLAGS	=

# Location of the master cache
DESTDIR = ../../..

SPECS	= clptest.specs clptest.c clptest.lido clptest.clp
EXTRAS	= derive input result1 result2

TIDY	= ERRS a.out core *.o *.a ELI
CLEAN	= $(TIDY) *.exe

all:	ELI $(SPECS) $(EXTRAS)
	if test '$(DESTDIR)' = ''; \
	then (DUMPCORE=yes ../../../bin/eli -c ELI <derive); \
	else (DUMPCORE=yes $(DESTDIR)/bin/eli -c ELI <derive); \
	fi

install:
	@for f in $(SPECS) $(EXTRAS) Makefile; do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/examples/clp ; \
		rm -f $(DESTDIR)/Tool/examples/clp/$$f; \
		cp $$f $(DESTDIR)/Tool/examples/clp ; \
		chmod 644 $(DESTDIR)/Tool/examples/clp/$$f; \
		done

executable:
	rm -rf $(CLEAN) Makefile.cpp

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

ELI:
	if test '$(DESTDIR)' = ''; \
	then ../../../bin/eli -c ../../.. -n ELI -q; \
	else $(DESTDIR)/bin/eli -c $(DESTDIR) -n ELI -q; \
	fi
