/******************************************************************************/
/* filename: tdcore.c                         first edit   :   5 . 10 . 90    */
/* author  : Christian Zeitel                 last change  :  13 . 12 . 90    */
/******************************************************************************/

/********************************* CONTENTS ************************************
 *									       *
 *  This file contains the conceptual design for a parsercore of a tabledriven * *  LALR(1)-parser realized by function "parsercore".		               *
 *									       *
 *  -input  : a terminal for determing the next parsercore-action.             *
 *	      The variable term contains the syntaxcode of the actual          *
 *            terminalsymbol                            		       *
 *  -output : a connection-point for the (virtual) parserframe encoded in a    *
 *            macro-call. The following connections are possible:    	       *
 *									       *
 *            -N_READ      : read a new token from the scanner during          *
 *                           normal parsing.                                   *
 *            -E_READ      : read a new token from the scanner during          *
 *                           error-recovery.                                   *
 *									       *
 *	      -ACCEPTAC    : terminate the parsing successfully.	       *
 *									       *
 *	      -SX_ERROR    : print out the errormessage for a syntax-error     *
 *			     detected by the parsercore. 		       *
 *	      -SF_ERROR    : print out the errormessage for a stack-overflow-  *
 *			     error and exit.				       *
 *	      -PT_ERROR    : print out the errormessage for detecting an error *
 *			     in a parse-table and exit.		    	       *
 *	      -GENERATE    : generate an error-token and insert it into the    *
 *			     source-text.				       *
 *            -KEEP        : cause the parserframe to keep the current token   *
 *                                                                             *
 *	      -CONTINUE    : continue the normal parsing after error-recovery  *
 *			     terminal.					       *
 *            -USER        : make a connection for a production.	       *
 *                                                                             *
 *  The corresponding macro-calls for this connections are enhanced by         *
 *  fitting parameters.                                                        *
 *									       *
 ******************************* INCLUDE-FILES ********************************/

#include "ptabs.h"    /* contains the generated parser-tables 		      */

#include "tdframe.h"   /* interfaces to other compiler-modules                */

/*********************************** CONTENTS **********************************
 *									       *
 *  The following definitions are  C-function-macros for all functions which   *
 *  access ondatastructures which are not changable by the optimization.       *
 *  (Former this was the contents of file "constaccfuncs.h")                   *
 *									       *
 ******************************************************************************/
 
#define Is_conn( rule )  conncode[rule]

/* Is_conn( rule ) is true, if the production coded in rule belongs to the
 * abstract syntax. For a not semantic rule conncode[rule] is always zero.
 *
 ***/
 
 
#define Conn_code( rule )  conncode[rule]

/* Conn_code( rule ) is the code of the rule coded in rule which is used for
 * making connections for this rule in the parserframe. The array conncode can
 * be found in file ptabs.h
 *
 ***/
 
 
#define Get_lhsnt( rule )  lhs[rule]

/* The result is the code of the nonterminal which stands on the lefthandside 
 * of the production coded in rule . The array lhs can be found in file ptabs.h.
 *
 ***/
 
 
 
#define Dec_spbyrulelen( sp, rule )  sp  -=  len[rule]

/* The stackpointer sp is decremented by the length of production coded by rule.
 * The array len can be found in file ptabs.h.
 *
 ***/
 
 
 
#define Dec_spbyrulelenminusone( sp, rule )  sp  = sp - len[rule] + 1
 
 
 
#define Contaut( state )  cont[state]

/* Contaut( state ) is the terminal produced by the continuation-automaton for 
 * the state coded in state to produce the error-continuation after a syntax-
 * error. The array cont can be found in file ptabs.h
 *
 ***/



#define Sepasymb( index )  seps[index]

/* seps is the list of list-separators.
 *
 ***/
 
  
  
#define Is_skip( term ) \
  ((terminf[(term - BASE) >> 2] >> (((term - BASE) & 0x0003)<< 1)) & 0x02)
  
  
#define Is_brac( term ) \
  ((terminf[(term - BASE) >> 2] >> (((term - BASE) & 0x0003)<< 1)) & 0x01)
  
    
/* The former two functions access on one common datastucture, the byte-vector
 * terminf, which is defined in file ptabs.h. terminf contains the following 
 * two important informations about the terminal-symbols:
 *
 * Is_skip( term ) = 1, if the terminal with sxcode in term is an unsave anchor,
 *                 = 0  else.
 *
 * Is_brac( term ) = 1, if the terminal with sxcode in term is a syntactic 
 * bracket,        = 0  else.
 *  
 * The informations in vector terminf are stored in the following way:
 * if term - BASE = i the two informations can be found in  byte number 
 * i div 4 of vector terminf. For j := 6 - (i mod 4) * 2 the value Is_skip(term)
 * is stored in bit j+1 and the value Is_brac(term) is stored in bit j of the 
 * corresponding byte. BASE is a constant defined in ptabs.h.It has the value of
 * the smallest  sxcode of a terminal. if tt{term} is the two-bit tuple for
 * the terminal with sxcode term, the bits have the following values :
 *
 *					   tterm{term}
 *   tt{term}[1] = Is_skip( term )         +-------+ 
 *   tt{term}[0] = Is_brac( term )         | 1 | 0 |
 *                                         +-------+
 *
 ***/ 
  
 
 
 
 
#define Copy_stack_to_hstack \
             for( i = 0; i <= sp; i++ ) hstack[i] = stack[i]; hsp = sp
 
/* Copy parserstack stack to hstack and stackpointer sp to hsp.
 * The indexvariable i , hstack, stack, hsp and sp must be defined in 
 * function reachable .
 *
 ***/

/********************************** CONTENTS   *********************************
 *									       *
 *  The following definitions are C-function-macros for all functions which    *
 *  access on the parsertables, which are changable by the optimization. By    *
 *  defining a name in file ptabs.h,the C-preprocessor can select the correct  *
 *  functionset for the corresponding datastructures in ptabs.h. Former these  *
 *  definitions were the contents of file "varaccfuncs.h"      		       *
 *									       *
 ******************************************************************************/

#define ACTIONMASK  0x0000f000

#define OPERANDMASK 0x00000fff

 
#ifdef TOPT_RCSA

#ifndef TWOBYTE
#define TWOBYTE
#endif

/* The simple Row Column Scheme is performed for the terminal-table */

#define Get_ttabentry( entry, state, term ) \
	entry.action  = 0; \
	k = tbase[state + 1];\
	for( i = tbase[state]; i < k; i++ ) { \
        	if((ttab[i] & 0x0000FFFF) == term )  { \
	        	j = ttab[i] >> 16; \
			entry.action  = j & ACTIONMASK; \
			entry.operand = j & OPERANDMASK; \
			break; \
		} \
	}
#endif


#ifdef   NOPT_RCSA

#ifndef TWOBYTE
#define TWOBYTE
#endif

/* the simple Row Column Scheme is performed for the nonterminal-table */
 
#define Get_ntabentry( entry, state, lhsnt ) \
	k = nbase[state + 1];\
	for( i = nbase[state]; i < k; i++ ) {\
		if((ntab[i] & 0x0000FFFF) == lhsnt )  { \
			j = ntab[i] >> 16; \
		 	entry.action  = j & ACTIONMASK; \
			entry.operand = j & OPERANDMASK; \
			break; \
		} \
	}
#endif


#ifdef  TOPT_GCS

/* the Graph Colouring Scheme is performed for the terminal-table */

#define SIGMAP( row, col ) \
	( sigmap[row][ col >> 3 ] >> ( col & 0x0007 ) ) & 0x01

#define Get_ttabentry( entry, state, term ) \
	j = conv[ term ]; \
	if( SIGMAP( sigrowind[state], sigcolind[ j ] ) )  { \
		i = ttab[ trowptr[ state ] ][ tcolptr[ j ] ]; \
		entry.action  = i & ACTIONMASK; \
		entry.operand = i & OPERANDMASK; \
	} \
	else \
		entry.action  = 0; \
	
	
#endif


#ifdef  NOPT_GCS

/* the Graph Colouring Scheme is performed for the nonterminal-table */

#define Get_ntabentry( entry, state, lhsnt ) \
	i = ntab[ nrowptr[state] ][ ncolptr[lhsnt] ]; \
	entry.action  = i & ACTIONMASK; \
	entry.operand = i & OPERANDMASK;
		
#endif


#ifdef  TOPT_LES

/* the Line Elimination Scheme is performed for the terminal-table */

#define SIGMAP( row , col )\
	( sigmap[ row ][ col >> 3 ] >> ( col & 0x0007 ) ) & 0x01

#define Get_ttabentry( entry, state, term ) \
	j = conv[term]; \
	if( SIGMAP( sigrowind[state], sigcolind[j] ) )  { \
		if( tdecrow[state] < tdeccol[j] ) \
			i = trowval[state]; \
		else if( tdecrow[state] > tdeccol[j] ) \
		        i = tcolval[j]; \
		     else \
		        i = ttab[ trowval[state] ][ tcolval[j] ]; \
		entry.action  = i & ACTIONMASK; \
		entry.operand = i & OPERANDMASK; \
	} \
	else \
		entry.action  = 0; \

#endif


#ifdef  NOPT_LES

/* the Line Elimination Scheme is performed for the nonterminal-table */

#define Get_ntabentry( entry, state, lhsnt ) \
	if( ndecrow[state] < ndeccol[lhsnt] ) \
		i = nrowval[state]; \
	else if( ndecrow[state] > ndeccol[lhsnt] ) \
		i = ncolval[lhsnt]; \
	else \
		i = ntab[ nrowval[state] ][ ncolval[lhsnt] ]; \
	entry.action  = i & ACTIONMASK; \
	entry.operand = i & OPERANDMASK;
	
#endif


#ifdef  TOPT_RDS

/* the Row Displacement Scheme is performed for the terminal-table */

#define SIGMAP( row , col )\
	( sigmap[ row ][ col >> 3 ] >> ( col & 0x0007 ) ) & 0x01

#define Get_ttabentry( entry, state, term ) \
	j = conv[ term ]; \
	if( SIGMAP( sigrowind[state], sigcolind[j] ) )  { \
		i = ttab[ trowptr[state] + j ]; \
		entry.action  = i & ACTIONMASK; \
		entry.operand = i & OPERANDMASK; \
	}\
	else \
		entry.action  = 0; \

#endif




#ifdef  NOPT_RDS

/* the Row Displacement Scheme is performed for the nonterminal-table */

#define Get_ntabentry( entry, state, lhsnt ) \
	i = ntab[ nrowptr[state] + lhsnt ]; \
	entry.action  = i & ACTIONMASK; \
	entry.operand = i & OPERANDMASK;
	
#endif




#ifdef  TOPT_SDS

/* the Significant Distance Scheme is performed for the terminal-table */

#define Get_ttabentry( entry, state, term ) \
	j = conv[ term ]; \
	if( j < tfirstptr[state]  ||  j > tlastptr[state] ) \
		entry.action  = 0; \
	else { \
		i = ttab[ trowptr[state] + j ]; \
		entry.action  = i & ACTIONMASK; \
		entry.operand = i & OPERANDMASK; \
	}
	
#endif


#ifdef  NOPT_SDS

/* the Significant Distance Scheme is performed for the nonterminal-table */

#define Get_ntabentry( entry, state, lhsnt ) \
	i = ntab[ nrowptr[state] + lhsnt ]; \
	entry.action  =  i & ACTIONMASK; \
	entry.operand =  i & OPERANDMASK
	
#endif


#ifdef  TOPT_RCSB

#ifndef TWOBYTE
#define TWOBYTE
#endif

/* the Row Column Scheme is performed for the terminal-table */
/* with merging of equal rows                                */

#define Get_ttabentry( entry, state, term ) \
	entry.action  = 0; \
	k = tbase[trpt[state] + 1]; \
	for( i = tbase[trpt[state]]; i < k; i++ ) { \
        	if((ttab[i] & 0x0000FFFF) == term )  { \
	        	j = ttab[i] >> 16; \
			entry.action  = j & ACTIONMASK; \
			entry.operand = j & OPERANDMASK; \
			break; \
		} \
	}
	
#endif


#ifdef  NOPT_RCSB

#ifndef TWOBYTE
#define TWOBYTE
#endif

/* the Row Column Scheme is performed for the nonterminal-table */
/* with merging of equal rows                                   */

#define Get_ntabentry( entry, state, lhsnt ) \
	k = nbase[nrpt[state] + 1]; \
	for( i = nbase[nrpt[state]]; i < k; i++ ) { \
		if((ntab[i] & 0x0000FFFF) == lhsnt )  { \
			j = ntab[i] >> 16; \
		 	entry.action  = j & ACTIONMASK; \
			entry.operand = j & OPERANDMASK; \
			break; \
		} \
	}

#endif

/************************* CODES FOR PARSERTABLE-ACTIONS **********************/

#define  ERROR     0

#define  SHIFT     (1 << 12)

#define  SHIFT_NT  (6 << 12)

#define  REDUCE    (2 << 12)

#define  SHIFTRED  (4 << 12)

#define  SHRED_NT  (9 << 12)

#define  ACCEPT    (8 << 12)              
 
/************************** TYPE-DEFINITIONS **********************************/

/* typedefinition for a parser-table-entry */

typedef struct  {
	unsigned short  action;
		 short  operand;
} tabentry;

/* typedefinintion for restartpoint-information */

typedef struct  {
	char   mode;
	short  state;
	short  term;
} rstinftype;

#ifdef TWOBYTE
typedef int htype;
#else
typedef short htype;
#endif

/**************************** CONSTANT-MACROS *********************************/
		      
/* markers which guarantee the jump to the right instruction if parsercore  */
/* is called by the frame 						    */

#define M_1  1

#define M_2  2

#define M_3  3

#define M_4  4

#define M_5  5

#define M_6  6

#define M_7  7

#define M_8  8

/* switchstates */
		     
#define OFF 0

#define ON  1

/* results of functions errorsymb, reachable and rst_beh_sepa */

#define FULL    -2

#define FAULT   -1

#define FAIL     0

#define REACHED  1

/* restart-point information  */

#define NORMAL	         0

#define RST_BEH_SEPA     1

/* size of the parserstack */

#define STACKSIZE  1000

/*************************** PRIVATE VARIABLES ********************************/

static rstinftype  rstinf = { NORMAL, 0, 0 }; /* restart-information */

/**************************** PRIVATE FUNCTIONS *******************************/

#ifdef NUOFSEPAS /* errorsymb and rst_beh_sepa are only    */
                 /* compiled if listseparators are present */


static char rst_beh_sepa( stack, sp, entry, term )

       short       *stack, /* the parse-stack for error-recovery       */
       	 	    sp;    /* stackpointer for error-recovery          */
       tabentry     entry; /* an entry in the T- or N-table	       */
       short        term;  /* the current terminal            	       */
       		    
/*
 *  rst_beh_sepa is invoked, if a listseparator can be inserted during
 *  error-recovery. It "looks behind the list-separator" by performing
 *  reductions due to inserting the separator till a shift-action is reached.
 *
 ***/
 
      {   short    rule;
          int   i, j, k;
      
          
          do  {
	 
	    
	    switch( entry.action )  {
	    
	    	case SHIFT     :  if( ++sp == STACKSIZE ) 
	    				return( FULL );
	    	                  stack[sp] = entry.operand;
	    			  break;
	    			  
	    	case SHIFT_NT  :  break;
	    	
	    	case SHIFTRED  :
	    	case SHRED_NT  :  rule = entry.operand;
	    			  Dec_spbyrulelenminusone( sp, rule );
	    			  Get_ntabentry(
	    			                 entry,
	    			     		 stack[sp], 
	    			     		 Get_lhsnt( rule )
	    			               );
	    			  break;
	    	
	    	case ACCEPT    :
	    	case REDUCE    :		  
	        case ERROR     :
	        default	       :  return( FAULT );
	        		  
	    }/* switch */
	  }
	  while( entry.action != SHIFT && entry.action != SHIFT_NT );
	  
	  Get_ttabentry( entry, stack[sp], term );
	  
	  if( entry.action == SHIFT || entry.action == SHIFTRED )
	  	return( ON );
	  else
	  	return( OFF );
	  	
      }/* rst_beh_sepa */
      
      
static short errorsymb( stack, sp, term )

       short       *stack,  /* startaddress of the parserstack  */
       	            sp,     /* stackpointer of the parserstack  */
       	            term;   /* sxcode of a terminalsymbol       */
       	      
/*
 *  errorsymb returns the syntaxcode of the terminal from which the error-
 *  continuation is constructed. The returned value is Contaut(stack[sp])
 *  in the normal-case or Sepasymb(l), if list-separator with index l can be
 *  inserted and a restart with the current terminal is possible.
 *
 ***/
          
      {  tabentry  entry;            /* contains the entry of a parse-table  */
         short     hterm;            /* contains the error-symbol from the   */
         			     /* continuation-automaton               */
         register  int   i, j, k, l; /* indices for parse-table-access       */
         
         
         hterm = Contaut(stack[sp]);

         for( l = 0; l < NUOFSEPAS; l++ )  {
                
                if( Sepasymb(l) == hterm )
                	continue;
         
         	Get_ttabentry( entry, stack[sp], Sepasymb(l) );
         	
         	/* test if insertion of the current separator is possible */
         	if( entry.action != SHIFT  &&  entry.action != SHIFTRED )
         		continue;
         	
         	/* test if restart behind this separator is possible */
         	switch( rst_beh_sepa( stack, sp, entry, term ) ) {
         	
         	  case ON    :  /* restart possible */
         	                rstinf.mode   = RST_BEH_SEPA;
         		        rstinf.state  = stack[sp];
         		        rstinf.term   = Sepasymb(l);
         		        return( Sepasymb(l) );
         		   
         	  case OFF   :  /* restart not possible */
         	  		break;
         	 
         	  case FULL  :  /* stack overflow */
         	                rstinf.mode = FULL;
         	 	        return( hterm );
         	 	       
                  default    :  /* internal error */
                                rstinf.mode = FAULT;
                  		return( hterm );
                  
               }/* switch */
         	
         }/* for l */
         
         return( hterm );    		
         	 	
      }/* errorsymb */


#endif  		
	      

static char reachable( stack, sp, term )

	short  *stack, /* startaddress of the parse-stack        */
	        sp,    /* stackpointer of the parse-stack        */
	        term;  /* current terminal read from the scanner */ 
	       
/*
 *  reachable tries to accept the terminal coded in term while constructing the
 *  error-continuation with a copy of the parse-stack stack. The result of
 *  reachable is :
 *  -FAULT,   if wrong parse-tables are detected,
 *  -FULL,    if the parse-stack-copy has overflown,
 *  -FAIL,    if the current terminal term can't be accepted,
 *  -REACHED, if the current terminal term can be accepted.
 *
 ***/

      {  short hstack[STACKSIZE], /* contains the copy of stack	 	   */
      
               hsp;	          /* the stackpointer for hstack     	   */
         tabentry entry;          /* contains the entry of a parse-table   */
         char  halt  = OFF,       /* marks the end of error-continuation   */
               found = FAIL;      /*  = ON, if *term is acceptable         */
         short pstate,		  /* contains the code of a state	   */
               hterm,		  /* contains the syntaxcode of a terminal */
               rule;		  /* contains a productioncode		   */
         register int  i, j, k;   /* indices for parse-table access        */
         
          
	 /* make a copy of the parse-stack */
	 Copy_stack_to_hstack;
	 
	 entry.action  = SHIFT_NT;
	 entry.operand = hstack[hsp--];
	 
	 do  {
	    
	    if( ++hsp == STACKSIZE )
	    	  return( FULL );
	    
	    switch( entry.action )  {
	       
	       case SHIFT    :
	       case SHIFTRED :  halt = ( !(Is_brac(term)) && Is_brac(hterm) );
	       			break;
	       			
	       case REDUCE   :  hsp--;
	       			break;
	       			
	       case ACCEPT   :
	       case SHIFT_NT :
	       case SHRED_NT :
	       case ERROR    :
	       default       :  break;
	       			
	    }/* switch1 */
	    
	    switch( entry.action )  {
	    
	       case SHIFT    :
	       case SHIFT_NT :  /* try to accept term */
	       			hstack[hsp] = pstate = entry.operand;
	       			Get_ttabentry( entry, pstate, term );
	       			
	       			if( entry.action == SHIFT    ||
	       			    entry.action == SHIFTRED    )  {
	       			    /* term is directly acceptable */
	       			    found = REACHED;
	       			    halt  = ON;
	       			}
	       			else  { /* term is not directly acceptable */
	       			
	       			   hterm =
#ifdef NUOFSEPAS /* compilation of errorsymb only */
                 /* if listseparators are present */
	       			            errorsymb(  hstack, hsp, term );
#else
                                            Contaut(hstack[hsp]);
#endif
	       			   switch( rstinf.mode )  {
	       			    
	       			    case NORMAL       :/* continuation -   */
	       			      	               /* automaton-symbol */
	       			      		       /* inserted         */
	       			      			  Get_ttabentry(
	       			      			                 entry, 
	       			      			                 pstate,
	       			      			                 hterm 
	       			      			               );
	       			      		          break;
	       			      
	       		            case RST_BEH_SEPA :/* restart behind a */
	       		            	               /* list-separator   */
	       		                                  halt  = ON;
	       			      		          found = REACHED;
	       			      			  break;
	       	       			      			     
	       			    case FULL        :/*  stack overflow   */
	       			                          halt  = ON;
	       			      			  found = FULL;
	       			      			  break;
	       			      			  
	       			    default          :/*  internal error   */
	       			    		          halt  = ON;
	       			    		          found = FAULT;
	       			    		          break;
	       			   }/* switch */
	       			}
	       			break;
	       			
	       case REDUCE   :
	       case SHIFTRED :
	       case SHRED_NT :  rule = entry.operand;
	       			Dec_spbyrulelen( hsp, rule );
	       			Get_ntabentry(
	       			               entry, 
	       				       hstack[hsp],
	       				       Get_lhsnt(rule) 
	       				     );
	       			break;
	       			
	       case ACCEPT   :  break;
	       
	       case ERROR    :
	       default       :  halt  = ON;
	       			found = FAULT;
	       			break;
	       			
	    }/* switch2 */
	    
	 }
	 while( ! halt && entry.action != ACCEPT );
	 return( found );
	 
      }/* reachable */

/******************************* PUBLIC FUNCTION ******************************/

void parsercore( )
      
      {  short  stack[STACKSIZE];  /* parse-stack  for normal parsing         */
	 register short *sp=stack, /* stackpointer for normal parsing         */
	                *stackupbd = stack + STACKSIZE,
	                term;      /* the sxcode of the current terminal      */
	                           /* upper bound for the parserstack         */
	 short          hterm,     /* contains the sxcode of a terminal       */
	                rstpt;     /* keeps the sxcode of the restart-point   */
	 tabentry       entry;     /* contains the entry of a parse-table     */
	 short          pstate;    /* contains the code of a state 	      */
	 register short rule;      /* contains the code of a production       */
	 char           halt = OFF;/* marks the end of error-recovery         */
	 register htype i, j, k;   /* indices for parse-table-access          */

           /*=================================================================*/
           /*==========================             ==========================*/
           /*========================== NORMALPARSE ==========================*/
           /*==========================             ==========================*/
           /*=================================================================*/
           
           Init_parser( ); 
           /* Initializes the invisible parts of the parser-module */
       
	  stack[1] = 0;  
	  gettok( &token );
	  term = selectsxcode( token );  

    L_1  : /* get an entry from the terminal-table */
           Get_ttabentry( entry, *sp, term );
           	 
    L_2  : /* execute the next parseraction  */
    	   switch( entry.action )  {
    	     
    	     case SHIFT	   :  /* operand is the new current state  */
    	                      N_READ( term );
    	     case SHIFT_NT :  if( ++sp == stackupbd ) SF_ERROR( );
    	     		      *sp = entry.operand;
    	     		      goto L_1;
    	     		          	     		      
    	     case SHIFTRED :  /* operand is the rule which is reduced */
    	                      N_READ( term );
    	     case SHRED_NT :  sp++;
	     case REDUCE   :  rule = entry.operand;
			      Dec_spbyrulelen( sp, rule );
			      Get_ntabentry( entry, *sp, Get_lhsnt(rule));
			      if( Is_conn( rule ) ) USER( Conn_code( rule ) );
			      goto L_2;
	     		      
	     case ACCEPT   :  /* input is accepted, make a         */
	     		      /* reduction for the startproduction */
	     		      if( Is_conn( STPROD ) ) USER( Conn_code(STPROD) );
	     		      ACCEPTAC( );
	     		      
	     		      
	     case ERROR    :  /* a syntaxerror was detected */
	     		      SX_ERROR( );
	     		      break;
	     		      
	     default       :  /* not a legal action */
	     		      PT_ERROR( );
	     		      
	   }/* switch */ 
	   
	   /*=================================================================*/
	   /*========================                =========================*/
	   /*======================== ERROR-RECOVERY =========================*/
	   /*========================                =========================*/
	   /*=================================================================*/
	   
    	   /* skip symbols which are not feasible as anchors */
    	   /* stop if the EOF-Symbol is recognized           */
   L_3  :  if( ! Is_skip( term ) || term == PAEOF ) goto L_5;
   L_4  :  E_READ( term );
    	   goto L_3;
	 
	   /*******************************************************************/
	   /*								      */
	   /* test, if the current terminal is acceptable by the error-conti- */
	   /* nuation. To continue parsing use a copy of the parser-stack.    */
	   /*								      */
	   /*******************************************************************/
	   
   L_5  : switch( term == PAEOF ? 
                   REACHED : reachable( stack, sp - stack, term ) )  {
	   
	   	case REACHED:  /* the current terminal is acceptable     */
	   		       KEEP( );
	   		       rstpt = term;
	   		       break;
	   	
	   	case FAIL   :  /* the current terminal is not acceptable */
	   		       goto L_4;
	   		       
	   	case FULL   :  /* the parserstack for error-recovery    */
	   		       /* has overflown			        */
	   		       SF_ERROR( );
	   		       
	   	case FAULT  :  /* wrong parser-tables are detected      */
	   	default	    :  PT_ERROR( );
	   		       
	   }/* switch */
	   
           /*******************************************************************/
           /*								      */
           /* Now the restart-point  is  saved  in  variable  rstpt.          */
           /* Generate the continuation with the original parse-stack and     */
           /* while constructing the error-continuation make connections for  */
           /* error-tokens and productions if necessary. 	              */
           /*								      */
           /*******************************************************************/
           
           entry.action  = SHIFT_NT;
           entry.operand = *(sp--);
           halt	         = OFF;
	    
    	     
	   do  {
	   
	   	if( ++sp - stack == STACKSIZE ) SF_ERROR( );
	   		  
                switch( entry.action )  {
               
	       	   case SHIFT     :
		   case SHIFTRED  : /* generate an error-token */
				     GENERATE( hterm );
				     break;
					  
		   case REDUCE   :   sp--;
				     break;
					  
		   case ACCEPT   :
		   case SHIFT_NT :
		   case SHRED_NT :   break;
			
		   case ERROR    :
		   default       :   PT_ERROR( );
				     
	        }/* switch1 */
		
		switch( entry.action )  {
		
		   case SHIFT    :
		   case SHIFT_NT :  *sp = pstate = entry.operand;					 
				    /* test if the restart-point */
			            /* is directly acceptable    */
			            Get_ttabentry( entry, pstate, rstpt );
				    if( entry.action == SHIFT  ||
					entry.action == SHIFTRED )
				           /* is directly acceptable     */
					   halt = ON;
				    else {/* is not directly acceptable */
#ifdef NUOFSEPAS /* compilation only if listseparators are present */
				          if( rstinf.mode  == RST_BEH_SEPA &&
				              rstinf.state == pstate )  {
				                  /* restart behind a  */
				                  /* list-separator    */
				                  hterm       = rstinf.term;
				                  rstinf.mode = NORMAL;
				           }
				           else
#endif
				            	  hterm = Contaut(pstate);
				            	  
				                  Get_ttabentry( 
				                                 entry,
				                                 pstate,
				                                 hterm 
				                               );
				    }
				    break;
				    
		   case REDUCE   :
		   case SHIFTRED :
		   case SHRED_NT :  rule = entry.operand;
		   	            Dec_spbyrulelen( sp, rule );
		   	            Get_ntabentry( 
		   	                           entry,
		   	                          *sp, 
		   	                           Get_lhsnt(rule) 
		   	                         );
		   	            if( Is_conn( rule ) )
		   	           	 USER( Conn_code( rule ) );
		   	            break;
		   	            
		   case ACCEPT   :  break;
		   
		   case ERROR    :
		   default       :  PT_ERROR( );
		   		    
		}/* switch2 */
    	   }
    	   while( ! halt  &&  entry.action != ACCEPT );
    	   
    	   /* return to normal parsing  */
    	   /* restore the restart-point */
    	   term = rstpt;
    	   CONTINUE( );
    	   goto L_2;
    	    
      }/* parsercore */
