/*
** $Id: errandio.h,v 1.2 90/10/23 14:41:24 cogito Exp $
*/

/***********************************************************************
 **
 **   Filename  :  errandio.h
 **
 **   Author    :  Ursula Stellmacher
 **
 **   Date      :  12.11.88
 **
 **   Last change:  12.11.88
 **
 **   Task       : Declaration of constants, types and functions for 
 **                input and output and for errorhandling
 **
 **********************************************************************/

/***********************************************************************
 **  constants
 **********************************************************************/

#define 	WRITE			"w"
#define   	READ			"r"

#define         S_EMPTY                  2

#define         CONNECT                  1
#define         REDUCEMOD                2
#define         NOREDUCEMOD              3 

#define         PRIVATE                  static
#define         PUBLIC


/***********************************************************************
 **  errorconstants
 **********************************************************************/

#define		FOPENERR		1
#define		PGRCALLERR		2
#define         READERROR               3
#define         WRITEERROR              4
#define         LHSPROD                 5
#define         LHSDEFTAB               6
#define         LHSSYMTAB               7
#define         RHSSYMTAB               8
#define         RHSOTHER                9
#define         INPUTERROR             10


/***************************************************************
 **  types
 ***************************************************************/

typedef unsigned int BOOL;


/***************************************************************
 ** funktions
 ***************************************************************/

/***********************************************************************
 **
 **   Function   :  error_messsage
 **
 **   Task       :  output of an errormessage and exit(0)
 **
 **********************************************************************/
extern void error_message ( /* short error_code, char *function, 
			       char *s1, char *s2 */ );

/***********************************************************************
 **
 **   Function   :  dat_open
 **
 **   Task       :  fileopening with the modus READ/WRITE
 **
 **   Return     :  FILE*
 **
 **********************************************************************/
extern FILE *dat_open ( /* char *dat_name, char *mode */ );
