/*
** $Id: cmr2pgs.c,v 1.1 91/02/01 16:52:30 cogito Exp $
*/
static char rcs_id[]= "$Id: cmr2pgs.c,v 1.1 91/02/01 16:52:30 cogito Exp $";

/***********************************************************************
 **
 **   File       :  formatter.c
 **
 **   Author     :  Ursula Stellamcher
 **
 **   Date       :  05.09.88
 **
 **   Last change:  12.11.88
 **
 **   Import     :  #include <stdio.h>
 **                 #include "comar.h"
 **                 #include "format.h"
 **                 #include "errandio.h"
 **
 **   Functions  :  ( extern )
 **                 dat_open 
 **                 error_messages
 **                 print_prodname
 **                 get_sid_of_lhs
 **                 get_sid_of_nterm_or_term
 **                 print_nterm_of_lhs
 **                 print_lhs_of_prod
 **                 print_nterm_or_term_of_rhs
 **                 get_kind_of_other
 **                 print_connect
 **                 print_others_of_rhs
 **                 print_rhs_of_prod
 **                 print_grammar
 ** 
 **
 **   Task       : Formatter for grammars in a readable form, which are in 
 **                an external representation of COMAR.
 **
 **
 **********************************************************************/

/***********************************************************************
 **  Includes (Standard)
 **********************************************************************/

#include <stdio.h>

/***********************************************************************
 **  Includes (Extended)
 **********************************************************************/

#include "comar.h"

#include "errandio.h"
#include "format.h"




/***********************************************************************
 **                       M A I N
 **********************************************************************/

/***********************************************************************
**  Function   : MAIN
**
**  Task       : Call of the program formatter.c
**
**  Return     : void
**
**********************************************************************/


void main( argc, argv )

int         argc;
char       *argv[];
{

       FILE        *fin_ptr,
		   *fout_ptr;
       
       char        input_filename[64],  
                   output_filename[64];                      
       p_comar     root;


       if ( argv[1] == NULL )
       {
           /*
            * error message and exit
            */
           error_message ( PGRCALLERR, "main", NULL, NULL );
       }


      /*
       *  open the inputfile
       */
   

       sprintf ( input_filename, "%s", argv[1] );    
       fin_ptr = dat_open ( input_filename, READ );
        
      /*
       *  construction of the outputfilename and fileopening
       */
			
		     
       sprintf ( output_filename, "%s.fmt", argv[1] );
       fout_ptr = dat_open ( output_filename, WRITE );
					 
					 
      /*
       *  reading the COMAR inputfile
       */
       
       
       if ( ( root = INPUT(fin_ptr) ) != NULL )
       {
             
      
         /*
          *   formatting the grammar
          */
    
	  print_grammar( root , fout_ptr );

       }
       else
       {
	  error_message( INPUTERROR , main , NULL , NULL );
       }

        fclose ( fin_ptr );
        fclose ( fout_ptr );
        

} /* end of main */


/******************** E N D  O F  F I L E  *********************************/
