static char RCSid[] = "$Id: dbhdr.c,v 1.4 89/10/20 13:18:11 waite Exp $";
/* Copyright, 1989, The Regents of the University of Colorado */

/*
 * dbhdr.c: Prepended to tool-generated file db.c (DML functions)
 */

#include "dbconst.h"	/* constants for object types, attributes, etc */
#include "dbtypes.h"	/* data base implementation types */
#include "dbgen.h"	/* declarations of generic database access functions */

/*LINTLIBRARY*/

/* -------------------------- End of dbhdr.c ------------------------------ */

/*
 * Function Definitions
 */
char *GetValue(key, deflt)
   tKey *key;
   char *deflt;
{
   dbAtVal arg;
   arg.pval = deflt;
   return dbGetAttribute(key, db_at_Value,arg);
}
char *SetValue(key, added, changed)
   tKey *key;
   char *added, *changed;
{
   dbAtVal addarg, chgarg, result;
   addarg.pval = added; chgarg.pval = changed;
   return dbSetAttribute(key, db_at_Value,addarg,chgarg);
}

char *GetName(key, deflt)
   tKey *key;
   char *deflt;
{
   dbAtVal arg;
   arg.pval = deflt;
   return dbGetAttribute(key, db_at_Name,arg);
}
char *SetName(key, added, changed)
   tKey *key;
   char *added, *changed;
{
   dbAtVal addarg, chgarg, result;
   addarg.pval = added; chgarg.pval = changed;
   return dbSetAttribute(key, db_at_Name,addarg,chgarg);
}

int dbAdd2(
   relId,
   roleId1, key1,
   roleId2, key2
)
   int relId;
   int roleId1, roleId2;
   tKey *key1, *key2;
{
   return dbAddTuple(
      2, 
      relId,
      roleId1, roleId2,
      key1, key2
   );
}

int dbDelete2(
   relId,
   roleId1, key1,
   roleId2, key2
)
   int relId;
   int roleId1, roleId2;
   tKey *key1, *key2;
{
   return dbDeleteTuple(
      2, 
      relId,
      roleId1, roleId2,
      key1, key2
   );
}

