/*
** $Id: privlib.c,v 1.2 90/10/23 14:43:25 cogito Exp $
*/
static char rcs_id[]= "$Id: privlib.c,v 1.2 90/10/23 14:43:25 cogito Exp $";

#include "ccomar.h"
#include "ccomarl.h"
#include "privlib.h"


boolean cmrl_val_list_equal(list1, list2)
tCOMAR *list1, *list2;
{
#ifdef DBUG
  printf("cmrl_val_list_equal startet.");
#endif

  if (list1 == (tCOMAR *)NULL)
      return(list2 == (tCOMAR *)NULL);

  else if (list2 == (tCOMAR *)NULL)
      return(FALSE);

  return(cmrl_val_subtr_equal(cmr_list_head(list1),
                              cmr_list_head(list2))
			     &&
         cmrl_val_list_equal(cmr_list_tail(list1),
                             cmr_list_tail(list2)));
}


boolean cmrl_val_subtr_equal(subtr1, subtr2)
tCOMAR *subtr1, *subtr2;
{
int tag;

#ifdef DBUG
  printf("cmrl_val_subtr_equal startet.");
#endif

  if (subtr1 == (tCOMAR *)NULL)
      return(subtr2 == (tCOMAR *)NULL); 

  else if (subtr2 == (tCOMAR *)NULL)
      return(FALSE);

  if ((tag = cmr_get_tag(subtr1)) != cmr_get_tag(subtr2))
       return(FALSE);

  switch (tag) {

  case P_NVAL   : return(cmr_get_nval_val(subtr1) ==
                         cmr_get_nval_val(subtr2));

  case P_DVAL   : return(cmr_get_dval_did(subtr1) ==
                         cmr_get_dval_did(subtr2));

  case P_SVAL   : return(cmr_get_sval_sid(subtr1) ==
                         cmr_get_sval_sid(subtr2));

  case P_LVAL   : return(cmrl_val_list_equal(
                             cmr_get_lval_list(subtr1),
			     cmr_get_lval_list(subtr2)));

  default       : return(FALSE);

  }               /* of switch */
}                 /* of cmrl_val_subtr_equal */


tCOMAR *cmrl_get_dval_in_val_list(list, did)
tCOMAR *list;
DID did;
{
tCOMAR *result;

#ifdef DBUG
  printf("cmrl_get_dval_in_val_list startet.");
#endif

  if (list == (tCOMAR *)NULL) return((tCOMAR *)NULL);

  result = cmrl_get_dval_in_val_subtr(cmr_list_head(list), did);

  if (result != (tCOMAR *)NULL) return(result);

  return(cmrl_get_dval_in_val_list(cmr_list_tail(list), did));
}


tCOMAR *cmrl_get_dval_in_val_subtr(subtr, did)
tCOMAR *subtr;
DID did;
{
#ifdef DBUG
  printf("cmrl_get_dval_in_val_subtr startet.");
#endif

  if (subtr == (tCOMAR *)NULL) return((tCOMAR *)NULL);

  switch (cmr_get_tag(subtr)) {

  case P_LVAL   : return(cmrl_get_dval_in_val_list(cmr_get_lval_list(subtr), did));

  case P_DVAL   : if (cmr_get_dval_did(subtr) == did)
		     return(subtr);
                  return((tCOMAR *)NULL);

  default       : return((tCOMAR *)NULL);

  }              /* of switch */
}                /* of cmrl_get_dval_in_val_subtr */


tCOMAR *cmrl_get_sval_in_val_list(list, sid)
tCOMAR *list;
SID sid;
{
tCOMAR *result;

#ifdef DBUG
  printf("cmrl_get_sval_in_val_list startet.");
#endif

  if (list == (tCOMAR *)NULL) return((tCOMAR *)NULL);

  result = cmrl_get_sval_in_val_subtr(cmr_list_head(list), sid);

  if (result != (tCOMAR *)NULL) return(result);

  return(cmrl_get_sval_in_val_list(cmr_list_tail(list), sid));
}


tCOMAR *cmrl_get_sval_in_val_subtr(subtr, sid)
tCOMAR *subtr;
SID sid;
{
#ifdef DBUG
  printf("cmrl_get_sval_in_val_subtr startet.");
#endif

  if (subtr == (tCOMAR *)NULL) return((tCOMAR *)NULL);

  switch (cmr_get_tag(subtr)) {

  case P_LVAL   : return(cmrl_get_sval_in_val_list(cmr_get_lval_list(subtr), sid));

  case P_SVAL   : if (cmr_get_sval_sid(subtr) == sid)
		     return(subtr);
                  return((tCOMAR *)NULL);

  default       : return((tCOMAR *)NULL);

  }              /* of switch */
}                /* of cmrl_get_sval_in_val_subtr */


tCOMAR *cmrl_get_nval_in_val_list(list, val)
tCOMAR *list;
int val;
{
tCOMAR *result;

#ifdef DBUG
  printf("cmrl_get_nval_in_val_list startet.");
#endif

  if (list == (tCOMAR *)NULL) return((tCOMAR *)NULL);

  result = cmrl_get_nval_in_val_subtr(cmr_list_head(list), val);

  if (result != (tCOMAR *)NULL) return(result);

  return(cmrl_get_nval_in_val_list(cmr_list_tail(list), val));
}


tCOMAR *cmrl_get_nval_in_val_subtr(subtr, val)
tCOMAR *subtr;
int val;
{
#ifdef DBUG
  printf("cmrl_get_nval_in_val_subtr startet.");
#endif

  if (subtr == (tCOMAR *)NULL) return((tCOMAR *)NULL);

  switch (cmr_get_tag(subtr)) {

  case P_LVAL   : return(cmrl_get_nval_in_val_list(cmr_get_lval_list(subtr), val));

  case P_NVAL   : if (cmr_get_nval_val(subtr) == val)
		     return(subtr);
                  return((tCOMAR *)NULL);

  default       : return((tCOMAR *)NULL);

  }              /* of switch */
}                /* of cmrl_get_dval_in_val_subtr */


/* cmrl_get_elem_in_list - works recursively on a list and its subtrees */
tCOMAR *cmrl_get_elem_in_list(list, elem)
tCOMAR *list;
DID elem;
{
tCOMAR *result;

#ifdef DBUG
  printf("cmrl_get_elem_in_list startet.");
#endif

  if (list == (tCOMAR *)NULL)
    return((tCOMAR *)NULL);

  if ((result = cmrl_get_elem_in_subtr(cmr_list_head(list), elem))
	!= (tCOMAR *)NULL)
	     return(result);

  return(cmrl_get_elem_in_list(cmr_list_tail(list), elem));
}


/* cmrl_get_elem_in_subtr - works recursively on a subtree */
tCOMAR *cmrl_get_elem_in_subtr(subtr, elem)
tCOMAR *subtr;
DID elem;
{
tCOMAR *result;

#ifdef DBUG
  printf("cmrl_get_elem_in_subtr startet.");
#endif

  if (subtr == (tCOMAR *)NULL) return((tCOMAR *)NULL);

  switch (cmr_get_tag(subtr)) {

  case P_ALT  :  result = cmrl_get_elem_in_list(cmr_get_alt_units1(subtr), elem);
		 if (result != (tCOMAR *)NULL)
		   return(result);

                 return(cmrl_get_elem_in_list(cmr_get_alt_units2(subtr), elem));

  case P_OPT  :  return(cmrl_get_elem_in_list(cmr_get_opt_units(subtr), elem));

  case P_PLUS :  return(cmrl_get_elem_in_list(cmr_get_plus_units(subtr), elem)); 

  case P_STAR :  return(cmrl_get_elem_in_list(cmr_get_star_units(subtr), elem));  

  case P_DELREP :
		 result = cmrl_get_elem_in_list(cmr_get_delrep_units1(subtr), elem);
                 if (result != (tCOMAR *)NULL)
		   return(result);

                 return(cmrl_get_elem_in_list(cmr_get_delrep_units2(subtr), elem));

  case P_ELUNIT :
		 if (cmr_get_elunit_elem(subtr) == elem)
		   return(subtr);

                 return((tCOMAR *)NULL);

  default       :
		 return((tCOMAR *)NULL);

  }
}


/* cmrl_item_in_list - returns TRUE iff item addressed by item
 *                     is direct member of list */
boolean cmrl_item_in_list(list, item)
tCOMAR *list, *item;
{
#ifdef DBUG
  printf("cmrl_item_in_list startet.");
#endif

  if (list == (tCOMAR *)NULL)
    return(FALSE);

  if (cmr_list_head(list) == item)
    return(TRUE);

  return(cmrl_item_in_list(cmr_list_tail(list), item));
}


/* cmrl_item_in_subtr - returns TRUE iff item addressed by item
 *                      is a direct member of subtree lists */
boolean cmrl_item_in_subtr(subtr, item)
tCOMAR *subtr, *item;
{
#ifdef DBUG
  printf("cmrl_item_in_subtr startet.");
#endif

  if (subtr == (tCOMAR *)NULL)
    return(FALSE);

  switch (cmr_get_tag(subtr))
  {
    case P_ALT  : 
	       if (cmrl_item_in_list(cmr_get_alt_units1(subtr), item))
		 return(TRUE);

               if (cmrl_item_in_list(cmr_get_alt_units2(subtr), item))
		 return(TRUE);

               return(FALSE);

    case P_OPT  : 
	       return(cmrl_item_in_list(cmr_get_opt_units(subtr), item));

    case P_PLUS :   
	       return(cmrl_item_in_list(cmr_get_plus_units(subtr), item));

    case P_STAR :   
	       return(cmrl_item_in_list(cmr_get_star_units(subtr), item));

    case P_ELUNIT : 
	       return(FALSE);

    case P_DELREP : 
	       if (cmrl_item_in_list(cmr_get_delrep_units1(subtr), item))
		 return(TRUE);

               if (cmrl_item_in_list(cmr_get_delrep_units2(subtr), item))
		 return(TRUE);

               return(FALSE);

    default  : return(FALSE);
  }
}


tCOMAR *cmrl_first_rule_item_in_dlist(c, dlist)
tCOMAR *c, *dlist;
{
  tCOMAR *q;
  
#ifdef DBUG
  printf("cmrl_first_rule_item_in_dlist startet.");
#endif

  for (q = cmr_get_begin_list(dlist);
       q != (tCOMAR *)NULL;
       q = cmr_list_tail(q))
  {
    tCOMAR *head = cmr_list_head(q);

    if (cmr_get_tag(head) == P_ELUNIT)
    {
      int tag;
      DID elem = cmr_get_elunit_elem(head);

      if ((tag = cmr_get_def_entry_tag(c, elem)) == P_TERM ||
          tag == P_NTERM)
	return(head);
    }
    else
      return(head);
  }

  return((tCOMAR *)NULL);
}


tCOMAR *cmrl_next_rule_item_in_dlist(c, dlist, item)
tCOMAR *c, *dlist, *item;
{
  tCOMAR *q;
  boolean found = FALSE;

#ifdef DBUG
  printf("cmrl_next_rule_item_in_dlist startet.");
#endif

  for (q = cmr_get_begin_list(dlist); 
       q != (tCOMAR *)NULL;
       q = cmr_list_tail(q))
  {
    tCOMAR *head = cmr_list_head(q);

    if (!found)
    {
      if (head == item)
      {
        found = TRUE;
      }
    }
    else 
    {
      if (cmr_get_tag(head) == P_ELUNIT)
      {
	int tag;
	DID elem = cmr_get_elunit_elem(head);

	if ((tag = cmr_get_def_entry_tag(c, elem)) == P_TERM ||
	     tag == P_NTERM)
	  return(head);
      }
      else
	return(head);
    }
  }        /* of for */

  return((tCOMAR *)NULL);
}


tCOMAR *cmrl_first_other_item_in_dlist(c, dlist)
tCOMAR *c, *dlist;
{
  tCOMAR *q;
  
#ifdef DBUG
  printf("cmrl_first_other_item_in_dlist startet.");
#endif

  for (q = cmr_get_begin_list(dlist);
       q != (tCOMAR *)NULL;
       q = cmr_list_tail(q))
  {
    tCOMAR *head = cmr_list_head(q);

    if (cmr_get_tag(head) == P_ELUNIT &&
        cmr_get_def_entry_tag(c, cmr_get_elunit_elem(head)) == P_OTHER)
      return(head);
  }

  return((tCOMAR *)NULL);
}


tCOMAR *cmrl_next_other_item_in_dlist(c, dlist, item)
tCOMAR *c, *dlist, *item;
{
  tCOMAR *q;
  boolean found = FALSE;

#ifdef DBUG
  printf("cmrl_next_other_item_in_dlist startet.");
#endif

  for (q = cmr_get_begin_list(dlist);
       q != (tCOMAR *)NULL;
       q = cmr_list_tail(q))
  {
    tCOMAR *head = cmr_list_head(q);

    if (head == item)
    {
      found = TRUE;
      continue;
    }

    if (found &&
	cmr_get_tag(head) == P_ELUNIT &&
	cmr_get_def_entry_tag(c, cmr_get_elunit_elem(head)) == P_OTHER)
      return(head);
  }

  return((tCOMAR *)NULL);
}
        


tCOMAR *cmrl_first_item_in_dlist(dlist)
tCOMAR *dlist;
{
#ifdef DBUG
  printf("cmrl_first_item_in_dlist startet.");
#endif

  return(cmr_list_head(cmr_get_begin_list(dlist)));
}


tCOMAR *cmrl_next_item_in_dlist(dlist, item)
tCOMAR *dlist, *item;
{
  tCOMAR *q;
  boolean found = FALSE;

#ifdef DBUG
  printf("cmrl_next_item_in_dlist startet.");
#endif

  for (q = cmr_get_begin_list(dlist);
       q != (tCOMAR *)NULL && !found;
       q = cmr_list_tail(q))
    if (cmr_list_head(q) == item)
      found = TRUE;

  /* q denotes now the list element to which item belongs 
   * or is (tCOMAR *)NULL */

  if (q == (tCOMAR *)NULL)
    return((tCOMAR *)NULL);

  if ((q = cmr_list_tail(q)) == (tCOMAR *)NULL)
    return((tCOMAR *)NULL);

  return(cmr_list_head(q));
}


/* cmrl_del_eps_in_dlist - deletes epsilon if it belongs to dlist and length of
 *               dlist is greater than 1, returns dlist  */
tCOMAR *cmrl_del_eps_in_dlist(c, dlist)
tCOMAR *c, **dlist;
/* parameter 'dlist' changed by Kalle to "call-by-reference"  */

{
  tCOMAR *epsptr;

#ifdef DBUG
  printf("cmrl_del_eps_in_dlist startet.");
#endif

  if (cmrl_dlist_len(*dlist) > 1 &&
      (epsptr = cmrl_first_rule_item_in_dlist(c, *dlist)) != (tCOMAR *)NULL &&
      cmr_get_tag(epsptr) == P_ELUNIT &&
      cmr_get_elunit_elem(epsptr) == cmrl_get_eps_did(c))
    (void) cmrl_dlist_delitem(*dlist, epsptr);
 
  return(*dlist);
}


/* cmrl_subst_item_by_ruletree - substitutes item in dlist by ruletree
 *                               ruletree == delimited list */
int cmrl_subst_item_by_ruletree(dlist, item, ruletree)
tCOMAR **dlist, *item, *ruletree;
/* parameter 'dlist' changed by Kalle to "call-by-reference"  */

{
#ifdef DBUG
  printf("cmrl_subst_item_by_ruletree startet.");
#endif

  if (cmrl_item_in_list(cmr_get_begin_list(*dlist), item))
  {
    if (cmrl_splice_dlists(ruletree, *dlist, item) != *dlist)
      return(CMR_UNKERR);
  
    (void) cmrl_dlist_delitem(*dlist, item);

    return(CMR_SUCCESS);
  }

  return(CMR_UNKERR);
}
      

/* cmrl_del_val_in_val_subtr - searches recursively a specified item and deletes 
 *                            it from the subtr 
 */
tCOMAR *cmrl_del_val_in_val_subtr(subtr, p)
tCOMAR *subtr, *p;
{
  tCOMAR *head;

#ifdef DBUG
  printf("cmrl_del_val_in_val_subtr startet.");
#endif

  switch (cmr_get_tag(subtr))
  {
    case P_LVAL :
	head = cmr_get_lval_list(subtr);
	if (cmrl_del_val_in_val_list(head, p) != head)
	  return((tCOMAR *)NULL);
        break;

    case P_NVAL :
    case P_DVAL :
    case P_SVAL :
	break;

    default  :
	return((tCOMAR *)NULL);
  }

  return(subtr);
}

/* cmrl_del_val_in_val_list - returns a list in which the specified item p
 *                            was deleted recursively
 */
tCOMAR *cmrl_del_val_in_val_list(list, p)
tCOMAR *list, *p;
{
  tCOMAR *next;

#ifdef DBUG
  printf("cmrl_del_val_in_val_list startet.");
#endif

  if (cmr_isempty_list(list))
    return(list);

  if (cmrl_item_in_list(list, p))
    return(cmr_list_delitem(list,p));

  if (cmrl_del_val_in_val_subtr(cmr_list_head(list), p) == (tCOMAR *)NULL)
    return((tCOMAR *)NULL);
  
  next = cmr_list_tail(list);
  if (cmrl_del_val_in_val_list(next, p) != next)
    return((tCOMAR *)NULL);

  return(list);
}

/* the header file of this module provides the errorcodes for
 * having more than one startsymbol or for getting no startsymbol
 */

/* cmrl_get_startsymbols - returns a list of elunits with startsymbols */
tCOMAR *cmrl_get_startsymbols(c)
tCOMAR *c;
{
DID nt;
DID prod;
tCOMAR *startsymbollist = cmr_new_list();

#ifdef DBUG
  printf("cmrl_get_startsymbols startet.");
#endif

  nt = cmrl_first_nterm(c);

  while (nt != -1)
  {
    boolean candidate = TRUE;

    prod = cmrl_first_prod(c);

    while (prod != -1 && candidate)
    {
      candidate = (cmrl_get_elem_in_list(cmr_get_prod_units(c, prod), nt)
		      == (tCOMAR *)NULL);
      prod = cmrl_next_prod(c, prod);
    }

    if (candidate)
      startsymbollist = cmr_cat_lists(startsymbollist,
				      cmr_add_to_list(cmr_new_list(),
                                                      cmr_new_elunit(nt)));

    nt = cmrl_next_nterm(c, nt);
  }

  return(startsymbollist);
}


boolean cmrl_otherdid_in_list(c, list, otherdid)
tCOMAR *c, *list;
DID otherdid;
{
  tCOMAR *head;
  DID elem;

#ifdef DBUG
  printf("cmrl_otherdid_in_list startet.");
#endif

  if (list == (tCOMAR *)NULL) return(FALSE);

  if (cmr_get_tag(head = cmr_list_head(list)) == P_ELUNIT &&
      cmr_get_def_entry_tag(c, elem = cmr_get_elunit_elem(head)) == P_OTHER)
  {
    if (elem == otherdid)
      return(TRUE);
    else
      return(cmrl_otherdid_in_list(c, cmr_list_tail(list), otherdid));
  }
  else
    return(FALSE);
}


boolean cmrl_otherdid_in_dlist(c, dlist, otherdid)
tCOMAR *c, *dlist;
DID otherdid;
{
#ifdef DBUG
  printf("cmrl_otherdid_in_dlist startet.");
#endif

 return(cmrl_otherdid_in_list(c, cmr_get_begin_list(dlist), otherdid));
}

