/*
** $Id: default.h,v 1.2 90/10/23 14:40:11 cogito Exp $
*/

#include "old_to_newcmr.h"

/* default.h - Module for determining a default rule for each
 *             Alternative in a production tree
 *             and a default rule for each Nonterminal
 */


/* Errorcode that will be returned if there is an Nonterminal
 * from which no terminal string can be derived
 */

#define CMRTL_NOTERMIN -30

/* The rule or the alternative that will be the default rule will
 * be marked by a node in the production tree.
 * The nodes that mark a default rule are put to the top of the 
 * production (sub-) list. All these nodes have a common did.
 * The did of the node represents a DEFTABLE-entry which is tagged
 * with P_OTHER. The sid of that DEFTABLE-entry is the index for
 * for the name "DEFAULT" in the symboltable.
 */

/* N O T E :
 * if someone wants to use a function other than
 * cmrtl_default_for_grammar then he should at first call
 * cmrtl_default_init
 */


#define DEFAULT     "default"
#define DEFAULTVAL  "defaultval"


/**************************************************************/
/*   Section 1: Functions for evaluating the defaultrules     */
/*              in a production tree                          */
/**************************************************************/

/* All the following three functions of section 1 get as input:
 * 1.  database c
 * 2.  a pointer to a boolean variable ready
 *     this variable indicates whether all neccessary defaults are set
 * 3.  a pointer to the special type of the given subtree.
 *
 * all functions return:
 * - 0 if this part of the production-subtree cannot yet be
 *        terminalized
 * - 1 if this productions-subtree can be terminalized
 * - CMR_UNKERR
 *     if any error occurs
 */

extern int cmrtl_default_on_dlist( /* tCOMAR *c, tCOMAR *dlist,
					 boolean *ready */ );

extern int cmrtl_default_on_list( /* tCOMAR *c, tCOMAR *list,
					boolean *ready */ );

extern int cmrtl_default_on_subtr( /* tCOMAR *c, tCOMAR *subtr,
					 boolean *ready */ );


/*************************************************************/

/* cmrtl_default_for_nterm - returns message if this nonterminal
 *                           can already be terminalized
 * on entry : database c
 *            DID nt, index for a nonterminal
 * on exit  : if any error occurs CMR_UNKERR
 *            if not yet found then it tries to find the 
 *               defaultrules for each production with left-hand-side
 *               nt
 *            returns CMR_SUCCESS
 */
extern int cmrtl_default_for_nterm( /* tCOMAR *c, DID nt */ );

/* cmrtl_default_init - initializes this module
 * on entry : database c
 * action   : sets all variables that are global to this
 *            module
 * on exit  : returns CMR_SUCCESS if everything is ok
 *              else CMR_UNKERR
 */
extern int cmrtl_default_init( /* tCOMAR *c */ );


/**************************************************************/
/*              M A I N   P R O C E D U R E                   */
/**************************************************************/

/* cmrtl_default_for_grammar - evaluates all defaultrules for
 *                                the given grammar
 * on entry : database c 
 * action   : tries to find a default-rule for each nonterminal
 *            and for each Alternative in the production trees
 *            if there are Nonterminals that cannot be terminalized
 *              then these ones will be written to stderr
 * on exit  : if there are nonterminals which cannot be 
 *             terminalized then NOTERMINALISATION
 *            if an error occurs then return errorcode
 *              else return CMR_SUCCESS
 */
extern int cmrtl_default_for_grammar( /* tCOMAR *c */ );


