/*
** $Id: ccomarf.c,v 1.3 90/11/14 10:24:52 cogito Exp Locker: cogito $
*/
static char rcs_id[]= "$Id: ccomarf.c,v 1.3 90/11/14 10:24:52 cogito Exp Locker: cogito $";

/* ccomarf.c - COMAR routines for formatted grammar output */

#include <stdio.h>

#include "ccomar.h"
#include "ccomarl.h"
#include "ccomarf.h"


#ifdef DEBUG
#define CMRF_PRTERR cmr_prterr()		/* redefine for dbx where */

int cmr_prterr()
{
    int t;

    t = DBG_PRTERR;
    return(t);
}
#endif


/* Private definitions: */

/*  Literals used by each grammar style (indexed by [stylecod] [litcode] where
 *  stylecode and litcode are defined constants. 
 */
static char *prlit[][4] =
{
    { "::=", "|", "||", "." },		/* EBNF */
    { ":",   "/", "//", "." },		/* PGS */
    { ":",   "?", "//", ""  },		/* ALA */
    { ":",   "|", "?",  ";" }		/* YACC */
};

/* and their lengths */
static int prlitlen[][4] =
{
    { 3, 1, 2, 1 },
    { 1, 1, 2, 1 },
    { 3, 1, 2, 0 },
    { 1, 1, 1, 1 }
};

/* Definitinos used by default other printing function: */ 
static SID cmrf_pgsconn_sid = -1;
static SID cmrf_pgsrmod_sid = -1;
static SID cmrf_pgsnrmod_sid = -1;

/* print newline and update l ( NOTE: 2 stmts, wrap in "{" "}" ) */
#define NEWLIN	fprintf(f,"\n%*s",indent,""); l=maxlin-indent;

/* Several formatting macros used by pr_list: */

/* print literal string, preceded by newline and indented if necessary */
#define PUTLIT(lc,ll)   if ((*l -= ll) < 0) \
	  		 {*l=maxlin-indent-ll; fprintf(f,"\n%*s",indent,lc);} \
			else fprintf(f,"%s",lc);

/* print space or start indented new line if no room (for space and 1 char) */
#define PUTSPACE if (--(*l) >= 2)  (void)fputc(' ', f); \
		 else { fprintf(f,"\n%*s",indent,""); *l=maxlin-indent; }



/* Recursively print subtree(s) of rhs of production. */
/* changed by Kalle: Elimination of P_Begin-mark in the switch-statement */
static int pr_subtr(f, c, t, l, sp, par, maxlin, indent, style)
FILE *f;
p_comar c;
pGenList  t; 
int *l;
Boolean sp,		/* T ==> print space AFTER printing this rhs */
	par;		/* T ==> wrap ALT construct in parentheses */
int maxlin, indent, style;
{
    int cmrf_pr_didsymb();
    p_comar p;

    if (cmr_isempty_list(t))
	return(CMR_SUCCESS);

    switch(cmr_get_tag(t))
    {
	case P_ALT:
	    if (par) { PUTLIT("(", 1) }
	    if (pr_list(f, c, cmr_get_alt_units1(t), l, FALSE, FALSE,
				maxlin, indent, style) == CMRF_PRTERR)
		return(CMRF_PRTERR);
	    { PUTSPACE }
	    { PUTLIT(prlit[style][FMT_ORT], prlitlen[style][FMT_ORT]) }
	    { PUTSPACE }
	    if (pr_list(f, c, cmr_get_alt_units2(t), l, FALSE, FALSE,
				maxlin, indent, style) == CMRF_PRTERR)
		return(CMRF_PRTERR);
	    if (par) { PUTLIT(")", 1) }
	    if (sp) { PUTSPACE }
	    break;
	case P_OPT:		/* always bracketed - par ignored */
	    { PUTLIT("[", 1) }
	    if (pr_list(f, c, cmr_get_opt_units(t), l, FALSE, FALSE,
				maxlin, indent, style) == CMRF_PRTERR)
		return(CMRF_PRTERR);
	    { PUTLIT("]", 1) }
	    if (sp) {PUTSPACE }
	    break;
	case P_PLUS:
	    {
	    int n;
	    SEQunit p;

	    if ((p = cmr_get_plus_units(t)) == (SEQunit)NULL)
		return(CMRF_PRTERR);

	    /* case (b): first(units) == P_ALT ==> parenthesize the ALT */
	    par = cmrl_dlist_firstis(p, P_ALT);

	    /* case (c): length(units) > 1 ==> parenthesize the PLUS */
	    if ((n = cmrl_dlist_len(p)) > 1)   
	    {
		{ PUTLIT("(", 1) }
		if (pr_list(f, c, p, l, FALSE, par,
				maxlin, indent, style) == CMRF_PRTERR)
		    return(CMRF_PRTERR);
		{ PUTLIT(")", 1) }
	    }
	    else if (n >= 0)
	    {
		if (pr_list(f, c, p, l, FALSE, par,
				maxlin, indent, style) == CMRF_PRTERR)
		    return(CMRF_PRTERR);
	    }
	    else
		return(CMRF_PRTERR);
	    { PUTLIT("+", 1) }
	    if (sp) { PUTSPACE }
	    break;
	    }
	case P_STAR:
	    {
	    int n;
	    SEQunit p;

	    if ((p = cmr_get_star_units(t)) == (SEQunit)NULL)
		return(CMRF_PRTERR);

	    /* case (b): first(units) == P_ALT ==> parenthesize the ALT */
	    par = cmrl_dlist_firstis(p, P_ALT);

	    /* case (c): length(units) > 1 ==> parenthesize the STAR */
	    if ((n = cmrl_dlist_len(p)) > 1)
	    {
		{ PUTLIT("(", 1) }
		if (pr_list(f, c, p, l, FALSE, par,
				maxlin, indent, style) == CMRF_PRTERR)
		    return(CMRF_PRTERR);
		{ PUTLIT(")", 1) }
	    }
	    else if (n >= 0)
	    {
		if (pr_list(f, c, p, l, FALSE, par,
				maxlin, indent, style) == CMRF_PRTERR)
		    return(CMRF_PRTERR);
	    }
	    else
		return(CMRF_PRTERR);
	    { PUTLIT("*", 1) }
	    if (sp) { PUTSPACE }
	    break;
	    }
	case P_DELREP:		/* Always surrounded with parentheses */
	    { PUTLIT("(", 1) }
	    if (pr_list(f, c, cmr_get_delrep_units1(t), l, FALSE, FALSE,
				maxlin, indent, style) == CMRF_PRTERR)
		return(CMRF_PRTERR);
	    { PUTSPACE }
	    { PUTLIT(prlit[style][FMT_SEPT], prlitlen[style][FMT_SEPT]) }
	    { PUTSPACE }
	    if (pr_list(f, c, cmr_get_delrep_units2(t), l, FALSE, FALSE,
				maxlin, indent, style) == CMRF_PRTERR)
		return(CMRF_PRTERR);
	    { PUTLIT(")", 1) }
	    if (sp) { PUTSPACE }
	    break;
	case P_ELUNIT:
	    if ((*l = cmrf_pr_didsymb(f, c, cmr_get_elunit_elem(t),
				*l, maxlin, indent)) == CMRF_PRTERR)
		return(CMRF_PRTERR);	    
	    if (sp) { PUTSPACE }
	    break;
	default:	
	    return(CMRF_PRTERR);
    }

    return(CMR_SUCCESS);

}		/* pr_list */
/* function inserted by Kalle instead of the P_BEGIN-mark in pr_subtr */
static int pr_list(f, c, t, l, sp, par, maxlin, indent, style)
FILE *f;
p_comar c;
pGenList  t; 
int *l;
Boolean sp,		/* T ==> print space AFTER printing this rhs */
	par;		/* T ==> wrap ALT construct in parentheses */
int maxlin, indent, style;
{
    int i, j;

    if (t == (pGenList)NULL)
	return(CMRF_PRTERR);

    /* case (a) in call to pr_list: par = length(list) > 1 */
    /* changed by PA */
    /* or par is inherited */
    j = cmr_list_len(t);
    for (i = 1; !cmr_isempty_list(t); t = cmr_list_tail(t), i++)
	if (pr_subtr(f, c, cmr_list_head(t), l, i!=j, j>1 || par,
		          	maxlin, indent, style) == CMRF_PRTERR)
	    return(CMRF_PRTERR);

    return(CMR_SUCCESS);
}



/* Exported declarations: */

int (*pr_other)();		/* See cmrf_pr_init() below */


/* default "other" print function, uses PGS conventions. */
int cmrf_pr_other(f, c, did, l, maxlin, indent)
FILE *f;
p_comar c;
DID did;
int l, maxlin, indent;
{
    SID psid;
    char tok, *str;

    if (cmr_get_def_entry_tag(c, did) != P_OTHER)
	return(CMRF_PRTERR);

    /* the only "other's" handled are "connect", "redmod", and "noredmod". */
    if (cmr_get_prop(c, did, cmrf_pgsconn_sid) != (Gen_prop)NULL)
    {
	psid = cmrf_pgsconn_sid;
	tok = '&';
    }
    else if (cmr_get_prop(c, did, cmrf_pgsrmod_sid) != (Gen_prop)NULL)
    {
	psid = cmrf_pgsrmod_sid;
	tok = '@';
    }
    else if (cmr_get_prop(c, did, cmrf_pgsnrmod_sid) != (Gen_prop)NULL)
    {
	psid = cmrf_pgsnrmod_sid;
	tok = '$';
    }
    else
    /* changed by U.Stellmacher on August 8th, 1988
     * original: return(CMRF_PRTERR);
     */
    /* now no error occurs if there are other OTHERS */
	return(l);

    if ( !(str = cmrl_didtosymb(c, did)) )
	return(CMRF_PRTERR);

    l -= strlen(str) + 1;		/* include length(tok) */

    if (cmr_get_symb_entry_tag(c, cmr_get_def_entry_sid(c, did)) == P_STRING)
    {
	if ((l -= 2) < 0)		/* -2 for quotes */
	    { NEWLIN }
	fprintf(f, "%c\'%s\'", tok, str);
    }
    else
    {
    	if (l < 0)
	    { NEWLIN }
	fprintf(f, "%c%s", tok, str);
    }
    return(l);

}		/* cmrf_pr_other */



/* alternative "other" printing function - omits "others" from output */
int cmrf_pr_noother(f, c, did, l, maxlin, indent)
FILE *f;
p_comar c;
DID did;
int l, maxlin, indent;
{
    return(l);		/* 0 characters printed */
}



/* Print the symbol mapped to sid of def_entry of did */
int cmrf_pr_didsymb(f, c, did, l, maxlin, indent)
FILE *f;
p_comar c;
DID did;
int l, maxlin, indent;
{
    char *str;

    if (cmr_get_def_entry_tag(c, did) == P_OTHER)
	return(pr_other(f, c, did, l, maxlin, indent));

    if ( !(str = cmrl_didtosymb(c, did)) )
	return(CMRF_PRTERR);

    l -= strlen(str);

    if (cmr_get_symb_entry_tag(c, cmr_get_def_entry_sid(c, did)) == P_STRING)
    {
	if ((l -= 2) < 0)		/* -2 for quotes */
	    { NEWLIN }
	fprintf(f, "\'%s\'", str);
    }
    else
    {
    	if (l < 0)
	    { NEWLIN }
	fprintf(f, "%s", str);
    }
    return(l);

}		/* cmrf_pr_didsymb */


/* Print production identified by did. */
int cmrf_pr_prod(f, c, did, maxlin, indent, style, rhsbrk)
FILE *f;
p_comar c;
DID did;
int maxlin, indent, style;
Boolean rhsbrk;
{
    DID lhs;
    int l;
    SEQunit rhs;

    if ((lhs = cmr_get_prod_lhs(c, did)) == CMR_UNKERR)
	return(CMRF_PRTERR);

    if ((l = cmrf_pr_didsymb(f,c,lhs,maxlin,maxlin,indent)) == CMRF_PRTERR)
	return(CMRF_PRTERR);

    if ((rhs = cmr_get_prod_units(c, did)) == (SEQunit)NULL)
		return(CMRF_PRTERR);

    if (rhsbrk)
    {
	l = maxlin - indent;
	fprintf(f, " %s\n%*s", prlit[style][FMT_IST], indent, "");
    }
    else
    {
	l -= prlitlen[style][FMT_IST] + 2;	/* 2 spaces printed */
	fprintf(f, " %s ", prlit[style][FMT_IST]);
    }

    /* case (d): no inherited need to parenthesize ALT's as we start rhs */
    if (pr_list(f, c, rhs, &l, FALSE, FALSE, maxlin, indent, style)
		 != CMR_SUCCESS)
	return(CMRF_PRTERR);

    if (l - prlitlen[style][FMT_ENDPT] < 1)  		 
	fprintf(f,"\n%*s\n",indent, prlit[style][FMT_ENDPT]);
    else 
	fprintf(f,"%s\n", prlit[style][FMT_ENDPT]);

    return(CMR_SUCCESS);

}		/* cmrf_pr_prod */


/* Print grammar rules represented by COMAR structure c */
int cmrf_pr_grammar(f, c, maxlin, indent, style, pr_init, rhsbrk)
FILE *f;
p_comar c;
int maxlin, indent, style;
int (*pr_init)();
Boolean rhsbrk;
{
    DID d;
    int stat;
    if ((stat = (*pr_init)(c)) != CMR_SUCCESS)
	return(stat);
    for (d = cmrl_first_prod(c); d != -1; d = cmrl_next_prod(c, d))
    {
	if (cmrf_pr_prod(f, c, d, maxlin, indent, style, rhsbrk) != CMR_SUCCESS)
	    return(CMRF_PRTERR);
	(void)fputc('\n', f);
    }
    return(CMR_SUCCESS);

}		/* cmrf_pr_grammar */



/* Default initialization routine for printing others */
int cmrf_pr_init(c)
p_comar c;
{
   /* changed by U.Stellmacher on 11-08-88 */

    pr_other = cmrf_pr_other;
    cmrf_pgsconn_sid = cmrl_namtosid(c, "connect");
    cmrf_pgsrmod_sid = cmrl_namtosid(c, "reducemod");
    cmrf_pgsnrmod_sid = cmrl_namtosid(c, "noreducemod");

    return(CMR_SUCCESS);

}		/* cmrf_pr_init */



/* alternative initialization routine to ignore others in grammar. */
int cmrf_pr_noinit(c)
p_comar c;
{
    pr_other = cmrf_pr_noother;
    return(CMR_SUCCESS);
}
