/*
** $Id: cmrio.h,v 1.2 90/10/23 13:43:37 cogito Exp $
*/

/***************************************************************************/
/* File: cmrio.h	First Edit: 17.10.88	  Last Edit: 08.11.88      */
/*									   */
/* Author: Karl-Josef Prott,	University at Paderborn, Germany	   */
/* Last Change: Kalle  (05.02.90)                                          */
/***************************************************************************/


#ifndef cmrio_DEF
#define cmrio_DEF

#include "cmrlib.h"  /* because of type ERR */

/* Maximum tool-information line length (first line) */
#define MAX_TOOL_INFO 127

/* errorcodes */
#define CMR_OPNERR  -2
#define CMR_RDERR   -4


/* exported routines: */

/* cmrlib-write - write ASCII comar representation of COMAR structure t
 *	entry:	*name == filename for writing COMAR-data-structure
 *		*tool_info does not contain '\n'.
 *		*c == an initialized COMAR internal structure
 *	exit:	(return == CMR_SUCCESS) ==> 
 *		  *tool_info augmented with '\n' has been written to a file 
 *		  named 'filename', followed by the ASCII represent. of *c.
 *		    
 *		(return == one of the errorcodes), if an error occured
 */
extern ERR cmrlib_write( /* char *filename; char *tool_info; p_comar c */ );


/* cmrlib-read - read ASCII comar representation into new COMAR structure
 *	entry:	*filename == name of external COMAR file.
 *		tool_info addresses a buffer with length >= MAX_TOOL_INFO
 *		c addresses an new, empty COMAR specification.
 *		( Think of call by reference: p_comar *(!) c )
 *	exit:	(cmrlib_read == CMR_SUCCESS) ==> 
 *		    *c == COMAR structure containing the internal
 *		     representation for the contents of file 'filename'.
 *		    *tool_info == the first line from that file, containing
 *		     tool-specific information.
 *		(return == one of the errorcodes), if an error occured
 */
extern ERR cmrlib_read( /* char *filename; char *tool_info; p_comar *c */ );


#endif   /* of cmrio_DEF */
