/*
** $Id: firstset.h,v 1.2 90/10/23 13:30:32 cogito Exp $
*/

/***************************************************************************/
/* File: firstset.h	First Edit: 27.02.89	  Last Edit: 31.03.89      */
/*									   */
/* Author: Karl-Josef Prott,	University at Paderborn, Germany	   */
/***************************************************************************/

#ifndef	firstset_DEF
#define	firstset_DEF

#include	"cmrlib.h"	/* for typedefinitons */
#include	"bitset.h"

/***************************************************************************/
/* Imported variables, which MUST(!) be initialized before 		   */
/*					executing 'computeFIRSTSETS()'.    */
/***************************************************************************/


/* Global variables used in 'computeFIRSTSETS()' defined in "cmrlib" */

extern	Indextype	MAXNTERM;  /* init. by cmrlib_compute_globarrs() */
extern	Indextype	MAXTERM;
extern	ARRIndextype	INDEX;
extern	ARRdef_entry	DEFTBL;

extern	SEQdef_entry	NTERM_SEQ; /* initialized by cmrlib_arrangedefs() */

/* 'CMR' will be used by all follow. functions but needn't be init. before */
extern	p_comar	CMR;		  /* init. by cmrlib_changeglobalcmrvar() */

/***************************************************************************/
/* Exported errorcodes, types, variables and functions:			   */
/***************************************************************************/


/* errorcodes */
#define	FIR_INCOMPL	-56	/* There are nonterminals for which no	*/
				/* first-set is computed.		*/

#define	FIR_UNK		-57	/* There are no first-sets. The name    */
				/*'FIRSTTRANSCLOS' of "first.h" is unknown.*/


typedef BitSet	*ARRBitSet;

/* global exported variable for first-sets. */
extern	ARRBitSet	FIRSTSETS;


/* computeFIRSTSETS() transforms the first-sets of COMAR into the dynamic
 * array 'FIRSTSETS'.
 * Note: The first-set-computations must be performed with
 *	 'cmrtl_compute_first()' (or with functions declared in "first.h").
 * return == CMR_SUCCESS, if FIRSTSETS[MAXNTERM] is computed completely
 *	  == errorcode  , otherwise (FIRSTTRANSCLOS is not yet computed
 *			  to all nonterminals.)
 */
extern	ERR	computeFIRSTSETS(/* p_comar c */);

/***************************************************************************/

/* errorcodes */
#define	FIR_TRANSCLOSERR	-51	/* Error in computing the transitive
					 * closure of the first-sets */
#define	FIR_WRTERR		-52	/* Error in writing the first-sets */

/* return == CMR_SUCCESS, the firstsets are computed completely as needed 
 *			  for 'computeFIRSTSETS()'
 *	  == errorcode,   otherwise
 *  Note: if (filename != ""), the first sets are printed to file with
 *	  name "filename.fir.set"
 */
ERR	cmrtl_compute_first(/* p_comar c; String filename */);

#endif  /* of firstset_DEF */
