/*
** $Id: wrthelpfunc.h,v 1.3 1992/01/10 16:14:09 cogito Exp $
*/

/******************************************************************************/
/* filename: wrthelpfunc.h                    first edit   :  3 .11 . 89      */
/* author  : Christian Zeitel                 last change  : 23 . 3 . 90      */
/******************************************************************************/

/******************************** CONTENTS *************************************
 *									       *
 *  This is the interface between the calling module wrtfunc and the answering *
 *  module wrthelpfunc.						               *
 *       functions:  13  |  variables:  2  | types:  0      		       *
 *									       *
 ************************** FUNCTION DECLARATIONS *****************************/




extern  void print_fixtabs(/* FILE *fp, *fp_sema, readtype pt_data */);

  /*  Prints the tables which are not generated by optimization on file
   *  fp is pointing to. The semantic informations about terminals are
   *  written on the file fp_sema is pointing to.
   *
   ***/





extern  void print_table(/* short *table; char *tabname; FILE *fp;       */
 		 	 /* char toobigforchar, numberbase; int tabsize  */);

  /*  Prints the table given by table with name tabname on file fp points to.
   *  tabsize is the size of table. If numberbase = HEX, hexnumbers are 
   *  printed, if numberbase = DEC, decimal numbers are printed.
   *  If toobigforchar = YES, basetype short is printed for the printed table,
   *  if toobigforchar = NO, basetype unsigned char is printed for the printed
   *  table.
   *
   ***/






extern  void print_label(/* char tabkind; FILE *fp; char *optname; */);

  /*  Prints the macroname which selects a optimization-method for the 
   *  terminal- or nonterminaltable on the file fp is pointing to.
   * 
   ***/




extern  void print_errmat(/* FILE *fp; short not, nos, noc; */
			  /* short *rowptr, *colptr, *ttab; */);
 
  /*  Prints the negated error-matrix sigmap on the file, fp is pointing to.
   *
   ***/





extern  void print_GCSptab(/* FILE *fp; char tabkind;    */
		 	   /* short tabsize, noc, *ptab; */);
  
  /*  Prints the parsertable ptab for which tabkind decides, if it is a 
   *  terminal- or a nonterminal-parsertable on the file fp is pointing to.
   *  Optimization-method is the Graph-Colouring-Scheme.
   *
   ***/




extern  void print_LESptab(/* FILE *fp; char tabkind;                   */
		 	   /* short nor, noc, *ptab; opttype *opt_data; */);
  
  /*  Prints the parsertable ptab for which tabkind decides, if it is a 
   *  terminal- or a nonterminal-parsertable on the file,fp is pointing to.
   *  Optimization-method is the Line-Elimination-Scheme.
   *
   ***/	





extern  void print_LESeltab(/* short *val, *dec, scans; char *name; */
			    /* FILE *fp; short size;		    */);
  
  /*  Prints the table of eliminated values for the
   *  rows or the columns of the terminal- or a nonterminal-parsertable
   *  computed during the Line-Elimination-Scheme on the file fp is pointing to.
   *
   ***/





extern  void print_SDSptab(/* FILE *fp; char tabkind; short nor, noc; */
			   /* short *ptab, *firstptr, *lastptr;       */);
			  
  /*  Prints the parsertable optimized by method Signifcant-Distance-Scheme on
   *  the file fp is pointing to. firstptr[i] gives the index of the fifst sig-
   *  nificant entry in row i, lastptr[i] gives the last significant entry in
   *  row i.
   *
   ***/





extern  void print_rptrtab(/* FILE *fp; char tabkind; */ 
			   /* short nor; int *rowptr; */);
  
  /*  Prints the rowpointer-table which is used by optimization-methods 
   *  Row-Displacement-Scheme and Significant-Distance-Scheme on the
   *  file fp is pointing to.
   *
   ***/ 



	    

extern  void print_RCSAptab(/* FILE *fp; char tabkind;
			    /* short nor, noc, *ptab, *termlist; */);
			   
  /*  Prints the parsertable ptab for which tabkind decides, if it is a 
   *  terminal- or a nonterminal-parsertable on the file fp is pointing to.
   *  Optimization-method is the simple Row-Column-Scheme.
   *
   ***/





extern  void print_RCSAbase(/* FILE *fp; char tabkind; */
     			    /* short nor, noc, *ptab;  */);
  
  /*  Prints helping-vector base on file fp is pointing to. Its needed for
   *  determing an entry in the parsertable produced by function print_RCSAptab.
   *
   ***/





extern  void print_RCSBptab(/* FILE *fp, char tabkind;                   */
		 	    /* short nor, noc, *ptab, *rowptr, *termlist; */);
  
  /*  Prints the parsertable ptab for which tabkind decides, if it is a 
   *  terminal- or a nonterminal-parsertable on the file, fp is pointing to.
   *  Optimization-method is the Row-Column-Scheme with merging of equal rows.
   *
   ***/





extern  void print_RCSBbase(/* FILE *fp, char tabkind;         */
		 	   /* short nor, noc, *ptab, *rowptr; */);
  
  /*  Prints the helping-vector base on file fp is pointing to. Its needed for
   *  determing an entry in the parsertable produced by function print_RCSBptab.
   *
   ***/



/************************** VARIABLE DECLARATIONS *****************************/

extern short minterm, /* the smallest scannerdefined syntaxcode */
             maxterm; /* the bigggest scannerdefined syntaxcode */
