/*
** $Id: opthelptype.h,v 1.3 1992/01/10 16:14:09 cogito Exp $
*/

/******************************************************************************/
/* filename: opthelptype.h                    first edit   :  3 .11 . 89      */
/* author  : Christian Zeitel                 last change  : 10 . 7 . 90      */
/******************************************************************************/

/******************************** CONTENTS *************************************
 *  									       *
 *  This file contains the typedefinitions for the different optimization-     *
 *  methods.								       *
 *									       *
 ******************************************************************************/

/******************************************************/
/* typedefinition for interface to optimization-module*/
/******************************************************/

typedef short  *readtype[];

/******************************************************/
/* typedefinitions needed for optimization-method GCS */
/******************************************************/
 
typedef  struct  {
 
                short             degree,
                                  nodeindex,
                                  colourindex;
                struct succtype  *adjlist;
                                
}  nodetype;


typedef  struct succtype  {

                nodetype  *info;
         struct succtype  *next;
         
} adjlisttype;

typedef  short  *partitiontype[];

typedef  nodetype *graphtype[];



/******************************************************/
/* typedefinition needed for optimization-method LES  */
/******************************************************/

typedef  struct  {
                
                short  *decrow,
                       *deccol,
                       *rowval,
                       *colval,
                        elrows,
                        elcols,
                        scans;
                        
} lestype;





/******************************************************/
/* typedefinition needed for optimization-method RDS  */
/******************************************************/

typedef  struct  {
                
                short  *optab;
                
                int    *rowptr,
                	size;
                	
} rdstype;





/******************************************************/
/* typedefinition needed for optimization-method SDS  */
/******************************************************/

typedef  struct  {
                
                short  *first,
                       *last;
                
                int    *rowptr;
                
} sdstype;




/******************************************************/
/* typedefinition needed for optimization-method RCS  */
/******************************************************/

typedef  struct  {
                
                short  *rowptr,
                       *rowind,
                        maxrowind;
                        
} rcstype;

