/*
** $Id: build_copa.h,v 1.3 1992/01/10 16:14:09 cogito Exp $
*/

/******************************************************************************/
/* filename: build_tdcopa.h                   first edit   :  2 .  3 . 90     */
/* author  : Christian Zeitel                 last  change : 10 .  7 . 90     */
/******************************************************************************/


extern void build_copa(/* char addinfo, optinfo; optkindtype  optkind;   */
                       /* p_comar Comar_root; absparsertype Abs_parser;  */);
                       
/*******************************************************************************
 *									       *
 *  build_copa constructs parts of a concrete LALR(1)-parser. Its a backend    *
 *  for the frontend constructed by Karl-Josef Prott, which creates a so-      *
 *  called abstract parser. The backend can implement the concrete parser in   *
 *  two different ways : by constructing parse-tables for a tabledriven parser *
 *  or by constructing code-fragments for a directly programmed parser. There- *
 *  for two different backend-implementations exist.                           *
 * 									       *
 *									       *
 * INPUT :                                                                     *
 * ------ 								       *
 * 1.if parameter addinfo = 1, at various points the programm prints reports   *
 *   about sucessfully terminated modules or functions to stdout.              *
 *									       *
 * 2.if parameter optinfo = 1, additional informations about the results of    *
 *   the selected optimization-method are printed on file "opt.out".           *
 *									       *
 * 3.parameter optkind is of type optkindtype. If a tabledriven parser is ge-  *
 *   nerated, optkindtype is declared in file "tabsopttype.h". If a directly   *
 *   programmed parser is generated, optkindtype is declared in file           *
 *   "codeopttype.							       *
 *									       *
 * 4.Comar_root contains the internal representation of the IDL-C COMAR-data-  *
 *   structure after running through the comartool "cmrtool", which inserts    *
 *   the syntaxcodes for the terminals and the productioncodes.                *
 *									       *
 * 5.Abs_parser contains the internal representation of the IDL-C-structure    *
 *   for the abstract parser.						       *
 *                                                                             *
 *                                                                             *
 *                                                                             *
 * OUTPUT : If a tabledriven parser is generated :			       *
 * -------- the tables needed by the tabledriven parser are printed on file    *
 *          "ptabs.h" which is included by module "parsercore".                *
 *									       *
 *          If a directly programmed parser is generated :	               *
 *          the code for the directly programmed parser is printed on file     *
 *          "pcode.h" and additional tables needed for error-recovery are      *
 *          printed on file "ptabs.h". Both files are included into module     *
 *          "parsercore".						       *
 *									       *
 *          In each of both cases a file with name "seminf.h" is generated.    *
 *          It contains semantic informations about the terminal-symbols and   *
 *          is included by the parserframe in module "parser".                 *
 *									       *
 ******************************************************************************/
 
