/***************************************************************************/
/* filename : write_error.c                        first edit  : 8.04.91   */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change : 21.08.91  */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.1 $ */
static char rcsid[] = "$Id: write_error.c,v 1.1 1992/01/10 14:38:40 cogito Exp $";


/*************************** INCLUDE - FILES *******************************/




#include <stdio.h>

#include "over_types.h"

#include "error_out.h"

#include "over.h"

#include "out.h"

#include "write_help.h"

#include "errors.h"



/************************* MACRO - DEFINITIONS *****************************/

#define IS_F_REDACT( entry )       entry & 0x2000
#define IS_R_REDACT( entry )       entry & 0x4000
#define IS_F_GOTOACT( entry )      entry & 0x1000
#define IS_R_GOTOACT( entry )      entry & 0x8000


/**************************** FUNCTIONS ************************************/

static void Write_Var( fp,error_out_data,extra_info )

   FILE                          *fp;  /* file pointer to the external
					  output file, where the error
					  recovery part of the parser
					  should be written                */
   struct error_out  *error_out_data;  /* pointer to a structure, which
					  stores all relevant data for the
					  error_code                       */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out      */


/* Prints the variables used by the error recovery.
*/


   {
     if( extra_info )
	printf("begin of function Write_Var( )\n");

     fprintf(fp,"register short action;\n");
     fprintf(fp,"short  first_scan_elem = -1,\n");
     fprintf(fp,"                   *save_sp,\n");
     fprintf(fp,"                *save_stack,\n");
     if( !error_out_data->fsymbol_equal_rsymbol )
	fprintf(fp,"                   nos = %d,\n\n",error_out_data->nos);
     fprintf(fp,"                       loop;\n");
     fprintf(fp,"char                 choose;\n\n");

     if( extra_info )
	printf("end of function Write_Var( )\n");

   } /* end of function Write_Var( ) */







static void Write_Stop_At_First_Error( fp,extra_info )

   FILE          *fp;  /* file pointer to the external output file, where
			  the error recovery part of the parser should be
			  written                                          */
   char   extra_info;  /* if extra_info == 1, then extra information
			  about begin and end of function is printed out  */


/* The user could choose between two kinds of error recovery. One of them
   is "Stop At First Error". The code for this technique is printed
   here.
*/


  {
     if( extra_info )
	printf("begin of function Write_Stop_At_First_Error( )\n");

    fprintf(fp,"ERR :\n");
    fprintf(fp,"   ERR_MSG( ERROR,PARSING_ERROR,state,term );\n");
    fprintf(fp,"   ERR_MSG( DEADLY,STOP,state,term );\n" );
    fprintf(fp,"   exit( 1 );\n");

     if( extra_info )
	printf("end of function Write_Stop_At_First_Error( )\n");

  } /* end of function Write_Stop_At_First_Error( ) */






static void Write_Static_Var( fp,error_out_data,user_data,extra_info )

   FILE                          *fp;  /* file pointer to the external
					  output file, where the error
					  recovery part of the parser
					  should be written                */
   struct error_out  *error_out_data;  /* pointer to a structure, which
					  stores all relevant data for the
					  error_code                       */
   struct user            *user_data;  /* internal interface vector, which
					  saves information fixed by the
					  user                             */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out      */


/* Here all static definitions and vectors is printed out.
*/


   {
     short    loop,  /* loop index                                         */
             count,  /* loop index                                         */
               pos,  /* position in a bit set, printed out yet             */
            length,  /* length of a bit set                                */
               nos;  /* number of states                                   */
     char      szc;  /* size of char in bits                               */
     int     max=0,  /* maximum syntax code                                */
             print;  /* used to get a formated output                      */
 

     if( extra_info )
	printf("begin of function Write_Static_Var( )\n");

     nos = error_out_data->nos;
     szc = sizeof( char ) * BYTE;
     length = (!(nos%szc)) ? (nos/szc) : ((nos/szc)+1);


     fprintf(fp,"#define REP_LIST_TYPE      %s\n",REP_LIST_TYPE);
     fprintf(fp,"#define ADDRESS_TYPE       %s\n",ADDRESS_TYPE);
     fprintf(fp,"#define POS_ANCHOR_TYPE    %s\n",POS_ANCHOR_TYPE);
     fprintf(fp,"#define ANCHOR_SET_TYPE    %s\n",ANCHOR_SET_TYPE);

     if( error_out_data->share_address )
        fprintf(fp,"#define SHARE_CODE\n");
     fprintf(fp,"#define IS_TRUE( vector,pos)  ");
     fprintf(fp,"(vector[pos/%d] & ",szc);
     fprintf(fp,"(1 << (pos%%%d)))\n",szc);

     if( !error_out_data->fsymbol_equal_rsymbol )
        {
          fprintf(fp,"#define SET_TRUE( vector,pos)  ");
          fprintf(fp,"vector[pos/%d] = (vector[pos/%d] | ",szc,szc);
          fprintf(fp,"(1 << (pos%%%d)))\n",szc);
        }

     if( user_data->semantic_symbols )
	{

	  fprintf(fp,"#define DEFAULT_VALUE           0\n");
	  fprintf(fp,"#define QUEUE_SIZE              %d\n",
		  user_data->queue_size);


	} /* end of if( user_data-... */
     if( !error_out_data->fsymbol_equal_rsymbol )
	fprintf(fp,"#define VISITED\n");
     if( error_out_data->numb_of_para )
	{
	  fprintf(fp,"#define SEM_PARA_TEST\n\n\n");
	  fprintf(fp,"static short   semantic_parantheses = -1,\n");
	  fprintf(fp,"              number_of_parantheses = %d;\n",
		  error_out_data->numb_of_para);
	  fprintf(fp,"static short  par_set[] =\n");
	  fprintf(fp,"   { ");
	  for( loop=0;loop<error_out_data->numb_of_para;loop++ )
	     if( !loop )
		fprintf(fp,"%4d",error_out_data->par_set[loop]);
	     else
                {
                  if( !(loop%16) )
                      fprintf(fp,"\n    ");
		  fprintf(fp,",%4d",error_out_data->par_set[loop]);
                }
	  fprintf(fp," };\n\n");
	  if( user_data->semantic_symbols )
	     {
	       fprintf(fp,"typedef struct queue_elem\n");
	       fprintf(fp,"   {\n");
	       fprintf(fp,"     short          term;\n");
	       fprintf(fp,"     TYPE_OF_VALUE   val;\n");
	       fprintf(fp,"   };\n\n\n");

	       fprintf(fp,"static int                qp = 0,\n");
	       fprintf(fp,"                               i,\n");
	       fprintf(fp,"                               j;\n\n");
	       fprintf(fp,"static struct queue_elem  *queue;\n\n");
	     } /* end of if( user_data-... */
	} /* end of if( error_out_... */

     fprintf(fp,"static int pos = 0;\n\n");

     fprintf(fp,"static char first_call = TRUE;\n\n");

     fprintf(fp,"static short  cont_state,\n");
     fprintf(fp,"                     run;\n\n");



     if( !error_out_data->fsymbol_equal_rsymbol )
	{
	  fprintf(fp,"static char visited[] =\n");
	  fprintf(fp,"   { ");
	  for( loop=0;loop<length;loop++ )
	     if( !loop )
	        fprintf(fp,"%d",(char)error_out_data->visited[loop]);
	     else
                {
                  if( !(loop%16) )
                     fprintf(fp,"\n     ");
		  fprintf(fp,",%d",(char)error_out_data->visited[loop]);
                }
	  fprintf(fp," };\n\n");
          fprintf(fp,"static char save_visited[] =\n");
	  fprintf(fp,"   { ");
	  for( loop=0;loop<length;loop++ )
	     if( !loop )
	        fprintf(fp,"%d",(char)error_out_data->visited[loop]);
	     else
                {
                  if( !(loop%16) )
                     fprintf(fp,"\n     ");
		  fprintf(fp,",%d",(char)error_out_data->visited[loop]);
                }
	  fprintf(fp," };\n\n");
	} /* end of else ( if( error_ou... ) */
   
     if( error_out_data->share_address )
        {
          fprintf(fp,"static REP_LIST_TYPE rep_list[] =\n   {");
          for( loop=0;loop<error_out_data->nos;loop++ )
             {
               if( loop )
                  {
                    fprintf(fp,",");
                    if( !(loop%16) )
                       fprintf(fp,"\n    ");
                  }
               if( IS_REP( error_out_data->address_list[loop].number ) )
                  fprintf(fp,"%4d",error_out_data->address_list[loop].addr.rep );
               else
                  fprintf(fp,"%4d",loop);
             }
          fprintf(fp,"};\n\n");
        }

     fprintf(fp,"static ADDRESS_TYPE address[] =\n");
     fprintf(fp,"   {     0");
     print = 0;
     for( loop=0;loop<error_out_data->nos;loop++ )
        {
          if( !(error_out_data->share_address &&
               IS_REP( error_out_data->address_list[loop].number )) )
             print += OPERAND( error_out_data->address_list[loop].number );
          if( !(loop%16) )
             fprintf(fp,"\n    ");
	  fprintf(fp,",%4d",print);
        }
     fprintf(fp," };\n\n");


     fprintf(fp,"static POS_ANCHOR_TYPE pos_anchor[] =\n");
     fprintf(fp,"   { ");
     print = 0;
     for( loop=0;loop<error_out_data->nos;loop++ )
        {
          if( !(error_out_data->share_address &&
               IS_REP( error_out_data->address_list[loop].number )) )
             {
               if( IS_REP( error_out_data->address_list[loop].number ) )
                  pos = error_out_data->address_list[loop].addr.rep;
               else
                   pos = loop;
               for( count=0;count<OPERAND( error_out_data->address_list[loop].
                    number );count++ )
	         {
	           if( max < error_out_data->sx_code_list[error_out_data->
                                         address_list[pos].addr.list[count]] )
	               max = error_out_data->sx_code_list[error_out_data->
                                       address_list[pos].addr.list[count]];
	           if( !print )
	              fprintf(fp,"%4d",error_out_data->sx_code_list[
                                       error_out_data->address_list[pos].addr.
                                       list[count]]);
	           else
                      {
                        if( !(print%16) )
                           fprintf(fp,"\n    ");
	                fprintf(fp,",%4d",error_out_data->sx_code_list[
                                          error_out_data->address_list[pos].addr.
                                          list[count]]);
                      }
                   print++;
	         } /* end of for( count=0;... */
             }
        }
     fprintf(fp," };\n\n");


     fprintf(fp,"static ANCHOR_SET_TYPE anchor_set[] =\n");
     fprintf(fp,"   { ");
     for( loop=0;loop<max+1;loop++ )
	if( !loop )
	   fprintf(fp,"-1");
	else
           {
             if( !(loop%16) )
                fprintf(fp,"\n     ");
	     fprintf(fp,",-1");
           }
     fprintf(fp," };\n\n");

     if( extra_info )
	printf("end of function Write_Static_Var( )\n");

   } /* end of function Write_Static_Var( ) */







static void Write_Error_Body( fp,error_out_data,user_data,extra_info )

   FILE                          *fp;  /* file pointer to the external
					  output file, where the error
					  recovery part of the parser
					  should be written                */
   struct error_out  *error_out_data;  /* pointer to a structure, which
					  stores all relevant data for the
					  error_code                       */
   struct user            *user_data;  /* internal interface vector, which
					  saves information fixed by the
					  user                             */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out      */


/* The function writes the kernel of the error recovery. There the 
   anchor will be determined etc.
*/


   {
     short  length,  /* length of a bit set                                */
               nos;  /* number of states                                   */
     char      szc;  /* size of char in bits                               */
 




     if( extra_info )
        printf("begin of function Write_Error_Body()\n");

     nos = error_out_data->nos;
     szc = sizeof( char ) * BYTE;
     length = (!(nos%szc)) ? (nos/szc) : ((nos/szc)+1);

     fprintf(fp,"CONTINUE :\n");
     fprintf(fp,"   if( first_scan_elem >= 0 )\n");
     fprintf(fp,"      {\n");
     fprintf(fp,"        term = first_scan_elem;\n");
     fprintf(fp,"        first_scan_elem = -1;\n");
     fprintf(fp,"      }\n");
     fprintf(fp,"   else\n");
     fprintf(fp,"      SCAN( term );\n");
     fprintf(fp,"   if( anchor_set[term] < 0 )\n");
     fprintf(fp,"      {\n");
     fprintf(fp,"#ifdef INFO\n");
     fprintf(fp,"        ERR_MSG( NOTE,DELETED,0,term );\n");
     fprintf(fp,"#endif\n");
     if( user_data->semantic_symbols )
	fprintf(fp,"        INSERT_QUEUE_ELEM( term,SYMBOL_CONNECTION_VALUE );\n");
     fprintf(fp,"        goto CONTINUE;\n");
     fprintf(fp,"      }\n");
     fprintf(fp,"   else\n");
     fprintf(fp,"      {\n");
     if( error_out_data->numb_of_para )
	{
	  fprintf(fp,"        if( (semantic_parantheses < 0 )              ");
	  fprintf(fp," ||\n");
	  fprintf(fp,"            (anchor_set[term] < semantic_parantheses)");
	  fprintf(fp," ||\n");
	  fprintf(fp,"            Semantic_Parantheses_Test( term )        ");
	  fprintf(fp,"  )\n");
	  fprintf(fp,"           {\n");
	  fprintf(fp,"             pos = anchor_set[term];\n");
	  fprintf(fp,"             goto RUN_2;\n");
	  fprintf(fp,"           }\n");
          fprintf(fp,"#ifdef INFO\n");
          fprintf(fp,"        ERR_MSG( NOTE,DELETED,0,term );\n");
          fprintf(fp,"#endif\n");
	  if( user_data->semantic_symbols )
	     fprintf(fp,"        INSERT_QUEUE_ELEM( term,SYMBOL_CONNECTION_VALUE );\n");
	  fprintf(fp,"        goto CONTINUE;\n");
	} /* end of if( error_out_... */
     else
	{
	  fprintf(fp,"        pos = anchor_set[term];\n");
	  fprintf(fp,"        goto RUN_2;\n");
	} /* end of else ( if( error_out_... ) */
     fprintf(fp,"      }\n");
     fprintf(fp,"\n");

     fprintf(fp,"RUN_2 :\n");
     fprintf(fp,"   run = 2;\n");
     fprintf(fp,"   for( loop=0;loop<STACK_SIZE;loop++ )\n");
     fprintf(fp,"      sp_begin[loop] = save_stack[loop];\n");
     fprintf(fp,"   sp = save_sp;\n");
     fprintf(fp,"   first_call = TRUE;\n");
     if( !error_out_data->fsymbol_equal_rsymbol )
	{
	  fprintf(fp,"   for( loop=0;loop<%d;loop++ )\n",length);
	  fprintf(fp,"      visited[loop] = save_visited[loop];\n");
	} /* end of if( !error_out_data->... */
     fprintf(fp,"   goto LOOP;\n");
     fprintf(fp,"\n");

     fprintf(fp,"JUMP_BACK :\n");
     if( !error_out_data->fsymbol_equal_rsymbol )
	{
	  fprintf(fp,"   for( loop=0;loop<%d;loop++ )\n",length);
	  fprintf(fp,"      visited[loop] = save_visited[loop];\n");
	} /* end of if( !error_out_data->... */
     fprintf(fp,"   ERR_MSG( NOTE,RESUMED,cont_state,0 );\n");
     fprintf(fp,"   first_call = TRUE;\n");
     fprintf(fp,"   state = cont_state;\n\n");

     if( extra_info )
        printf("end of function Write_Error_Body()\n");
   } /* end of function Write_Error_Body() */






static void Write_Error_Mark( fp,error_out_data,user_data,extra_info )

   FILE                          *fp;  /* file pointer to the external
					  output file, where the error
					  recovery part of the parser
					  should be written                */
   struct error_out  *error_out_data;  /* pointer to a structure, which
					  stores all relevant data for the
					  error_code                       */
   struct user            *user_data;  /* internal interface vector, which
					  saves information fixed by the
					  user                             */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out      */


/* This function writes the code for the error mark and copying
   the stack.
*/


   {
     if( extra_info )
        printf("begin of function Write_Error_Mark()\n");

     fprintf(fp,"ERR :\n");
     fprintf(fp,"   ERR_MSG( ERROR,PARSING_ERROR,state,term );\n");
     fprintf(fp,"   first_scan_elem = term;\n");
     fprintf(fp,"   if( first_call )\n");
     fprintf(fp,"      {\n");
     fprintf(fp,"        if( (save_stack = (short*) calloc( STACK_SIZE,\n");
     fprintf(fp,"            sizeof( short ) )) == NULL)\n");
     fprintf(fp,"          ERR_MSG(DEADLY,NO_SPACE,0,0 );\n");
     fprintf(fp,"        save_sp = sp;\n");
     if( user_data->semantic_symbols )
	{
	  fprintf(fp,"        if( (queue = (struct queue_elem*) calloc( ");
	  fprintf(fp,"QUEUE_SIZE,sizeof( struct queue_elem ) )) == NULL)\n");
	  fprintf(fp,"           /* Fehlermeldung fehlt noch */ ;\n");
	} /* end of if( user_data->se... */
     fprintf(fp,"      }\n");
     fprintf(fp,"   for( loop=0;loop<STACK_SIZE;loop++)\n");
     fprintf(fp,"      save_stack[loop] = sp_begin[loop];\n");
     fprintf(fp,"   run = 1;\n");
     fprintf(fp,"   first_call = TRUE;\n");
     fprintf(fp,"   for( loop=0;loop<%d;loop++)\n",error_out_data->max_term -
                                                   error_out_data->min_term + 1 );
     fprintf(fp,"      anchor_set[loop] = -1;\n");

     if( extra_info )
        printf("end of function Write_Error_Mark()\n");

   } /* end of function Write_Error_Mark( ) */






static void Write_Choice_List( fp,nos,user_data,extra_info )

   FILE                *fp;  /* file pointer to the external output file, 
                                where the error recovery part of the 
                                parser should be written                   */
   struct user  *user_data;  /* internal interface vector, which saves 
                                information fixed by the user              */
   short               nos;  /* number of states                           */
   char         extra_info;  /* if extra_info == 1, then extra informa-
                                tion about begin and end of function 
                                is printed out                            */


/* After the error is repaired, a jump to the new state, in the normal
   automaton takes place. This function prints out the code for searching
   for the right mark and jumps to there.
*/

   {
     short state;  /* loop index                                           */


     if( extra_info )
	printf("begin of function Write_Choice_List( )\n");

     if( user_data->choose_list )
        {
          fprintf(fp,"   switch( state )\n");
          fprintf(fp,"      {\n");
          for( state=0;state<nos;state++ )
	     fprintf(fp,"      case %d :  goto C_%d;\n",state,state);


          fprintf(fp,"      } \n");
        } /* end of if( user_data-... */
     else
        {
          for( state=0;state<nos;state++ )
	     fprintf(fp,"   if( state == %d )  goto C_%d;\n",state,state);
        } /* end of else ( if( user_data-... ) */
     fprintf(fp,"\n\n");

     if( extra_info )
	printf("end of function Write_Choice_List( )\n");

   } /* end of function Write_Choice_List( ) */






static void Write_Error_Tabs( fp,error_out_data,extra_info )

   FILE                          *fp;  /* file pointer to the external
					  output file, where the error
					  recovery part of the parser
					  should be written                */
   struct error_out  *error_out_data;  /* pointer to a structure, which
					  stores all relevant data for the
					  error_code                       */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out      */

/* Prints out the error tables used for the error recovery.
*/



   {
     short   state,  /* loop index                                         */
            length,  /* length of a bit set                                */
               nos;  /* number of states                                   */
     char      szc;  /* size of char in bits                               */

     nos = error_out_data->nos;
     szc = sizeof( char ) * BYTE;
     length = (!(nos%szc)) ? (nos/szc) : ((nos/szc)+1);

     if( error_out_data->push != NULL )
        {
          fprintf(fp,"static char push[] = \n   {");
          for( state=0;state<length;state++ )
             if( !state )
                fprintf(fp,"%4d",(char)error_out_data->push[state]);
             else
                {
                  if( !(state%16) )
                     fprintf(fp,"\n");
                  fprintf(fp,",%4d",(char)error_out_data->push[state]);
                }
          fprintf(fp,"};\n\n");
        }


     if( error_out_data->fsymbol_action != NULL )
        {
          fprintf(fp,"static short fsymbol_action[] = \n   {");
          for( state=0;state<nos;state++ )
             if( !state )
                fprintf(fp,"%4d",(short)error_out_data->fsymbol_action[state]);
             else
                {
                  if( !(state%16) )
                     fprintf(fp,"\n");
                  fprintf(fp,",%4d",(short)error_out_data->fsymbol_action[state]);
                }
          fprintf(fp,"};\n\n");
        }


     if( error_out_data->rsymbol_action != NULL )
        {
          fprintf(fp,"static short rsymbol_action[] = \n   {");
          for( state=0;state<nos;state++ )
             if( !state )
                fprintf(fp,"%4d",(short)error_out_data->rsymbol_action[state]);
             else
                {
                  if( !(state%16) )
                     fprintf(fp,"\n");
                  fprintf(fp,",%4d",(short)error_out_data->rsymbol_action[state]);
                }
          fprintf(fp,"};\n\n");
        }

     if( error_out_data->fsymbol_sem1 != NULL )
        {
          fprintf(fp,"static short fsymbol_sem1[] = \n   {");
          for( state=0;state<nos;state++ )
             if( !state )
                fprintf(fp,"%4d",(short)error_out_data->fsymbol_sem1[state]);
             else
                {
                  if( !(state%16) )
                     fprintf(fp,"\n");
                  fprintf(fp,",%4d",(short)error_out_data->fsymbol_sem1[state]);
                }
          fprintf(fp,"};\n\n");
        }


     if( error_out_data->rsymbol_sem1 != NULL )
        {
          fprintf(fp,"static short rsymbol_sem1[] = \n   {");
          for( state=0;state<nos;state++ )
             if( !state )
                fprintf(fp,"%4d",(short)error_out_data->rsymbol_sem1[state]);
             else
                {
                  if( !(state%16) )
                     fprintf(fp,"\n");
                  fprintf(fp,",%4d",(short)error_out_data->rsymbol_sem1[state]);
                }
          fprintf(fp,"};\n\n");
        }

     if( error_out_data->fsymbol_sem2 != NULL )
        {
          fprintf(fp,"static short fsymbol_sem2[] = \n   {");
          for( state=0;state<nos;state++ )
             if( !state )
                fprintf(fp,"%4d",(short)error_out_data->fsymbol_sem2[state]);
             else
                {
                  if( !(state%16) )
                     fprintf(fp,"\n");
                  fprintf(fp,",%4d",(short)error_out_data->fsymbol_sem2[state]);
                }
          fprintf(fp,"};\n\n");
        }

     if( error_out_data->rsymbol_sem2 != NULL )
        {
          fprintf(fp,"static short rsymbol_sem2[] = \n   {");
          for( state=0;state<nos;state++ )
             if( !state )
                fprintf(fp,"%4d",(short)error_out_data->rsymbol_sem2[state]);
             else
                {
                  if( !(state%16) )
                     fprintf(fp,"\n");
                  fprintf(fp,",%4d",(short)error_out_data->rsymbol_sem2[state]);
                }
          fprintf(fp,"};\n\n");
        }

     if( error_out_data->fsymbol_pop != NULL )
        {
          fprintf(fp,"static char fsymbol_pop[] = \n   {");
          for( state=0;state<nos;state++ )
             if( !state )
                fprintf(fp,"%4d",(char)error_out_data->fsymbol_pop[state]);
             else
                {
                  if( !(state%16) )
                     fprintf(fp,"\n");
                  fprintf(fp,",%4d",(char)error_out_data->fsymbol_pop[state]);
                }
          fprintf(fp,"};\n\n");
        }

     if( error_out_data->rsymbol_pop != NULL )
        {
          fprintf(fp,"static char rsymbol_pop[] = \n   {");
          for( state=0;state<nos;state++ )
             if( !state )
                fprintf(fp,"%4d",(char)error_out_data->rsymbol_pop[state]);
             else
                {
                  if( !(state%16) )
                     fprintf(fp,"\n");
                  fprintf(fp,",%4d",(char)error_out_data->rsymbol_pop[state]);
                }
          fprintf(fp,"};\n\n");
        }

     if( error_out_data->fsymbol_scan != NULL )
        {
          fprintf(fp,"static char fsymbol_scan[] = \n   {");
          for( state=0;state<length;state++ )
             if( !state )
                fprintf(fp,"%4d",(char)error_out_data->fsymbol_scan[state]);
             else
                {
                  if( !(state%16) )
                     fprintf(fp,"\n");
                  fprintf(fp,",%4d",(char)error_out_data->fsymbol_scan[state]);
                }
          fprintf(fp,"};\n\n");
        }


     if( error_out_data->rsymbol_scan != NULL )
        {
          fprintf(fp,"static char rsymbol_scan[] = \n   {");
          for( state=0;state<length;state++ )
             if( !state )
                fprintf(fp,"%4d",(char)error_out_data->rsymbol_scan[state]);
             else
                {
                  if( !(state%16) )
                     fprintf(fp,"\n");
                  fprintf(fp,",%4d",(char)error_out_data->rsymbol_scan[state]);
                }
          fprintf(fp,"};\n\n");
        }

     if( error_out_data->fsymbol != NULL )
        {
          fprintf(fp,"static short fsymbol[] = \n   {");
          for( state=0;state<nos;state++ )
             if( !state )
                fprintf(fp,"%4d",(short)error_out_data->sx_code_list[
                                         error_out_data->fsymbol[state]]);
             else
                {
                  if( !(state%16) )
                     fprintf(fp,"\n");
                  fprintf(fp,",%4d",(short)error_out_data->sx_code_list[
                                             error_out_data->fsymbol[state]]);
                }
          fprintf(fp,"};\n\n");
        }

     if( !error_out_data->fsymbol_equal_rsymbol )
        {
          fprintf(fp,"static short rsymbol[] = \n   {");
          for( state=0;state<nos;state++ )
             if( !state )
                fprintf(fp,"%4d",(short)error_out_data->sx_code_list[
                                            error_out_data->rsymbol[state]]);
             else
                {
                  if( !(state%16) )
                     fprintf(fp,"\n");
                  fprintf(fp,",%4d",(short)error_out_data->sx_code_list[
                                              error_out_data->rsymbol[state]]);
                }
          fprintf(fp,"};\n\n");
        }


   }







static void Write_Error_Red( fp,error_out_data,user_data,extra_info )

   FILE                          *fp;  /* file pointer to the external
					  output file, where the error
					  recovery part of the parser
					  should be written                */
   struct user            *user_data;  /* internal interface vector, which
					  saves information fixed by the
					  user                             */
   struct error_out  *error_out_data;  /* pointer to a structure, which
					  stores all relevant data for the
					  error_code                       */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out      */

/* This function prints out the reduction part of the error automaton,
   a subset of the normal reduction part.
*/



   {

     struct red_out_code  *red_help_ptr;  /* used to search a reduction
					     code element                  */
     short                      count=1;  /* used to number the reduction
                                             code elements                 */

     if( extra_info )
	printf("begin of function Write_Error_Red( )\n");

     red_help_ptr = error_out_data->red_code;

     fprintf(fp,"             switch( -action )  {\n");

     while( red_help_ptr != NULL )
	{
          if( error_out_data->print_out[count] )
             {
               fprintf(fp,"\n");

	       fprintf(fp,"             case %d :\n",count );

	       Print_Normal_If( fp,user_data,red_help_ptr->eq_list,
			        red_help_ptr->number,"*sp","RED_F","F",
			        "F",((user_data->code_compression) ? 1 :
			       0),1,NULL,error_out_data->seman_list,extra_info );
             } /* end of if( error_out_... */
          count++;
	  red_help_ptr = red_help_ptr->next;
	} /* end of while( red_hel... */

     fprintf(fp,"              }\n");

     if( extra_info )
	printf("end of function Write_Error_Red( )\n");

   } /* end of function Write_Error_Red( ) */






static void Print_Pcc_Elem( fp,state,elem,first_call,extra_info)

   FILE                    *fp;  /* file pointer                          */
   short                 state;  /* state where the pop count conflict 
                                    occurs                                */
   struct pcc_elem       *elem;  /* pointer to the pop count conflict     */
   char             first_call,  /* used to decide if the function is 
                                    called first                          */
                    extra_info;  /* if extra_info == 1, then extra
			           information about begin and end
			            of function is printed out           */


/* If a pop count conflict occurs in the error recovery part, then this 
   function prints out the code, to solve the conflict.
*/


   {  
     short len;  /* loop index                                            */

     if( first_call )
        fprintf(fp,"                        if( action == %d )\n",state);
     else
        fprintf(fp,"                        else if( action == %d )\n",state);
     fprintf(fp,"                           {\n");
     if( elem->pop > 0 )
        fprintf(fp,"                             sp -= %d;\n",elem->pop);
     fprintf(fp,"                             if(");
     for( len=0;len<elem->number;len++ )
        {
          if( len )
             fprintf(fp,"                                ");
          fprintf(fp," (*sp == %d) %s\n",
                  elem->pointer[len],
                  ((len == elem->number-1) ? ")" : "||") );
        } /* end of for( len=0;len<... */
     fprintf(fp,"                                sp -= 1;\n");
     fprintf(fp,"                           }\n");
   }





static void Write_Error_Automaton( fp,error_out_data,user_data,extra_info )


   FILE                          *fp;  /* file pointer to the external
					  output file, where the error
					  recovery part of the parser
					  should be written                */
   struct user            *user_data;  /* internal interface vector, which
					  saves information fixed by the
					  user                             */
   struct error_out  *error_out_data;  /* pointer to a structure, which
					  stores all relevant data for the
					  error_code                       */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out      */


/* This function prints out the frame of the error recovery.
*/



   {
     short       state;  /* loop index                                     */
     char   first_call;  /* Used to decide if function Print_Pcc_Elem()
                            called first or not.                           */


     fprintf(fp,"LOOP :\n");
     fprintf(fp,"   action = state;\n");
     fprintf(fp,"   while(1)\n");
     fprintf(fp,"      {\n");
     fprintf(fp,"        if( action >= 0 )\n");
     fprintf(fp,"           {\n");
     fprintf(fp,"             choose = Error_Code( %s,\n",
            ((error_out_data->push != NULL) ?
            "((IS_TRUE( push,action )) ? 1 : 0)" : "0") );
     fprintf(fp,"                                  action,\n");
     fprintf(fp,"                                  %s,\n",
             (((error_out_data->fsymbol_sem1 != NULL) &&
               (error_out_data->rsymbol_sem1 != NULL)) ?
             "(IS_TRUE( visited,action )) ? fsymbol_sem1[action] : rsymbol_sem1[action]" :
              ((error_out_data->rsymbol_sem1 != NULL) ?
             "(IS_TRUE( visited,action )) ? -1 : rsymbol_sem1[action]" :
             ((error_out_data->fsymbol_sem1 != NULL) ?
             "fsymbol_sem1[action]" : "-1"))) );

     fprintf(fp,"                                  %s,\n",
             (((error_out_data->fsymbol_sem2 != NULL) &&
               (error_out_data->rsymbol_sem2 != NULL)) ?
             "(IS_TRUE( visited,action )) ? fsymbol_sem2[action] : rsymbol_sem2[action]" :
              ((error_out_data->rsymbol_sem2 != NULL) ?
             "(IS_TRUE( visited,action )) ? -1 : rsymbol_sem2[action]" :
              ((error_out_data->fsymbol_sem2 != NULL) ?
             "fsymbol_sem2[action]" : "-1"))) );
     fprintf(fp,"                                  %s,\n",
             (((error_out_data->fsymbol_pop != NULL) &&
               (error_out_data->rsymbol_pop != NULL)) ?
             "(IS_TRUE( visited,action )) ? fsymbol_pop[action] : rsymbol_pop[action]" :
              ((error_out_data->rsymbol_pop != NULL) ?
             "IS_TRUE( visited,action )) ? 0 : rsymbol_pop[action]" :
              ((error_out_data->fsymbol_pop != NULL) ?
             "fsymbol_pop[action]" : "0"))) );
     fprintf(fp,"                                  %s\n",
             (((error_out_data->fsymbol_scan != NULL) &&
               (error_out_data->rsymbol_scan != NULL)) ?
             "(IS_TRUE( visited,action )) ? " :
              ((error_out_data->rsymbol_scan != NULL) ?
             "(IS_TRUE( visited,action )) ?" :
             "((IS_TRUE( fsymbol_scan,action )) ?")) );
     fprintf(fp,"                                  %s\n",
             (((error_out_data->fsymbol_scan != NULL) &&
               (error_out_data->rsymbol_scan != NULL)) ?
             "((IS_TRUE( fsymbol_scan,action )) ? 1 : 0) :" :
              ((error_out_data->rsymbol_scan != NULL) ?
             "0 : ((IS_TRUE( rsymbol_scan,action )) ? 1 : 0)," :
             "1 : 0),")) );
     fprintf(fp,"%s",
             (((error_out_data->fsymbol_scan != NULL) &&
               (error_out_data->rsymbol_scan != NULL)) ?
             "                                  ((IS_TRUE( rsymbol_scan,action )) ? 1 : 0),\n" 
            :"") );

     fprintf(fp,"                                  %s );\n",
             ((!error_out_data->fsymbol_equal_rsymbol) ?
             "(IS_TRUE( visited,action )) ? fsymbol[action] : rsymbol[action]" :
             "fsymbol[action]") );


      fprintf(fp,"\n\n\n");
     if( !error_out_data->fsymbol_equal_rsymbol )
        {
          fprintf(fp,"             if( choose == 1 )\n");
          fprintf(fp,"                {\n");
          if( error_out_data->rsymbol_pcc_list != NULL )
             {
               fprintf(fp,"                 ");
               fprintf(fp,"if( rsymbol_pop[action] == -1 )\n");
               fprintf(fp,"                     {\n");
               first_call = TRUE;
               for( state=0;state<error_out_data->nos;state++ )
                  if( error_out_data->rsymbol_pcc_list[state] != NULL )
                     {
                       Print_Pcc_Elem( fp,state,
                                       error_out_data->rsymbol_pcc_list[state],
                                       first_call,extra_info );
                       first_call = FALSE;
                     }
               fprintf(fp,"                     }\n");
             }
          if( error_out_data->rsymbol_accept != -1 )
             {
               fprintf(fp,"                 ");
               fprintf(fp,"if( action == %d ) \n",error_out_data->rsymbol_accept);
               fprintf(fp,"                 ");
               fprintf(fp,"    if( run == 1 )\n");
               fprintf(fp,"                 ");
               fprintf(fp,"       { action = 0; anchor_set[%d] = pos; break; }\n",
                        error_out_data->eof );
               fprintf(fp,"                 ");
               fprintf(fp,"    else\n");
               fprintf(fp,"                 ");
               fprintf(fp,"       { action = 1; cont_state = %d; break; }\n",
                       error_out_data->rsymbol_accept );
             }
          fprintf(fp,"                 ");
          fprintf(fp,"action = rsymbol_action[action];\n");
          fprintf(fp,"                }\n");
          fprintf(fp,"             else if( choose == 2 )\n");
        }
     else
        fprintf(fp,"             if( choose == 2 )\n");

     fprintf(fp,"                {\n");
     if( error_out_data->fsymbol_pcc_list != NULL )
        {
          fprintf(fp,"                  ");
          fprintf(fp,"if( fsymbol_pop[action] == -1 )\n");
          fprintf(fp,"                      {\n");
          first_call = TRUE;
          for( state=0;state<error_out_data->nos;state++ )
             if( error_out_data->fsymbol_pcc_list[state] != NULL )
                {
                  Print_Pcc_Elem( fp,state,
                                  error_out_data->fsymbol_pcc_list[state],
                                  first_call,extra_info );
                  first_call = FALSE;
                }
          fprintf(fp,"                     }\n");
        }
     if( error_out_data->fsymbol_accept != -1 )
        {
          fprintf(fp,"                  ");
          fprintf(fp,"if( action == %d ) \n",error_out_data->fsymbol_accept);
          fprintf(fp,"                 ");
          fprintf(fp,"    if( run == 1 )\n");
          fprintf(fp,"                 ");
          fprintf(fp,"       { action = 0; anchor_set[%d] = pos; break; }\n",
                   error_out_data->eof );
          fprintf(fp,"                 ");
          fprintf(fp,"    else\n");
          fprintf(fp,"                 ");
          fprintf(fp,"       { action = 1; cont_state = %d;  break; }\n",
                  error_out_data->fsymbol_accept );
        }
     fprintf(fp,"                  ");
     fprintf(fp,"action = fsymbol_action[action];\n");
     fprintf(fp,"                }\n");
     fprintf(fp,"             else\n");
     fprintf(fp,"                { action = 1; break; }\n");


     fprintf(fp,"           }\n\n\n");

     fprintf(fp,"        if( action < 0 )\n");
     fprintf(fp,"           {\n");
     Write_Error_Red( fp,error_out_data,user_data,extra_info );
     fprintf(fp,"           }\n");
     fprintf(fp,"      }\n");

     fprintf(fp,"   if( action ) goto JUMP_BACK;\n");



   }








void Write_Error_Recovery( user_data,error_out_data,extra_info )


   struct user            *user_data;  /* internal interface vector, which
					  saves information fixed by the
					  user                             */
   struct error_out  *error_out_data;  /* pointer to a structure, which
					  stores all relevant data for the
					  error_code                       */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out      */

/* This function controls the printing of the whole error recovery. The 
   user can choose between two kinds of error recovery :
   (1) stop at first error and
   (2) the automatic error correction by Roehrich.
*/



   {

     FILE  *fp;  /* file pointer to the external output file, where the
		    error recovery part of the parser should be written    */

     if( extra_info )
	printf("begin of function Write_Error_Recovery( )\n");

     if( user_data->automatic_error_correction )
	{
          if( (user_data->direct_struct_connection)  &&
              (user_data->automatic_error_correction) )
             {
               if( (fp = fopen( "semantic_productions.h","w" )) == NULL )
                  Error_Message( _WRITE_ERROR_RECOVERY,MODULE_WRITE_ERROR,
                                 NOT_OPEN_FILE,ABORT," sema_prods.h" );
               Write_Semantic_Code( fp,error_out_data->nop,
                                    error_out_data->seman_list,
                                    error_out_data->seman_out,extra_info );
               fclose( fp );

             } /* end of if( (user_data->d... */
	  if( (fp = fopen( "error_var.h","w" )) == NULL )
	     Error_Message( _WRITE_ERROR_RECOVERY,MODULE_WRITE_ERROR,
                            NOT_OPEN_FILE,ABORT," error_var.h" );

	  Write_Var( fp,error_out_data,extra_info );

	  close( fp );

	  
	  if( (fp = fopen( "error_recovery.h","w" )) == NULL )
	     Error_Message( _WRITE_ERROR_RECOVERY,MODULE_WRITE_ERROR,
                            NOT_OPEN_FILE,ABORT," error_recovery.h" );

	  Write_Static_Var( fp,error_out_data,user_data,extra_info );
	  fprintf(fp,"\n\n\n");

	  Write_Error_Tabs( fp,error_out_data,extra_info );


	  close( fp );


	  if( (fp = fopen( "error_body.h","w" )) == NULL )
	     Error_Message( _WRITE_ERROR_RECOVERY,MODULE_WRITE_ERROR,
                            NOT_OPEN_FILE,ABORT," error_body.h" );

	  Write_Error_Body( fp,error_out_data,user_data,extra_info );

	  close( fp );

	  if( (fp = fopen( "parser.c","a" )) == NULL )
	     Error_Message( _WRITE_ERROR_RECOVERY,MODULE_WRITE_ERROR,
                            NOT_OPEN_FILE,ABORT," parser.c" );

	  fprintf(fp,"\n\n\n");

	  Write_Error_Mark( fp,error_out_data,user_data,extra_info );

	  fprintf(fp,"\n\n\n");

          Write_Error_Automaton( fp,error_out_data,user_data,extra_info );

	  fprintf(fp,"\n\n\n");

          fprintf(fp,"#include \"error_body.h\"\n\n");

	  fprintf(fp,"\n\n\n");

	  Write_Choice_List( fp,error_out_data->nos,user_data,extra_info );

	  fprintf(fp,"\n\n\n");

	} /* end of if( user_data->... */
     else
	{
	  if( (fp = fopen( "parser.c","a" )) == NULL )
	     Error_Message( _WRITE_ERROR_RECOVERY,MODULE_WRITE_ERROR,
                            NOT_OPEN_FILE,ABORT," parser.c" );

	  Write_Stop_At_First_Error( fp,extra_info );

	  fprintf(fp,"\n\n\n");

	} /* end of else ( if( user_data->... ) */

     fprintf(fp,"}\n");
     fclose( fp );

     if( extra_info )
	printf("end of function Write_Error_Recovery( )\n");

   } /* end of function Write_Error_Recovery( ) */
