/***************************************************************************/
/* filename : read_data.c                          first edit  : 22.05.91  */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change : 01.08.91  */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.1 $ */
static char rcsid[] = "$Id: read_data.c,v 1.1 1992/01/10 14:38:40 cogito Exp $";


/*************************** INCLUDE - FILES *******************************/

typedef short *readtype[];

#include<stdio.h>

#include "over_types.h"

#include "rd_absprs.h"

#include "comar.h"

#include "prsiface.h"

#include "sema_prods.h"

#include "seman.h"

#include "errors.h"


/***************************** FUNCTIONS **********************************/

 readtype *Read_Data( quick_data,seman_data,comar_name,absprs_name,
                      extra_info )

    readtype       *quick_data;  /* interface vector to optimization       */
    struct seman   *seman_data;  /* vector which saves the semantic 
                                    actions                                */
    char            extra_info,  /* if extra_info == 1, then extra 
                                    information about begin and end
                                    of function is printed out             */
                   *comar_name,  /* Name of the comar and the abstract     */
                  *absprs_name;  /* parser file which saved all informa-
                                    tion about the grammar                 */

/* This function controls the whole input module, which is adopted from
   Chrisian Zeitel! To get more information about the input module,
   have a look to his sources.
*/



   {
     FILE               *fp_comar,  /* file pointer to the comar file      */
  	             *fp_prsiface;  /* file pointer to the abstract parser
                                       file                                */
     p_comar           Comar_root;  /* root of the comar tree              */
     absparsertype     Abs_parser;  /* root of the abstract parser tree    */

     if( extra_info )
	printf("begin of function Read_Data()\n");

     if( (fp_comar = fopen(comar_name,"r")) == NULL)
        Error_Message( _READ_DATA,MODULE_READ_DATA,NOT_OPEN_FILE,ABORT,
                       comar_name );
     if( (fp_prsiface = fopen(absprs_name,"r")) == NULL)
        Error_Message( _READ_DATA,MODULE_READ_DATA,NOT_OPEN_FILE,ABORT,
                       absprs_name );
     Comar_root = INPUT(fp_comar);
     fclose(fp_comar);

     Abs_parser = ReadAbsparser(fp_prsiface);
     fclose(fp_prsiface);

     quick_data  = rd_absprs( quick_data,Comar_root,Abs_parser,1,extra_info );

     if( (seman_data->seman_list = (char_ptr*) calloc( 
                         *((*quick_data)[5]),sizeof( char_ptr ) )) == NULL )
        Error_Message( _READ_DATA,MODULE_READ_DATA,NO_SPACE_FOR_VECTOR,ABORT,
                       " seman_data->seman_list" );

     Build_Reverse_Prod_List( quick_data,seman_data,0 );

     Get_Connections( Comar_root,seman_data,extra_info );

     if( extra_info )
	printf("end of function Read_Data()\n");

     return( quick_data );

   } /* end of function Read_Data() */  




  
