/***************************************************************************/
/* filename : other_optim.c                        first edit  : 08.02.91  */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change : 20.08.91  */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.1 $ */
static char rcsid[] = "$Id: other_optim.c,v 1.1 1992/01/10 14:38:40 cogito Exp $";


/*************************** INCLUDE - FILES *******************************/

typedef short *readtype[];


#include<stdio.h>

#include<malloc.h>

#include "over.h"

#include "errors.h"

#include "over_types.h"

#include "determ.h"

#include "other.h"


/************************* GLOBAL - VARIABLES ******************************/



static short                 *pos,  /* vector to save the current position
				       of each vector of adj_list          */
		  *number_of_arcs,  /* save the number of edges for every
				       vertex to every other vertices      */
		       *save_numb,  /* save the number of arcs if the
				       reverse adjacent list is to be built */
		      *descendant,  /* save for each vertex the number of
				       descendants in the depth first search
				       tree                                */
		       *df_number,  /* the depth first search numbering    */
		 *recursive_order,  /* The recursive order is a special num-
				       bering of the vertices. The number is
				       needed to determine the strongly con-
				       nected components.                  */
			 rec_numb   /* the initial number of recursive     */
			      = 0,  /* order                               */
			    count   /* the initial number of the depth     */
			      = 0;  /* first search numbering              */

struct pbe        *pos_back_edges,  /* a list of possible back edges       */
			*help_ptr;  /* pointer which is used to determine
				       the possible back edges             */

static char                 *mark,  /* vector to decide if a vertex is
				       visited or not                      */
		      *del_vertex,
			 *scc_set;  /* Marks the vertices which are in the
				       current strong connected component.
				       A depth first search run will be
				       started only on these vertices      */
static readtype         *adj_list,  /* the adjacent list of the origin
				       or reverse graph                    */
		       *save_list;  /* saves the adjacent list when the
				       reverse adjacent list will be built */




/******************************* FUNCTIONS *********************************/


static short DFS( vertex,extra_info )

   short      vertex;  /* vertex on which the depth first search will be
			  started                                          */
   char   extra_info;  /* if extra_info == 1, then extra information
			  about begin and end of function is printed out   */

/* Here, a depth-first search traversal on the current graph is built. All
   vectors used are global variables. This DFS is used to find all back
   edges, so the number of descendants of all vertices in the DFS spanning
   tree must be determined too.
*/


   {
     if( extra_info )
	printf("begin of function DFS()\n");

     mark[vertex] = TRUE;
     df_number[vertex] = count++;
     for( ;pos[vertex]<number_of_arcs[vertex];pos[vertex]++ )
	if( !del_vertex[(*adj_list)[vertex][pos[vertex]]] )
	   if( !mark[(*adj_list)[vertex][pos[vertex]]] )
	      {
		descendant[vertex] += DFS( (*adj_list)[vertex][pos[vertex]],
					    extra_info ) + 1;
	      } /* end of if( !mark[(*adj... */
	   else
	      if( df_number[vertex]>=
		  df_number[(*adj_list)[vertex][pos[vertex]]] )
		 {
		   if( (help_ptr = (struct pbe*) calloc(
				       1,sizeof( struct pbe ) )) == NULL )
			 Error_Message( _DFS,MODULE_OTHER_OPTIM,
                                        NO_SPACE_FOR_STRUCTURE,ABORT,
                                        " help_ptr" );

		   /* save possible back edges */
		   help_ptr->origin      = vertex;
		   help_ptr->destination = (*adj_list)[vertex][pos[vertex]];
		   help_ptr->next        = pos_back_edges;
		   pos_back_edges        = help_ptr;
		 } /* end of if( df_number[v... */

     if( extra_info )
	printf("end of function DFS()\n");
     return( descendant[vertex] );

   } /* end of function DFS() */





static void Control_DFS( nos,extra_info )

   short         nos;  /* number of states                                */
   char   extra_info;  /* if extra_info == 1, then extra information
			  about begin and end of function is printed out  */

/* This function controls the depth first search. Even if the graph is
   connected, DFS doesn't guarantee that all vertices are visited. This
   function is used to give this guarantee.
*/

   {
     short  state,  /* loop index                                          */
	     help;  /* variable to save the return value		   */


     if( extra_info )
	printf("begin of function Ctr_DFS()\n");

     for( state=0;state<nos;state++ )
	if( !mark[state] )
	   help = DFS( state,extra_info );

     if( extra_info )
	printf("end of function Ctr_DFS()\n");

   } /* end of function Ctr_DFS() */





void Det_Back_Edges( extra_info )

   char   extra_info;  /* if extra_info == 1, then extra information
			  about begin and end of function is printed out  */

/* If the depth first number of vertex w is greater than or equal to
   vertex v, it is possible, that w is a back edge.  w is a real back
   edge if v plus the number of descendants of v is greater or equal df
   number of w. A back edge free graph has no cycles(!), so v will be
   deleted here.
*/

   {
     struct pbe* ptr;  /* help pointer, to visit all possible back edges   */


     if( extra_info )
	printf("begin of function Det_Back_Edges()\n");

     ptr = pos_back_edges;
     while( ptr != NULL )
	{
	  if( (df_number[ptr->destination] <=
	       df_number[ptr->origin]        ) &&
	      (df_number[ptr->origin]      <=
	       df_number[ptr->destination]+
		descendant[ptr->destination]  ) )
		    del_vertex[ptr->destination] = TRUE;
	  ptr = ptr->next;
	} /* end of while( ptr != N... */

     if( extra_info )
	printf("end of function Det_Back_Edges()\n");

   } /* end of function Det_Back_Edges() */





static void Build_Adjacent_List( quick_data,min_push,extra_info )


   readtype  *quick_data;  /* interface vector to optimization             */
   char        *min_push,
	      extra_info;  /* if extra_info == 1, then extra information
			      about begin and end of function is printed
			      out                                          */

/* The graph is saved in a table-oriented abstract data type with extra
   information. This is a bad structure for a depth first search traversal,
   so here the graph is saved in an adjacent list.
*/

   {
     short               nos,  /* number of states         	           */
			 nox,  /* number of terminals or nonterminals      */
		       *xtab,  /* N - table or T - table representation    */
			symb,  /* count - variable for terminals           */
		       state,  /* count - variable for states              */
			numb,  /* variable to decide, if T - or N - table
				  run is started                           */
		   *help_ptr;  /* help pointer, to save the incident
				  vertices                                 */




     if( extra_info )
	printf("begin of Build_Adjacent_List()\n");

     nos = *((*quick_data)[9]);

     for( numb=0;numb<=1;numb++ )
	{
	  if( numb )
	     {
	       /* the T - table entries are read */
	       nox  = *((*quick_data)[0]);
	       xtab = (*quick_data)[1];
	     } /* end of if( numb ) */
	  else
	     {
	       /* the T - table entries are read */
	       nox  = *((*quick_data)[3]);
	       xtab = (*quick_data)[4];
	     } /* end of else ( if( numb ) ) */





	  for( state=0;state<nos;state++ )
	     {
	       /* search shift entries in N - or T - table and count
		  for each state the outgoing vertices */
               symb = 0;
               while( (symb<nox) && (number_of_arcs[state] >= 0) )
                  {
		    if( ((numb  && (IS_SHIFTACT( xtab[state*nox+symb] )))    ||
		         (!numb && (IS_SHIFT_NTACT( xtab[state*nox+symb] )))) )
	               if( state != OPERAND( xtab[state*nox+symb] ) )
		          number_of_arcs[state]++;
		       else
			  if( min_push[state] )
			     number_of_arcs[state] = -1;
                    symb++;
                  } /* end of while( (symb... */
	       if( number_of_arcs[state] < 0 )
		  {
		    /* a push state with self loop is automatcally
		       a stack control state */
		    del_vertex[state]     = TRUE;
		    mark[state]           = TRUE;
		  } /* end of if( number */
	     } /* end of for( state=0;st... */
	} /* end of for( numb=0;num... */

     /* allocate storage space for the outgoing edges of each state and
	fill the storage space with the inzident states */
     for( state=0;state<nos;state++ )
	{
	  if( number_of_arcs[state]  > 0 )
	     {
	       if(( (*adj_list)[state] = (short*) calloc(
				     number_of_arcs[state],sht )) == NULL )
		  Error_Message( _BUILD_ADJACENT_LIST,MODULE_OTHER_OPTIM,
                                 NO_SPACE_FOR_VECTOR,ABORT,
                                 " (*adj_list)[state]" );
	       help_ptr = (*adj_list)[state];
	       for( numb=0;numb<=1;numb++ )
		  {
		    if( numb )
		       {
			 nox  = *((*quick_data)[0]);
			 xtab = (*quick_data)[1];
		       } /* end of if( numb ) */
		    else
		       {
			 nox  = *((*quick_data)[3]);
			 xtab = (*quick_data)[4];
		       } /* end of else ( if( numb ) ) */
		    for( symb=0;symb<nox;symb++ )
		    if( ((numb  &&
			 (IS_SHIFTACT( xtab[state*nox+symb] ))) ||
			 (!numb &&
			 (IS_SHIFT_NTACT( xtab[state*nox+symb] )))) &&
			(state != OPERAND( xtab[state*nox+symb] )) )
			   *(help_ptr++) = OPERAND( xtab[state*nox+symb] );
		  } /* end of for( numb=0;num... */
	     } /* end of if( number_of_a... */
	  else
	     (*adj_list)[state] = NULL;
	} /* end of for( state=0;st... */

     if( extra_info )
	printf("end of Build_Adjacent_List()\n");

   } /* end of Build_Adjacent_List() */





static void Reverse_Adjacent_List( quick_data,extra_info )

   readtype  *quick_data;  /* interface vector to optimization             */
   char       extra_info;  /* if extra_info == 1, then extra information
			      about begin and end of function is printed
			      out                                          */

/* If the strong connected components of a graph are to be built, you need
   the reverse representation of the graph. That means if there exists an
   edge from v to w in the graph then there exists an edge from w to v in
   the reverse graph.  The adjacent list of the reverse graph will be
   built here.
*/

   {
     short      	 nos,  /* number of states                         */
		       state,  /* loop index for states                    */
			vert,  /* loop index for edges                     */
		    *act_pos,  /* the actual position in rev_list          */
	       *reverse_arcs;  /* used to count the reverse arcs for each
				  vertex                                   */
     readtype      *rev_list;  /* representation of the reverse graph      */



     if( extra_info )
	printf("begin of function Reverse_Adjacent_List()\n");

     nos = *((*quick_data)[9]);

     if( (( rev_list        = (readtype*) calloc(
				     nos,sizeof( short *)))  == NULL ) ||
	 ((act_pos      = (short *)       calloc( nos,sht )) == NULL ) ||
	 ((reverse_arcs = (short *)       calloc( nos,sht )) == NULL ) )
	     Error_Message( _REVERSE_ADJACENT_LIST,MODULE_OTHER_OPTIM,
                            NO_SPACE_FOR_VECTOR,ABORT," reverse_arcs" );

     /* count the reverse arcs with help of adjazent list */
     for( state=0;state<nos;state++ )
	for( vert=0;vert<number_of_arcs[state];vert++ )
	   reverse_arcs[(*adj_list)[state][vert]]++;

     /* the storage space will be allocate */
     for( state=0;state<nos;state++ )
	if( reverse_arcs[state] )
	   {
	     if(( (*rev_list)[state] = (short*) calloc(
				       reverse_arcs[state],sht )) == NULL )
		Error_Message( _REVERSE_ADJACENT_LIST,MODULE_OTHER_OPTIM,
                               NO_SPACE_FOR_VECTOR,ABORT," (*rev_list)[state]");
	   } /* end of if( reverse_arc... */

     for( state=0;state<nos;state++ )
	for( vert=0;vert<number_of_arcs[state];vert++ )
	   {
	     (*rev_list)[(*adj_list)[state][vert]]
			[act_pos[(*adj_list)[state][vert]]] = state;
	     act_pos[(*adj_list)[state][vert]]++;
	   } /* end of for( vert=0;ver... */

      save_numb      = number_of_arcs;
      number_of_arcs = reverse_arcs;
      save_list      = adj_list;
      adj_list       = rev_list;

     if( extra_info )
	printf("end of function Reverse_Adjacent_List()\n");

   } /* end of function Reverse_Adjacent_List() */





static void DFS_SCC( vertex,extra_info )

   short      vertex;  /* vertex where the depth first search will be
			  started                                          */
   char   extra_info;  /* if extra_info == 1, then extra information
			  about begin and end of function is printed out   */

/* This depth first search is used to determine the strongly connected
   components. Here other extra information is used as in function DFS()
   mentioned above.
*/

   {
     if( extra_info )
	printf("begin of function DFS_SCC()\n");

     mark[vertex] = TRUE;
     for( ;pos[vertex]<number_of_arcs[vertex];pos[vertex]++ )
	if( scc_set[(*adj_list)[vertex][pos[vertex]]] )
	   if( !mark[(*adj_list)[vertex][pos[vertex]]] )
	      DFS_SCC( (*adj_list)[vertex][pos[vertex]],extra_info );
     if( recursive_order != NULL )
	     recursive_order[vertex] = ++rec_numb;

     if( extra_info )
	printf("end of function DFS_SCC()\n");

   } /* end of function DFS_SCC() */





static void Ctr_DFS_SCC( nos,extra_info )

   short         nos;  /* number of states                                 */
   char   extra_info;  /* if extra_info == 1, then extra information
			  about begin and end of function is printed out  */

/* This function controls the depth first search of function DFS_SCC, as in
   the function Control_DFS above.
*/

   {
     short  state;  /* loop index for states                               */

     if( extra_info )
	printf("begin of function Ctr_DFS_SCC()\n");

     for( state=0;state<nos;state++ )
	if( !mark[state] && scc_set[state] )
	   DFS_SCC( state,extra_info );

     if( extra_info )
	printf("end of function Ctr_DFS_SCC()\n");

   } /* end of function Ctr_DFS_SCC() */





static struct scc *SCC( scc_ptr,nos,save_mark,min_push,extra_info )

   short               nos;  /* number of states                           */
   char         *save_mark,  /* saves the visited vertices                 */
		 *min_push,  /* the states which must be pushed            */
		extra_info;  /* if extra_info == 1, then extra information
				about begin and end of function is printed
				out                                        */
   struct scc     *scc_ptr;  /* pointer to save the strongly connected
				components                                 */


/* This function determines for a given graph or subgraph all strongly con-
   nected components ( scc ). If more than one vertex is an element of this
   scc and there is a push state on it, then one push state will be deleted
   and the new scc will be saved. Otherwise the scc will be neglected.
*/


   {
     short       *rec_order,  /* save the recursive order of all vertices  */
			max,  /* used to determine the greatest number in
				 rec_order                                 */
		  max_state   /* save the corresponding state              */
			= -1,
		      state,  /* loop index for states                     */
		  *help_ptr;  /* used to allocate storage space for a scc  */
     struct scc   *help_scc;  /* used to integrate the current scc in the
				 scc list                                  */
     char                mp;  /* used to find push states in scc's         */



     if( extra_info )
	printf("begin of function SCC()\n");

     rec_order = recursive_order;
     recursive_order = NULL;

     /* initialize the used data structure */
     for( state=0;state<nos;state++ )
	{
	  pos[state]            = 0;
	  save_mark[state]      = FALSE;
	  mark[state]           = FALSE;
	} /* end of for( state=0;st... */


     max = 1;
     while( max )
	{
	  /* determine the state which isn't marked and is
	     bound to the greatest recursion number */
	  max = 0;
	  for( state=0;state<nos;state++ )
	     {
	       if( (max<rec_order[state]) &&
		   !mark[state]           )
		  {
		    max       = rec_order[state];
		    max_state = state;
		  } /* end of if( (max<rec_or... */
	       save_mark[state] = save_mark[state] || mark[state];
	     } /* end of for( state=0;st... */
	  if( max )
	     {
	       /* make a depth first search traverse on the subgraph,
		  started with the determined state */
	       DFS_SCC( max_state,extra_info );
	       count = 0;
	       mp    = FALSE;

	       /* test if the new scc has push states on it */
	       for( state=0;state<nos;state++ )
		  if( mark[state] && !save_mark[state] )
		     {
		     count++;
		     if( min_push[state] )
			mp = TRUE;
		     } /* end of if( mark[state]... */

	       /* if scc is greater 1 and a push state is on it,
		  than save the scc without one push state */
	       if( (count > 1) && mp )
		  {
		    mp = FALSE;

		    if( ((help_ptr = (short *)      calloc(
						   count,sht ))  == NULL) ||
			((help_scc = (struct scc *) calloc(
				       1,sizeof( struct scc ) )) == NULL) )
			   Error_Message( _SCC,MODULE_OTHER_OPTIM,
                                          NO_SPACE_FOR_STRUCTURE,ABORT,
                                          " help_scc" );

		    help_scc->elem = help_ptr;
		    (*help_ptr)    = count-1;
		    for( state=0;state<nos;state++ )
		       if( mark[state] && !save_mark[state] )
			  if( mp )
			     (*(++help_ptr)) = state;
			  else
			     if( min_push[state] )
				{
				  mp = TRUE;
				  del_vertex[state] = TRUE;
				} /* end of if( min_push[st... */
			     else
				(*(++help_ptr)) = state;

		    help_scc->next = scc_ptr;
		    scc_ptr        = help_scc;
		  } /* end of if( (count > 1)... */

	     } /* end of if( max ) */
	} /* end of while( max ) */
     recursive_order = rec_order;

     if( extra_info )
	printf("end of function SCC()\n");

     return( scc_ptr );

   } /* end of function SCC() */





static void Ctr_SCC( quick_data,min_push,extra_info )

   readtype  *quick_data;  /* interface vector to optimization             */
   char        *min_push,  /* the states which must be pushed              */
	      extra_info;  /* if extra_info == 1, then extra information
			      about begin and end of function is printed
			      out                                          */

/* This function controls the scc determination. Function SCC integrates
   new scc's into the scc list. Determination goes on until the scc list
   is empty. For each scc, a subgraph of the original graph, the recursive
   number of each state must first be determined. Then, a new scc determi-
   nation, on the subgraph, can be started.
*/

   {
     short            state,  /* loop index for states                     */
			nos,  /* number of states                          */
		 *help_numb;  /* saves the number of arcs of the origin
				 graph or the reverse graph                */
     char        *save_mark;  /* saved the marked vertices                 */
     struct scc    *scc_ptr,  /* pointer to scc list                       */
		  *help_scc;  /* used to get the first scc                 */
     readtype    *help_list;  /* saves the current adjacent list of the
				 origin graph or the reverse graph         */



     if( extra_info )
	printf("begin of function Ctr_SCC()\n");

     nos = *((*quick_data)[9]);


     if( (save_mark = (char *) calloc( nos,sizeof( char ) )) == NULL )
	Error_Message( _CTR_SCC,MODULE_OTHER_OPTIM,NO_SPACE_FOR_VECTOR,
                       ABORT," save_mark" );

     scc_ptr = NULL;
     scc_ptr = SCC( scc_ptr,nos,save_mark,min_push,extra_info );
     while( scc_ptr != NULL )
	{
	  rec_numb = 0;
	  for( state=0;state<nos;state++ )
	     {
	       scc_set[state]         = FALSE;
	       recursive_order[state] = 0;
	       mark[state]            = 0;
	       pos[state]             = 0;
	     } /* end of for( state=0;st... */
	  help_scc = scc_ptr;
	  scc_ptr = scc_ptr->next;
	  help_scc->next = NULL;
	  count = help_scc->elem[0];
	  for( state=1;state<=count;state++ )
	     scc_set[help_scc->elem[state]] = TRUE;
	  /* let adj_list be the origin graph */
	  help_numb      = number_of_arcs;
	  number_of_arcs = save_numb;
	  save_numb      = help_numb;
	  help_list      = adj_list;
	  adj_list       = save_list;
	  save_list      = help_list;

	  Ctr_DFS_SCC( nos,extra_info );

	  /* let adj_list be the reverse graph */
	  help_numb      = number_of_arcs;
	  number_of_arcs = save_numb;
	  save_numb      = help_numb;
	  help_list      = adj_list;
	  adj_list       = save_list;
	  save_list      = help_list;

	  scc_ptr = SCC( scc_ptr,nos,save_mark,min_push,extra_info );

	} /* end of while( scc_ptr ... */

     /* let adj_list be the origin graph */
     help_numb      = number_of_arcs;
     number_of_arcs = save_numb;
     save_numb      = help_numb;
     help_list      = adj_list;
     adj_list       = save_list;
     save_list      = help_list;


     if( extra_info )
	printf("end of function Ctr_SCC()\n");

   } /* end of function Ctr_SCC() */





static short Det_Longest_Path( nos,min_push,extra_info )

   short        nos ;  /* number of states 			           */
   char    *min_push,  /* vector which saves for each state if it must be
			  pushed or not                                    */
	  extra_info;  /* if extra_info == 1, then extra information about
			  begin and end of function is printed out        */


/* This function determines the longest path in the new graph, which is
   a subset of the original graph. The new graph is the origin graph without
   the stack check states. By determination only push states are counted!
*/


   {
     short   state,  /* loop index for states                              */
	      vert,  /* loop index for edges                               */
	      numb   /* used to determine the longest path                 */
		=0,
	   *pushes,  /* used to determine for each push state, how many
			push states are predecessors on the path           */
	     count;  /* loop index                                         */


     if( extra_info )
	printf("begin of function Det_Longest_Path()\n");

     if( (pushes = (short*) calloc( nos,sizeof( short ) )) == NULL )
	Error_Message( _DET_LONGEST_PATH,MODULE_OTHER_OPTIM,
                       NO_SPACE_FOR_VECTOR,ABORT," pushes" );


     /* mark the push states */
     for( state=0;state<nos;state++ )
	if( min_push[state] )
	   pushes[state] = 1;


     /* determine the path with the most push states on it */
     for( count=0;count<nos;count++ )
	{
	  numb++;
	  for( state=0;state<nos;state++ )
	     if( !del_vertex[state] )
		for( vert=0;vert<number_of_arcs[state];vert++ )
		   if( !del_vertex[(*adj_list)[state][vert]] )
		      {
			if( pushes[(*adj_list)[state][vert]] <=
			    pushes[state] )
			    if( min_push[(*adj_list)[state][vert]] )
			       pushes[(*adj_list)[state][vert]] =
							  pushes[state] +1;
			    else
                               pushes[(*adj_list)[state][vert]] =
							  pushes[state];

		      }  /* end of if( !del_vert... */
	} /* end of for( count=0;co... */

     numb = 0;
     for( state=0;state<nos;state++ )
	if( numb < pushes[state] )
	   numb = pushes[state];

     if( extra_info )
	printf("end of function Det_Longest_Path()\n");

     return( numb );

   } /* end of function Det_Longest_Path() */





void Other_Optim( quick_data,user_data,changed_data,extra_info )

   readtype        *quick_data;  /* interface vector to optimization       */
   struct user      *user_data;  /* structure which saves information
				    fixed by the user                      */
   char	            extra_info;  /* if extra_info == 1, then extra infor-
				    mation about begin and end of func-
				    tion are printed out                   */
   struct inter  *changed_data;  /* internal interface between the opti-
				    mization moduls                        */


/* This function controls the determination of the stack control states.
   The user could choose two different ways, for determination.
   First the determination with the depth first search, where one vertex
   for each back edge is a stack control state.
   Second the determination with the strong connected components, where
   one vertex for each strong connected component is a stack control state,
   if and only if the scc includes a push state as an element.
*/

   {
     short          nos,  /* number of states                              */
		  state,  /* loop index for states                         */
	      long_path;  /* saves the longest path                        */
     char     *min_push;  /* vector which saves for each state if it must
			     be pushed or not                              */

#ifdef TESTOPT
     FILE           *fp;  /* file pointer                                  */
     char         first   /* used to decide, if the first symbol is
                             printed                                       */
		 = TRUE,
		    len   /* used to decide when a line break takes place  */
		    = 1;
#endif



     if( extra_info )
	printf("begin of function Other_Optim()\n");

     min_push = changed_data->min_push;
     nos = *((*quick_data)[9]);

     if((( adj_list        = (readtype*) calloc(
				     nos,sizeof( short *))) == NULL ) ||
	(( number_of_arcs  = (short*)    calloc( nos,sht )) == NULL ) ||
	(( pos             = (short*)    calloc( nos,sht )) == NULL ) ||
	(( del_vertex      = (char*)     calloc(
				     nos,sizeof( char ) ))  == NULL ) ||
	(( mark            = (char*)     calloc(
				     nos,sizeof( char ) ))  == NULL ) )
	      Error_Message( _OTHER_OPTIM,MODULE_OTHER_OPTIM,
                             NO_SPACE_FOR_VECTOR,ABORT," mark" );

     if( !user_data->scc_or_dfs && user_data->stack_check )
	{ /* dfs is started */
	  if( (( descendant = (short*) calloc( nos,sht )) == NULL ) ||
	      (( df_number  = (short*) calloc( nos,sht )) == NULL ) )
		 Error_Message( _OTHER_OPTIM,MODULE_OTHER_OPTIM,
                                NO_SPACE_FOR_VECTOR,ABORT," df_number");

	  pos_back_edges = NULL;

	  Build_Adjacent_List( quick_data,min_push,extra_info );

	  Control_DFS( nos,extra_info );

	  Det_Back_Edges( extra_info );

	} /* end of if( user_data->scc_or_dfs ) */

     else
	if( user_data->stack_check )
	   { /* scc is started */
	     if( ((scc_set         = (char *) calloc(
				     nos,sizeof( char ) )) == NULL) ||
		 ((recursive_order = (short*) calloc(
				     nos,sht ))            == NULL) )
		Error_Message( _OTHER_OPTIM,MODULE_OTHER_OPTIM,
                               NO_SPACE_FOR_VECTOR,ABORT," recursive_order" );

	     for( state=0;state<nos;state++ )
		scc_set[state]        = TRUE;

	     Build_Adjacent_List( quick_data,min_push,extra_info );

	     Ctr_DFS_SCC( nos,extra_info );

	     Reverse_Adjacent_List( quick_data,extra_info );

	     Ctr_SCC( quick_data,min_push,extra_info );

	   } /* end of else ( if( user_data->scc_or_dfs ) ) */

     if( user_data->stack_check )
	long_path = Det_Longest_Path( nos,min_push,extra_info );
     else
	{
	  for( state=0;state<nos;state++ )
	     del_vertex[state] = TRUE;
	  long_path = 1;
	} /* end of else ( if( user_data->... ) */

      changed_data->stack_check_states = del_vertex;
      changed_data->longest_path       = long_path;



#ifdef TESTOPT

     fp = fopen("OTHER.wrt","w");

     fprintf(fp,"\n\n");

     if( !user_data->scc_or_dfs )
	{
	  fprintf(fp,"The following results are determined by a depth ");
	  fprintf(fp,"first search run\n");
	  fprintf(fp,"on the graph! \n");
	} /* end of if( !user_data-... */
     else
	{
	  fprintf(fp,"The following results are obtained by a ");
	  fprintf(fp,"determination of all strong connected\n");
	  fprintf(fp,"components of the graph! \n");
	} /* end of else ( if( !user_data-... ) */
     fprintf(fp,"\n\n");

     fprintf(fp,"The stack check states are :\n");
     for( state=0;state<nos;state++ )
	if( del_vertex[state] )
	   {
	     if( first )
		{
		  first = FALSE;
		  fprintf(fp,"    %-4d",state);
		} /* end of if( first ) */
	     else
		fprintf(fp,", %-4d",state);
	     if( ++len > 16 )
		{
		  fprintf(fp,"\n");
		  len = 1;
		  first = TRUE;
		} /* end of if( ++len > 16 ) */
	   } /* end of if( del_vertex[... */
     fprintf(fp,"\n\n\n");
     fprintf(fp,"The path with the most push states in the subgraph, ");
     fprintf(fp,"where the stack check\n");
     fprintf(fp,"states are omitted, is : %d",long_path);

     fclose(fp);
#endif

   if( extra_info )
      printf("end of function Other_Optim()\n");

   } /* end of function Other_Optim() */



