# $Id: mkmsg.awk,v 1.3 1989/10/18 15:57:05 waite Exp $
# Copyright, 1989, The Regents of the University of Colorado
#
# mkmsg - awk message script for message utilities.
#
# Author:
#	R. G. Plummer		March 1986
#	Modified:
#	Ali Bahrami		July 31, 1987
#
# Abstract:
#	mkmsg takes a message file xxxx as input, and creates output
#	files msg_codes.h (symbolic constant definitions) and msg_arr.c 
#	(message string declarations). The first is included by message.h,
#	while the second is included by message.c .
#

BEGIN		{ FS = sprintf("\t"); DC = 0 ;
		  HFIL = "msg_codes.h";
		  CFIL = "msg_arr.c";
		  printf("/**** message code file ****/\n\n") >HFIL ;
		  printf("#ifndef MSG_DEF\n") >HFIL ;
		  printf("#define MSG_DEF\n\n") >HFIL ;
		  printf("/**** message string declarations ****/\n\n") >CFIL
		}

/^\/\*|^ \*\/|^ \*/ { }

/^@/		{ defs[DC] = $2; 
	 	  for (i = length($2)+1; i < 18; i++) 
		     defs[DC] = defs[DC] " ";
		  for (i = 3; i <= NF; i++)
		     strs[DC] = strs[DC] $i; 
		  DC++ 
		}
END		{ CNT = sprintf("MSG_COUNT") ;
		  printf("\nchar *msg_arr[] =\n{\n") >CFIL;
		  printf("\nextern char *msg_arr[];\n\n") >HFIL;
		  for (i = 0; i < DC; i++) 
		  {
		     if (i == 0)
			printf("#define %s%4s\n", defs[i], "0") >HFIL;
		     else
			printf("#define %s %4d\n", defs[i], -1*i) >HFIL;
		  }
		  printf("\n#define %s%4d\n\n#endif /* MSG_DEF */\n",CNT,DC) >HFIL;
		  for (i = 0; i < DC; i++)
		  {
		     if (i != DC - 1)
			strs[i] = strs[i]  "," ;
		     for (l = length(strs[i])+1; l < 50; l++)
			strs[i] = strs[i] " ";
		     printf("    %s /* %18s */\n", strs[i], defs[i]) >CFIL;
		  }
		  print "};" >CFIL;
		}

